# Because players technically "join" the server *after* the server/world loads the datapack, the following commands never set the scores on players. Thus, this setup function is delayed by a full 20 seconds to ensure all commands inside run as intended
# These scoreboard commands set the scores necessary to utilize some items. For players joining the world *after* the setup, there is a failsafe that updates the rmf.fryingProgress score when the player obtains the Frying Pan, which requires that score. The other scores are fine to update on their own and don't need failsafes

scoreboard players set @a rmf.roastingProgress 0
scoreboard players set @a rmf.recycle_bones 0
scoreboard players set @a rmf.mined_wheat 0
scoreboard players set @a rmf.mined_beetroots 0
scoreboard players set @a rmf.fryingProgress 0
scoreboard players set @a rmf.dropChance 0
scoreboard players set @a rmf.mined_grass 0
scoreboard players set @a rmf.mined_oak_leaves 0
scoreboard players set @a rmf.mined_acacia_leaves 0
scoreboard players set @a rmf.mined_cherry_leaves 0
scoreboard players set @a rmf.mined_jungle_leaves 0
scoreboard players set @a rmf.mined_mangrove_leaves 0
scoreboard players set @a rmf.mined_tall_grass 0
scoreboard players set @a rmf.mined_dark_oak_leaves 0
scoreboard players set @a rmf.mined_pale_oak_leaves 0
scoreboard players set @a rmf.mined_bush 0
scoreboard players set @a rmf.mined_fern 0

# If this is the FIRST TIME the data pack is being loaded on a world/server, send a nice message to all players currently online

execute unless score rmf.config rmf.worldLoaded matches 1 run function rmf:bg/welcome_message

# If this is the FIRST TIME the world has been loaded in the CURRENT RMF VERSION, let all players online know what's new to the update (this changes per update obviously)
# After the "what's new" text has been displayed, update the rmf.version score so it doesn't run a second time (scoreboards can't have decimals, so versions are written without them. "130" means "v1.3.0")

execute unless score rmf.config rmf.version matches 1301 run function rmf:bg/whats_new
execute unless score rmf.config rmf.worldLoaded matches 1 run scoreboard players set rmf.config rmf.version 1301

# ^ The reason this requires the world to not be loaded for the first time is because the rmf.update function will automatically update the version number when it's activated. If the version number was updated on load/setup before the player could activate the update function, it would break that function

# Once absolutely all commands and functions have been run sucessfully, we can now tell the datapack that the world has been loaded successfully and to update the scoreboard.
# This will only update if the world has never been loaded before in Reg's More Foods--in other words, if this is the first time it's been installed in world

execute if score rmf.config rmf.worldLoaded matches 0 run scoreboard players set rmf.config rmf.worldLoaded 1

# If the player has the Reg's Library data pack installed, give them an advancement
# (Reg's Library hasn't been created yet, but an advancement will be here when it is!)