# This function has been heavily simplified from earlier versions. It uses an advancement to detect when a player uses a Marshmallow on a Stick, and runs one of the following commands depending on what block the player is looking at.
# New entries can be added by copying one of the existing ones, and changing the block as well as what stage the marshmallow turns into. Note that the Marshmallow on a Stick cannot be consumed on its own--it must be cooked (or burned) before being edible.

# Command to allow the item to work on a cooldown.
schedule function rmf:bg/item_cooldown 10t append

# First, let's make sure they're standing in front of something they can roast on.
execute as @s unless block ^ ^1 ^ #rmf:can_roast_on run return run title @s actionbar {"translate": "chat.rmf.marshmallow_stick.no_heat","color":"red"}

# If the top command doesn't run, we check what block the player is trying to cook on. If they are standing in front of an acceptable block, add to their roastingProgress depending on said block.
# Campfire
execute as @s if block ^ ^1 ^ campfire[lit=true] run scoreboard players add @s rmf.roastingProgress 1
# Fire
execute as @s if block ^ ^1 ^ fire run scoreboard players add @s rmf.roastingProgress 1
# Soul Campfire
execute as @s if block ^ ^1 ^ soul_campfire[lit=true] run scoreboard players add @s rmf.roastingProgress 2
# Soul Fire
execute as @s if block ^ ^1 ^ soul_fire run scoreboard players add @s rmf.roastingProgress 2
# Magma Block
execute as @s if block ^ ^1 ^ magma_block run scoreboard players add @s rmf.roastingProgress 5
# Lava
execute as @s if block ^ ^ ^2 lava run scoreboard players add @s rmf.roastingProgress 5

# Lastly, we check if the player has a specific roastingProgress score. If they have reached one of the thresholds, replace their marshmallow with one of the variants.

# Cook it perfectly:
execute as @a[scores={rmf.roastingProgress=40..}] if items entity @s weapon.mainhand *[minecraft:custom_data~{"item_id":"rmf:marshmallow_stick"}] if block ^ ^1 ^ campfire[lit=true] run return run function rmf:bg/roasting/marshmallow_cook
execute as @a[scores={rmf.roastingProgress=40..}] if items entity @s weapon.mainhand *[minecraft:custom_data~{"item_id":"rmf:marshmallow_stick"}] if block ^ ^1 ^ fire run return run function rmf:bg/roasting/marshmallow_cook

# Burn that john:
execute as @a[scores={rmf.roastingProgress=40..}] if items entity @s weapon.mainhand *[minecraft:custom_data~{"item_id":"rmf:marshmallow_stick"}] if block ^ ^1 ^ soul_campfire[lit=true] run return run function rmf:bg/roasting/marshmallow_burn
execute as @a[scores={rmf.roastingProgress=40..}] if items entity @s weapon.mainhand *[minecraft:custom_data~{"item_id":"rmf:marshmallow_stick"}] if block ^ ^1 ^ soul_fire run return run function rmf:bg/roasting/marshmallow_burn

# It has become charcoal:
execute as @a[scores={rmf.roastingProgress=50..}] if items entity @s weapon.mainhand *[minecraft:custom_data~{"item_id":"rmf:marshmallow_stick"}] if block ^ ^1 ^ magma_block run return run function rmf:bg/roasting/marshmallow_incinerate

# If the player isn't standing in front of a block they can roast on, reset their progress
execute as @a[scores={rmf.roastingProgress=1..}] unless block ^ ^1 ^ #rmf:can_roast_on run scoreboard players set @s rmf.roastingProgress 0

# Once all the blocks have been checked, we can remove the advancement so the player can be checked again.
advancement revoke @s only rmf:bg/roast_item