# This function uses an advancement which checks if players break a specific block an advancement to run this function, which checks for the type of biome the player is in.
# If the player is in a biome which has an entry here and conditions to obtain it are met, roll a chance for the player to obtain one of the fruits/berries in the block broken.
# Important note: the biome checked is for the location of the PLAYER, not the BLOCK broken. A player could be standing in a snowy biome while breaking grass from a plains, and get Blackberry drops instead.

# First, activate set the drop chance for the player to a random number (out of 100%)
# This is the only time we do this, and it sets the random chance for all other checks associated with this function
execute store result score @s rmf.dropChance run random value 0..100

# Check for Strawberries
execute at @s if biome ~ ~ ~ #rmf:has_strawberries if score @s rmf.dropChance matches 0..12 run function rmf:give_item/strawberry {player:'@s',count:1}

# Check for Blueberries
execute at @s if biome ~ ~ ~ #rmf:has_blueberries if score @s rmf.dropChance matches 0..12 run function rmf:give_item/blueberry {player:'@s',count:1}

# Check for Raspberries
execute at @s if biome ~ ~ ~ #rmf:has_raspberries if score @s rmf.dropChance matches 0..12 run function rmf:give_item/raspberry {player:'@s',count:1}

# Check for Blackberries (Blackberries have a 9% chance to drop as opposed to other berries having 12%)
execute at @s if biome ~ ~ ~ #rmf:has_blackberries if score @s rmf.dropChance matches 0..9 run function rmf:give_item/blackberry {player:'@s',count:1}

# Check for Coffee Beans
execute at @s if biome ~ ~ ~ #rmf:has_coffee_beans if score @s rmf.dropChance matches 0..12 run function rmf:give_item/coffee_beans {player:'@s',count:1}

# Check for Tomato Seeds (These have a 1% chance to appear as long as the player isn't in a snowy biome or pale garden)
execute at @s unless biome ~ ~ ~ #rmf:has_blackberries unless biome ~ ~ ~ #rmf:has_pale_berries if score @s rmf.dropChance matches 0..1 run function rmf:give_item/tomato_seeds {player:'@s',count:1}

# Check for Pale Berries
execute at @s if biome ~ ~ ~ #rmf:has_pale_berries if score @s rmf.dropChance matches 0..12 run function rmf:give_item/pale_berries {player:'@s',count:1}

# To save space (and skip having to make extra files), run the alternate short_grass files for other drops here. Even if none of the entries in this file match or activate, the others might, so run them anyway
function rmf:bg/punnet/short_grass_taiga
function rmf:bg/punnet/short_grass_carrot
function rmf:bg/punnet/short_grass_potato

# The scores for this file are reset in short_grass_potato, since that's the last file that needs them.