# This file uses a mixture of the Juicer and the Shaker Cup's systems to create items using the Mixing Bowl. My previous method had too many holes (literally) and was annoying to work around. This is easier, despite how it looks.
# If you read the other files like this one, you'll know how to add your own entries. It's not too complicated, I know you'll be able to do it.

# Run this function on a cooldown.
schedule function rmf:bg/item_cooldown 10t replace

# Check for an empty hand. If offhand is empty when Mixing Bowl is used, and player is crouching, empty its contents if something is in it.
execute as @s if predicate rmf:empty_offhand if predicate rmf:is_crouching unless items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl"},minecraft:custom_data={"rmf_mixingBowlRecipe":""}] run return run function rmf:bg/mixing/empty


### Dough Crafting (Wheat Flour) ###

# Step 1
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:wheat_flour"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":""}] run return run function rmf:bg/mixing/dough_wheat_flour/craft1

# Step 2
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:water_barrel"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:dough"}] run return run function rmf:bg/mixing/dough_wheat_flour/craft2

### Dough Crafting (Taiga Flour) ###

# Step 1
# If the player isn't holding at least 2 of the ingredient, don't move to the next step
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:taiga_flour"},minecraft:count={max:2}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":""}] run return run title @s actionbar {"translate": "chat.rmf.mixing_bowl.need_more_items","color":"red"}
# If the player has at least 2, put them in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:taiga_flour"},minecraft:count={min:3}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":""}] run return run function rmf:bg/mixing/dough_taiga_flour/craft1

# Step 2
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:water_barrel"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:dough"}] run return run function rmf:bg/mixing/dough_taiga_flour/craft2


### Dragon Fruit Pie Crafting ###

# Step 1
# If the player isn't holding at least 3 of the ingredient, don't move to the next step
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:dragon_fruit"},minecraft:count={max:2}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":""}] run return run title @s actionbar {"translate": "chat.rmf.mixing_bowl.need_more_items","color":"red"}
# If the player has at least 3, put them in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:dragon_fruit"},minecraft:count={min:3}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":""}] run return run function rmf:bg/mixing/dragon_fruit_pie/craft1

# Step 2
# If the player isn't holding at least 2 of the ingredient, don't move to the next step
execute if items entity @s weapon.offhand sugar[minecraft:count={max:1}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:dragon_fruit_pie"}] run return run title @s actionbar {"translate": "chat.rmf.mixing_bowl.need_more_items","color":"red"}
# If the player has at least 2, put them in the bowl
execute if items entity @s weapon.offhand sugar[count={min:2}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:dragon_fruit_pie"}] run return run function rmf:bg/mixing/dragon_fruit_pie/craft2

# Step 3
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:milk_barrel"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:dragon_fruit_pie2"}] run return run function rmf:bg/mixing/dragon_fruit_pie/craft3

# Step 4
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:pie_crust"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:dragon_fruit_pie3"}] run return run function rmf:bg/mixing/dragon_fruit_pie/craft4

### Baked Beans Crafting ###

# Step 1
# If the player isn't holding at least 2 of the ingredient, don't move to the next step
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:taiga_beans"},minecraft:count={max:1}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":""}] run return run title @s actionbar {"translate": "chat.rmf.mixing_bowl.need_more_items","color":"red"}
# If the player has at least 2, put them in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:taiga_beans"},minecraft:count={min:2}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":""}] run return run function rmf:bg/mixing/baked_beans/craft1

# Step 2
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:seasoning"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:baked_beans"}] run return run function rmf:bg/mixing/baked_beans/craft2

# Step 3
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand mushroom_stew if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:baked_beans2"}] run return run function rmf:bg/mixing/baked_beans/craft3

### Fruitcake Crafting ###

# Step 1
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:pale_apple"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":""}] run return run function rmf:bg/mixing/fruitcake/craft1

# Step 2
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:peach"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:fruitcake"}] run return run function rmf:bg/mixing/fruitcake/craft2

# Step 3
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:orange"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:fruitcake2"}] run return run function rmf:bg/mixing/fruitcake/craft3

# Step 4
# If the player has the right item, put it in the bowl
execute if items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:dough"}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:fruitcake3"}] run return run function rmf:bg/mixing/fruitcake/craft4

# Step 5
# If the player isn't holding at least 2 of the ingredient, don't move to the next step
execute if items entity @s weapon.offhand sugar[minecraft:count={max:1}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:fruitcake4"}] run return run title @s actionbar {"translate": "chat.rmf.mixing_bowl.need_more_items","color":"red"}
# If the player has at least 2, put them in the bowl
execute if items entity @s weapon.offhand sugar[minecraft:count={min:2}] if items entity @s weapon.mainhand minecraft:firework_star[custom_data~{"item_id":"rmf:mixing_bowl","rmf_mixingBowlRecipe":"rmf:fruitcake4"}] run return run function rmf:bg/mixing/fruitcake/craft5

# If none of the above entries matched, the player isn't able to do any of the steps. Thus, this function continues to this last command
title @s actionbar {"translate":"chat.rmf.use_item.empty_hand","color":"red"}