# This file uses an advancement to detect when a player uses the Juicer, and then runs one of the following commands as long as they have at least 1 Glass Bottle in their inventory.
# Players can "juice" an item by holding at least 2 of that item in their offhand, and the Juicer in their mainhand. Then, they can press the "use" key to squeeze the ingredient(s).
# In all cases, the player always recieves the Juicer back into their inventory even if they can't juice anything (if they cannot fit it in their inventory, it is thrown on the floor).
# This function is designed to stop checking for items as soon as one entry is successful. That way--if NO entries are successful--the last command in the function is run, informing the player that they aren't holding at least 2 "juiceable" items in their offhand.
# Custom addons can create new entries by adding them to the following "Check for" list (just copy one of my entries here and customize it for your custom item). Set the "return" function to your custom item, and then copy one of my entries again for THAT and edit it for your custom juice/item.
# You're smart, you'll figure it out. I believe in you!

# We first want to run a schedule every 10 ticks that checks if players are still trying to juice something, and if they are, remove the advancement again. This allows the Juicer to be held down and continously juice things!
schedule function rmf:bg/item_cooldown 10t append
playsound rmf:item.juicer.shut player @a ~ ~ ~
# We then need to make sure the player has a Glass Bottle in their inventory. If they don't, just stop the function here and tell them they need at least one.
execute unless predicate rmf:has_glass_bottle run return run title @s actionbar {"translate":"chat.rmf.juicer.no_bottles","color":"red"}
# If everything above goes well, we can start checking for entry matches.

# --VANILLA ITEMS--
# Check for Melon Slices
execute if items entity @s weapon.offhand melon_slice[minecraft:count={min:2}] run return run function rmf:bg/juicing/melon_slice
# Check for Apples (because a few custom items share the apple namespace, we need to specify apples with NO custom data)
execute if items entity @s weapon.offhand apple[!minecraft:custom_data,minecraft:count={min:2}] run return run function rmf:bg/juicing/apple
# Check for Golden Apples
execute if items entity @s weapon.offhand golden_apple[minecraft:count={min:2}] run return run function rmf:bg/juicing/golden_apple
# Check for Enchanted Golden Apples (fancy)
execute if items entity @s weapon.offhand enchanted_golden_apple[minecraft:count={min:2}] run function rmf:bg/juicing/enchanted_golden_apple

# --DATAPACK ITEMS--
# Check for Peaches
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:peach"},minecraft:count={min:2}] run return run function rmf:bg/juicing/peach
# Check for Bananas
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:banana"},minecraft:count={min:2}] run return run function rmf:bg/juicing/banana
# Check for Mangoes
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:mango"},minecraft:count={min:2}] run return run function rmf:bg/juicing/mango
# Check for Oranges
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:orange"},minecraft:count={min:2}] run return run function rmf:bg/juicing/orange
# Check for Vibrant Apples (grapes)
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:vibrant_apple"},minecraft:count={min:2}] run return run function rmf:bg/juicing/vibrant_apple
# Check for Pale Apples (pineapples)
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:pale_apple"},minecraft:count={min:2}] run return run function rmf:bg/juicing/pale_apple
# Check for Pale Apples (pineapples)
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:prickly_pear"},minecraft:count={min:2}] run return run function rmf:bg/juicing/prickly_pear
# Check for Dragon Fruits
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:dragon_fruit"},minecraft:count={min:2}] run return run function rmf:bg/juicing/dragon_fruit

# If no entries matched, tell the player they need to get something they can actually juice (and give them another juicer)
title @s actionbar {"translate": "chat.rmf.juicer.fail","color":"red"}