# This function's job is setting up the Frying Pan to prepare to cook something.
# When a player has the "rmf:bg/frying_item" advancement (they are using the frying pan), it will trigger this advancement and start "heating" the frying pan if they are standing in front of a "frying" block.
# The frying pan checks every 2 ticks to see if the player is still trying to cook. If they are still trying to cook, keep increasing the until the timer hits 20. Once the timer hits 20, let them cook (lol)
# The frying pan can retain some of its "heat" so players who start cooking and stop for a brief moment can get right back to it, but if they walk away it will lose its heat and they'll have to re-heat the pan.

# If the player is standing in front of a block that can heat the frying pan, start warming up the pan to cook
execute at @s[scores={rmf.fryingProgress=..19}] if block ^ ^1 ^ #rmf:heats_frying_pan_if_lit[lit=true] run scoreboard players add @s rmf.fryingProgress 2
execute at @s[scores={rmf.fryingProgress=..19}] if block ^ ^1 ^ #rmf:heats_frying_pan_always run scoreboard players add @s rmf.fryingProgress 2

# If the player starts cooking, play a sound to indicate the frying pan is doing something so they aren't confused (but make sure they're holding something fryable so it doesn't play for no reason)
playsound rmf:item.frying_pan.cook player @a[predicate=rmf:frying_pan_cookable,scores={rmf.fryingProgress=2}] ~ ~ ~ .5

# If the player is trying to fry something but isn't standing in front of something that can heat the Frying Pan, yell at them until they do
execute at @s unless block ^ ^1 ^ #rmf:can_heat_frying_pan run title @s actionbar {"translate":"chat.rmf.frying_pan.no_heat","color":"red"}

# If the player is trying to fry something but isn't holding something they can cook in the Frying Pan, yell at them until they do
execute unless predicate rmf:frying_pan_cookable run title @s actionbar {"translate":"chat.rmf.frying_pan.no_item","color":"red"}

# If the player has reached max fryingProgress, send them to the frying recipes function to decide their fate (what item gets cooked). Then, schedule a checkfor function to make sure they're still trying to cook
execute if score @s rmf.fryingProgress matches 100.. run function rmf:bg/frying/_recipes
schedule function rmf:bg/frying/checkfor 2t