# This function uses a predicate that detects if the player is holding a valid "fryable" ingredient in their offhand, as well as a scoreboard for detecting their "frying progress", to allow them to cook an item using one of the "heat sources" below.
# Different "heat source" blocks will increase the scoreboard at different speeds. For instance, a Campfire will increase the scoreboard by 1 while a Soul Campfire will increase it by 2. The "hotter" the block, the faster it will "fry" the item. This can be seen easily by looking at the number following "rmf.fryingProgress" for each roastable block.
# Once the rmf.fryingProgress is more than 1, we can set the score to 0 whenever players AREN'T trying to cook anything
# Like the rest of the data pack, this functionality is designed to be easy to code and replace. If a player wishes to add their own roastable block, they can copy what I've done here.
#
# Lower the player's rmf.fryingProgress score if they AREN'T trying to cook anything
execute as @a[scores={rmf.fryingProgress=1..}] at @s unless block ^ ^1 ^ #rmf:can_heat_frying_pan run scoreboard players set @s rmf.fryingProgress 0
# Campfire
execute as @a[predicate=rmf:frying_pan_cookable,advancements={rmf:bg/frying_item=true},scores={rmf.fryingProgress=20..99}] at @s if block ^ ^1 ^ campfire[lit=true] run scoreboard players add @s rmf.fryingProgress 1
# Fire
execute as @a[predicate=rmf:frying_pan_cookable,advancements={rmf:bg/frying_item=true},scores={rmf.fryingProgress=20..99}] at @s if block ^ ^1 ^ fire run scoreboard players add @s rmf.fryingProgress 1
# Furnace
execute as @a[predicate=rmf:frying_pan_cookable,advancements={rmf:bg/frying_item=true},scores={rmf.fryingProgress=20..99}] at @s if block ^ ^1 ^ furnace[lit=true] run scoreboard players add @s rmf.fryingProgress 1
# Smoker
execute as @a[predicate=rmf:frying_pan_cookable,advancements={rmf:bg/frying_item=true},scores={rmf.fryingProgress=20..99}] at @s if block ^ ^1 ^ smoker[lit=true] run scoreboard players add @s rmf.fryingProgress 1
# Soul Campfire
execute as @a[predicate=rmf:frying_pan_cookable,advancements={rmf:bg/frying_item=true},scores={rmf.fryingProgress=20..99}] at @s if block ^ ^1 ^ soul_campfire[lit=true] run scoreboard players add @s rmf.fryingProgress 2
# Soul Fire
execute as @a[predicate=rmf:frying_pan_cookable,advancements={rmf:bg/frying_item=true},scores={rmf.fryingProgress=20..99}] at @s if block ^ ^1 ^ soul_fire run scoreboard players add @s rmf.fryingProgress 2
# Magma Block
execute as @a[predicate=rmf:frying_pan_cookable,advancements={rmf:bg/frying_item=true},scores={rmf.fryingProgress=20..99}] at @s if block ^ ^1 ^ magma_block run scoreboard players add @s rmf.fryingProgress 3
# Blast Furnace
execute as @a[predicate=rmf:frying_pan_cookable,advancements={rmf:bg/frying_item=true},scores={rmf.fryingProgress=20..99}] at @s if block ^ ^1 ^ blast_furnace[lit=true] run scoreboard players add @s rmf.fryingProgress 3
