# This function is part of a system that allows for frying items in the Frying Pan.
# After the player's Frying Pan has been heated enough to cook an item, and they have max fryingProgress, search this list for an entry.
# If they are holding an item that matches one in the list, stop the function on that entry and run the command. This is to prevent the function from searching EVERY entry even after we have the one we want.
# Addon/Mod devs need to add their items to the "frying_pan_cookable" item tag before creating an entry for them if they want the frying pan to cook them.
# This function is split between 2 sections--Vanilla Items, and Datapack Items. It makes it easier to see what's doing what and where it's doing it when you look at the file!

# -- VANILLA ITEMS --
# Items whoses ingredients are vanilla, even if the result isn't
# Cooked Beef
execute if items entity @s weapon.offhand beef run return run function rmf:bg/frying/beef
# Cooked Porkchop
execute if items entity @s weapon.offhand porkchop run return run function rmf:bg/frying/porkchop
# Cooked Mutton
execute if items entity @s weapon.offhand mutton run return run function rmf:bg/frying/mutton
# Cooked Rabbit
execute if items entity @s weapon.offhand rabbit run return run function rmf:bg/frying/rabbit
# Cooked Chicken
execute if items entity @s weapon.offhand chicken run return run function rmf:bg/frying/chicken
# Cooked Cod
execute if items entity @s weapon.offhand cod run return run function rmf:bg/frying/cod
# Cooked Salmon
execute if items entity @s weapon.offhand salmon run return run function rmf:bg/frying/salmon
# Fried Eggs - Egg (cooking any type of egg will turn it into fried eggs when used in a frying pan)
execute if items entity @s weapon.offhand egg run return run function rmf:bg/frying/egg
# Fried Eggs - Brown Egg (cooking any type of egg will turn it into fried eggs when used in a frying pan)
execute if items entity @s weapon.offhand brown_egg run return run function rmf:bg/frying/brown_egg
# Fried Eggs - Blue Egg (cooking any type of egg will turn it into fried eggs when used in a frying pan)
execute if items entity @s weapon.offhand blue_egg run return run function rmf:bg/frying/blue_egg
# Zombie Jerky
execute if items entity @s weapon.offhand rotten_flesh run return run function rmf:bg/frying/rotten_flesh
# Roasted Carrot
execute if items entity @s weapon.offhand carrot run return run function rmf:bg/frying/carrot
# Honeycomb Candy
execute if items entity @s weapon.offhand honeycomb run return run function rmf:bg/frying/honeycomb

# -- DATAPACK ITEMS --
# Items whoses ingredients aren't vanilla, even if their results are
# Cooked Pufferfish Tail
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:pufferfish_tail"}] run return run function rmf:bg/frying/pufferfish_tail
# Corn on the Cob (Cooked Corn)
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:corn"}] run return run function rmf:bg/frying/corn
# Popped Corn
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:popcorn_seeds"}] run return run function rmf:bg/frying/popcorn_seeds
# Cooked Ham
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:ham"}] run return run function rmf:bg/frying/ham
# Cooked Bacon
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:bacon"}] run return run function rmf:bg/frying/bacon
# Cooked Chicken Wing
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:chicken_wing"}] run return run function rmf:bg/frying/chicken_wing
# Fried Tofu
execute if items entity @s weapon.offhand poisonous_potato run return run function rmf:bg/frying/tofu
# Omelette
execute if items entity @s weapon.offhand *[minecraft:custom_data~{"item_id":"rmf:raw_omelette"}] run return run function rmf:bg/frying/raw_omelette

# If for some horrid reason the player is able to run this function WITHOUT passing any of the entries here, just reset their fryingProgress and hope this works itself out
scoreboard players set @s rmf.fryingProgress 0