# This file uses an advancement to detect when a player is trying to use an Item Crate, and then runs one of the following commands.
# Players can use the Item Crate by holding at least 9 of a valid ingredient in their offhand, and an Item Crate in their mainhand. Then, they can press the "use" key to place the ingredients into the Item Crate. This is so players can store their ingredients in mass the same way they can compact ores and materials into blocks!
# This function is designed to stop checking for items as soon as one entry is successful. That way--if NO entries are successful--the last command in the function is run, informing the player of what they may be doing wrong.
# Custom addons can create new entries by adding them to the following "Check for" list (just copy one of my entries here and customize it for your custom item). Set the "return" function to your custom item, and then copy one of my entries again for THAT and edit it for your custom crate/item.
# You're smart, you'll figure it out. I believe in you!

# We first want to run a schedule every 10 ticks that checks if players are still trying to store something in an Item Crate, and if they are, remove the advancement again. This allows the Item Crate to be held down and continously crate things!
schedule function rmf:bg/item_cooldown 10t append

# Then, we want to see if they're even holding anything in their offhand. If they aren't, yell at them about it
execute if predicate rmf:empty_offhand run return run title @s actionbar {"translate":"chat.rmf.use_item.empty_hand","color":"red"}

# If they're holding something in the offhand, and it isn't a valid ingredient that can be stored in an Item Crate (including custom items!), play a sound and yell at them specifically about that
execute unless items entity @s weapon.offhand #rmf:item_crate_storable unless items entity @s weapon.offhand *[custom_data~{item_tags:[{"rmf":"item_crate_storable"}]}] run playsound rmf:item.item_crate.fail player @a ~ ~ ~
execute unless items entity @s weapon.offhand #rmf:item_crate_storable unless items entity @s weapon.offhand *[custom_data~{item_tags:[{"rmf":"item_crate_storable"}]}] run return run title @s actionbar {"translate":"chat.rmf.item_crate.invalid_item","color":"red"}
# If everything above goes well, we can start checking for entry matches.

# Annoyingly, there is an edge case with Charcoal on a Sticks and having the same NBT id as Charcoal. So, check for it here
execute if items entity @s weapon.offhand charcoal[custom_data={item_id:"rmf:incinerated_marshmallow_stick"}] run playsound rmf:item.item_crate.fail player @a ~ ~ ~
execute if items entity @s weapon.offhand charcoal[custom_data={item_id:"rmf:incinerated_marshmallow_stick"}] run return run title @s actionbar {"translate":"chat.rmf.item_crate.invalid_item","color":"red"}
# If everything above goes well, we can start checking for entry matches.

# --VANILLA ITEMS--

# Check for Apples
execute if items entity @s weapon.offhand apple[minecraft:count={min:9},!custom_data] run return run function rmf:bg/crating/apple
# Check for Beef
execute if items entity @s weapon.offhand beef[minecraft:count={min:9}] run return run function rmf:bg/crating/beef
# Check for Blue Eggs
execute if items entity @s weapon.offhand blue_egg[minecraft:count={min:9}] run return run function rmf:bg/crating/blue_egg
# Check for Brown Eggs
execute if items entity @s weapon.offhand brown_egg[minecraft:count={min:9}] run return run function rmf:bg/crating/brown_egg
# Check for Brown Mushrooms
execute if items entity @s weapon.offhand brown_mushroom[minecraft:count={min:9}] run return run function rmf:bg/crating/brown_mushroom
# Check for Carrots
execute if items entity @s weapon.offhand carrot[minecraft:count={min:9}] run return run function rmf:bg/crating/carrot
# Check for Charcoal
# Charcoal needs to specifically check for it NOT being Charcoal on a Stick, since it uses the same item id NBT data
execute if items entity @s weapon.offhand charcoal[minecraft:count={min:9},!custom_data={item_id:"rmf:burned_marshmallow_stick"}] run return run function rmf:bg/crating/charcoal
# Check for Chicken
execute if items entity @s weapon.offhand chicken[minecraft:count={min:9}] run return run function rmf:bg/crating/chicken
# Check for Cocoa Beans
execute if items entity @s weapon.offhand cocoa_beans[minecraft:count={min:9}] run return run function rmf:bg/crating/cocoa_beans
# Check for Cod
execute if items entity @s weapon.offhand cod[minecraft:count={min:9}] run return run function rmf:bg/crating/cod
# Check for Eggs
execute if items entity @s weapon.offhand egg[minecraft:count={min:9}] run return run function rmf:bg/crating/egg
# Check for Glow Berries
execute if items entity @s weapon.offhand glow_berries[minecraft:count={min:9}] run return run function rmf:bg/crating/glow_berries
# Check for Mutton
execute if items entity @s weapon.offhand mutton[minecraft:count={min:9}] run return run function rmf:bg/crating/mutton
# Check for Porkchop
execute if items entity @s weapon.offhand porkchop[minecraft:count={min:9}] run return run function rmf:bg/crating/porkchop
# Check for Potatoes
execute if items entity @s weapon.offhand potato[minecraft:count={min:9}] run return run function rmf:bg/crating/potato
# Check for Rabbit
execute if items entity @s weapon.offhand rabbit[minecraft:count={min:9}] run return run function rmf:bg/crating/rabbit
# Check for Red Mushrooms
execute if items entity @s weapon.offhand red_mushroom[minecraft:count={min:9}] run return run function rmf:bg/crating/red_mushroom
# Check for Salmon
execute if items entity @s weapon.offhand salmon[minecraft:count={min:9}] run return run function rmf:bg/crating/salmon
# Check for Sugar Cane
execute if items entity @s weapon.offhand sugar_cane[minecraft:count={min:9}] run return run function rmf:bg/crating/sugar_cane
# Check for Sweet Berries
execute if items entity @s weapon.offhand sweet_berries[minecraft:count={min:9}] run return run function rmf:bg/crating/sweet_berries
# Check for Wheat Seeds
execute if items entity @s weapon.offhand wheat_seeds[minecraft:count={min:9}] run return run function rmf:bg/crating/wheat_seeds
# Check for Melon Seeds
execute if items entity @s weapon.offhand melon_seeds[minecraft:count={min:9}] run return run function rmf:bg/crating/melon_seeds
# Check for Pumpkins
execute if items entity @s weapon.offhand pumpkin[minecraft:count={min:9}] run return run function rmf:bg/crating/pumpkin
# Check for Pumpkin Seeds
execute if items entity @s weapon.offhand pumpkin_seeds[minecraft:count={min:9}] run return run function rmf:bg/crating/pumpkin_seeds
# Check for Tomato Seeds (technically beetroot seeds)
# Due to the custom data Tomato Seeds have, giving the item after using the Item Crate actually runs a function from a detecting advancement to make life easier
execute if items entity @s weapon.offhand beetroot_seeds[minecraft:count={min:9}] run return run function rmf:bg/crating/tomato_seeds
# Check for Tomatos (technically beetroots)
# Due to the custom data Tomatos have, giving the item after using the Item Crate actually runs a function from a detecting advancement to make life easier
execute if items entity @s weapon.offhand beetroot[minecraft:count={min:9}] run return run function rmf:bg/crating/tomato
# Check for Bottles of Vinegar
# Because Vinegar is just Dragon's Breath, it's easier to detect it using its actual ID rather than a custom one
execute if items entity @s weapon.offhand danger_pottery_sherd[minecraft:count={min:9}] run return run function rmf:bg/crating/vinegar
# Check for Pufferfish
execute if items entity @s weapon.offhand pufferfish[minecraft:count={min:9}] run return run function rmf:bg/crating/pufferfish
# Check for Nether Wart
execute if items entity @s weapon.offhand nether_wart[minecraft:count={min:9}] run return run function rmf:bg/crating/nether_wart

# --DATAPACK ITEMS--
# Datapack items were originally seperated from vanilla ones because of how they were given to players, but as of v1.3.0b this system has changed. But they're still seperated for the sake of organization!

# Check for Oranges
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:orange"}] run return run function rmf:bg/crating/orange
# Check for Vibrant Apples
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:vibrant_apple"}] run return run function rmf:bg/crating/vibrant_apple
# Check for Pale Apples
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:pale_apple"}] run return run function rmf:bg/crating/pale_apple
# Check for Mangoes
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:mango"}] run return run function rmf:bg/crating/mango
# Check for Banana
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:banana"}] run return run function rmf:bg/crating/banana
# Check for Peaches
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:peach"}] run return run function rmf:bg/crating/peach
# Check for Coconut
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:coconut"}] run return run function rmf:bg/crating/coconut
# Check for Coffee Beans
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:coffee_beans"}] run return run function rmf:bg/crating/coffee_beans
# Check for Strawberries
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:strawberry"}] run return run function rmf:bg/crating/strawberry
# Check for Blueberries
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:blueberry"}] run return run function rmf:bg/crating/blueberry
# Check for Raspberries
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:raspberry"}] run return run function rmf:bg/crating/raspberry
# Check for Blackberries
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:blackberry"}] run return run function rmf:bg/crating/blackberry
# Check for Maize
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:corn"}] run return run function rmf:bg/crating/corn
# Check for Popcorn Seeds
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:popcorn_seeds"}] run return run function rmf:bg/crating/popcorn_seeds
# Check for Popcorn Bags
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:popcorn_bag"},!custom_model_data] run return run function rmf:bg/crating/popcorn_bag
# Check for Rice Grain
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:rice"}] run return run function rmf:bg/crating/rice
# Check for Pasta
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:pasta"}] run return run function rmf:bg/crating/pasta
# Check for Assorted Seasoning
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:seasoning"}] run return run function rmf:bg/crating/seasoning
# Check for Barrels of Water
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:water_barrel"}] run return run function rmf:bg/crating/water_barrel
# Check for Barrels of Milk
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:milk_barrel"}] run return run function rmf:bg/crating/milk_barrel
# Check for Vegetable Oil
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:vegetable_oil"}] run return run function rmf:bg/crating/vegetable_oil
# Check for Bone-In Ham
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:ham"}] run return run function rmf:bg/crating/ham
# Check for Dragon Fruit
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:dragon_fruit"}] run return run function rmf:bg/crating/dragon_fruit
# Check for Salt
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:salt"}] run return run function rmf:bg/crating/salt
# Check for Taiga Beans
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:taiga_beans"}] run return run function rmf:bg/crating/taiga_beans
# Check for Item Crates (because funny)
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:item_crate"}] run return run function rmf:bg/crating/item_crate
# Check for Item Crates with Item Crates inside them (you madman)
execute if items entity @s weapon.offhand *[minecraft:count={min:9},custom_data~{"item_id":"rmf:item_crate_crate"}] run return run title @s actionbar {"translate":"chat.rmf.item_crate.crateception","color":"red"}

# If no entries matched, tell the player they need to get enough of the item to store it in an Item Crate (also play a sound!)
title @s actionbar {"translate":"chat.rmf.item_crate.not_enough_items","color":"red"}
playsound rmf:item.item_crate.fail player @a ~ ~ ~