# This file uses an advancement to detect when a player is trying to use a Popcorn Bag to see how much the Popcorn should be filled with... well, popcorn.
#
# We first want to run a schedule every 10 ticks that checks if players are still trying to bag some popcorn, and if they are, remove the advancement again. This allows the Popcorn Bag to be held down and continously bag things!
schedule function rmf:bg/bag_cooldown 10t append
#
# Then, we want to see if they're even holding Popped Corn in their offhand. If they aren't, yell at them about it
execute unless items entity @s weapon.offhand *[custom_data~{"item_id":"rmf:popped_corn"}] run return run title @s actionbar {"translate":"chat.rmf.popcorn_bag.no_corn","color":"red"}
#
# If everything above goes well, we can start checking for entry matches.
#
# Has 3 Popped Corn
execute if items entity @s weapon.offhand *[minecraft:count=3,custom_data~{"item_id":"rmf:popped_corn"}] run return run function rmf:bg/popcorn_bag/small
# Has 6 Popped Corn
execute if items entity @s weapon.offhand *[minecraft:count=6,custom_data~{"item_id":"rmf:popped_corn"}] run return run function rmf:bg/popcorn_bag/medium
# Has 9 Popped Corn
execute if items entity @s weapon.offhand *[minecraft:count=9,custom_data~{"item_id":"rmf:popped_corn"}] run return run function rmf:bg/popcorn_bag/large
#
# If no entries matched (because they aren't holding a specific amount of Popped Corn), tell the player they need a specific amount of Popped Corn to use the Popcorn Bag
title @s actionbar {"translate":"chat.rmf.popcorn_bag.not_enough_corn","color":"red"}