# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project *loosely* adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).
The main difference is that the MAJOR.MINOR.PATCH system doesn't change the MAJOR indicator, as most version changes are NOT backwards compatible and the MINOR indicator will increase regardless of if that version can be played in an earlier update.
However, if the version update is a bug fix/patch/update that does NOT change the resourcepack or datapack format, and does NOT otherwise add anything, then the PATCH indicator will be updated accordingly.
TL;DR: This pretty much follows Mojang's update structure for Minecraft updates.

Anything noted as (Undocumented) is because I didn't write down the change at that time and can't remember what was added/removed/edited. Sorry.

Update numbers are written in YYYY/MM/DD format.

## [1.3.0b] - 2026-01-08

### Added
#### Foods
24+ new foods have been added in this update:
- Added Burned Marshmallow on a Sticks
  - These are the same as Roasted Marshmallow on a Sticks, but they're a little extra crunchy
  - They restore 3 Nutrition and 2 Saturation, but apart from that, they function identically to Roasted Marshmallow on a Sticks and can be used to make Marshmallow Sandwiches
  - To obtain them, roast a Marshmallow Stick over a Soul Campfire instead of a regular one
- Added Peanuts
  - Peanuts are found in Bush blocks when Punnet Gathering, and are a light snack that can be eaten whenever
  - They restore 3 Nutrition and 2 Saturation when consumed, and are currently not used for anything else :c
    - Thankfully, peanut allergies don't exist in Minecraft.
- Added Pale Berries (Suggested by ButterScotch)
  - These monochrome berries have been discovered in the odd Pale Garden, and they are surprisingly edible!
  - Eating one restores 2 Nutrition and 1 Saturation, however there's a 10% it might poison you
    - This makes it unusable to make into anything else as the poison would persist, but they're good for eating in a pinch or emergency
  - They're inspired by real life Belladonna berries (which ARE poisonous!), but thankfully Pale Berries are usually safe to eat. Usually.
  - Like the other berries, Pale Berries can be crafted from Gray Dye, Sweet Berries, and Bone Meal if players are unable to find a Pale Garden biome
- Added Bars of Granola
  - This forest snack is all a lumberjack needs to start their day!
  - Crafted from 6 Wheat, 2 Seeds, and a Honey Bottle, you'll make 3 yummy Granola Bars
- Added Bowls of Mashed Potatoes (Suggested by Zeuseon)
  - Another addition that should've been added ages ago, Mashed Potatoes are a simple but great meal that's easy to make (provided you have the ingredients)
  - It's crafted from 2 Potatoes, Assorted Seasoning, a Milk Bucket, and a Bowl
  - Eating it restores 9 Nutrition and 7 Saturation, making it a plain but effective food for any situation
- Added Rice Cakes
  - Have a surplus of Rice Grains? Make some Rice Cakes!
  - These snacks restore 5 Nutrition and 6 Saturation when eaten
  - Crafting them only requires 3 Rice Grain, Assorted Seasoning, a Water Bucket, 2 Wheat, and 2 Eggs. This creates 3 Rice Cakes for sharing with whomever you please (or just yourself)
- Added Bowls of Spaghetti
  - Not much needs to be said about this dish, besides "it tastes great" and "is quite filling".
  - Bowls of Spaghetti restore 9 Nutrition and 10 Saturation when consumed, but take 2 seconds to eat (it's a lot of food!)
  - They can be crafted from Assorted Seasoning, Tomato Sauce, Pasta (obviously), any raw meat, and a Bowl
    - Before you ask "where's the meat in the bowl?", it's under the sauce
- Added Omelettes
  - You know, I always thought these were kinda like an Egg Burrito or something. Anyways
  - Eating an Omelette will restore 8 Nutrition and 6 Saturation
  - They are made from frying a Bowl of Raw Omelette in the Frying Pan
- Added Dragon Fruit
  - These strange fruits haven't been seen since the apperance of the Ender Dragon, but can be recreated using a rather odd ingredient.
  - By soaking a Chorus Fruit in Water, and adding Dragon's Breath to the mix, you can create some!
  - Consuming Dragon's Fruit restores 6 Nutrition and 4 Saturation, and can be stored in Item Crates
- Added Dragon Fruit Juice
  - Juiced freshly from 2 Dragon Fruits, this drink restores 8 Nutrition and 6 Saturation
  - It supposedly has a bit of a tangy flavor?
- Added Dragon Fruit Smoothies
  - Crafted just like all other smoothies, except that it uses Dragon Fruit Mash instead
  - Restores 7 Nutrition and 6 Saturation when consumed
- Added Dragon Fruit Pie
  - This very fulling pie restores 12 Nutrition and 9 Saturation, but must be created inside the Mixing Bowl
  - It requires 3 Dragon Fruits, 2 Sugar, 1 Milk, and Pie Crust
- Added Monster Jerky
  - What if you could cure Rotten Flesh to prevent hunger entirely? Well, now you can!
  - By combining Rotten Flesh and 2 Salt, you can cure it into a safe food
  - Monster Jerky restores 4 Nutrition and 3 Saturation when consumed and won't afflict you with hunger. Though you may want a glass of water after
- Added Nether Wart Soup
  - Have a lot of nether wart and don't know what to do with it? Why not eat it?
  - Cooking (crafting) together 2 Nether Wart, a Brown or Red Mushroom, and a Bowl will create this interesting meal
  - It restores 4 Nutrition and 6 Saturation when consumed and grants Regeneration for 1 minute
    - It's handy to eat when you need passive healing but have to keep moving!
- Added Miso Soup (thanks drunk_experiter!)
  - This dish is known by many, and is easy to make with searching a little for ingredients
  - It's crafted from Water, Kelp (or Lettuce), Seasoning, Tofu, and a Bowl
  - Consuming it restores 6 Nutrition and 8 Saturation
- Added Sushi Logs
  - I'll be honest. At some point in development, I added this item (I assume as a better version of Sushi?) and completely forgot to write it down. Then I found it again. So, here it is!
  - The proper name of this item would be Futomaki, but there's no international translation for it that I could find, and "Long Sushi Roll" was a silly name.
  - Sushi Logs restore 8 Nutrition and 7 Saturation when consumed
  - They're crafted just like Sushi, but use 3 extra Dried Kelp. Useful if you have a lot of kelp and just want the bonus food!
- Added Wild Carrots and Wild Potatoes
  - When foraging with a Punnet, players can now find Wild Carrots or Wild Potatoes (provided they aren't in a desert biome)
  - These wild crops function just like their normal counterparts (they can be eaten, cooked, planted, or crafted with). This is to make it easier to obtain these ingredients instead of having to wait for zombie drops or finding villages
  - They are essencially found in any biome that has Strawberries, Blackberries, Raspberries, or Blueberries
- Added Baked Beans (thanks kianzozow!)
  - Using some (2) Taiga Beans, Assorted Seasoning, and a bowl of Mushroom Stew, you can make yourself a bowl of beans!
  - Baked Beans restore 6 Nutrition and 8 Saturation when consumed
  - To craft them, you'll first need to make some Unbaked Beans by using the above ingredients in a Mixing Bowl (in the same order shown) and then cook them in a Baking Pan
- Added Sweet Berry Pie & Glow Berry Pie (suggested by a friend--thanks!)
  - From the creators of Apple Pie and Pies in general--a new kind of pie hits your kitchen!
  - Sweet Berry Pie and Glow Berry pie are crafted similarly. Either 3 of a respective berry, Sugar, Dough, and an Egg
  - They both restore 8 Nutrition and 7 Saturation when consumed, though Glow Berry Pie might make you shine a bit
- Added Bowls of Curry
  - Want a spicy meal that doesn't shut down your organs like Spicy Mushroom Stew? Try Curry!
  - Curry is crafted like Fried Rice, but swap out the Carrot and Egg for Crimson and Warped Fungus
  - When consumed, it restores 7 Nutrition and 8 Saturation, then applies 20 seconds of Resistance and Hunger
- Added Fruitcake
  - Just in time for the holiday season! This famous (or should I say infamous?) seasonal food makes its appearance in Reg's More Foods!
  - Fruitcake must first be made from baking Unbaked Fruitcake in a Baking Pan
  - When consumed, it restores 12 Nutrition and 10 Saturation but takes 2.4 seconds to consume and can only stack to 16
  - Fruitcake can be displayed in an Item Frame, and looks great on a dinner table!
- Added Iced Tea
  - Similar to regular Tea, players can drink Iced Tea to keep themselves cool in hot environments
  - Iced Tea is crafted just like Tea, but with either Ice or Packed Ice added to the recipe
  - It gives a lower level of Haste than Tea does, but grants 1 minute (and 30 seconds) of Fire Resistance
- Added Barrel of Radioactive Waste (Admin Item)
  - Someone asked for this.
  - Placing this item in an item frame will display it
  - It can be spawned in with the item id `rmf:radioactive_waste` via the `rmf:_give_item` function
  - Do not consume this

#### Items
19 new items have been added in this update:
- Added Cutting Boards (thanks soloischilling!)
  - The Cutting Board is a special tool used for cutting smaller foods into other foods, basically a smaller version of the Stonecutter
  - Some items (like Melons or Pumpkins) must still be cut in the Stonecutter due to their size
  - The Cutting Board uses Manual Crafting (or Interactive Crafting), meaning it works by having an ingredient in the offhand and uses the board in the mainhand
  - To craft the Cutting Board, use 2 Iron, a Diamond, a Stick, and any wooden slab. The Cutting Board takes 0 durability damage from any usages
    - Because the Cutting Board works like most other utility items in Reg's More Foods, its recipes can be easily edited or added to using an addon
- Added Biomass
  - Biomass is an organic item that can be used as fuel for Furnaces, Blast Furnaces, and Smokers
  - Only one ingredient can be smelted per Biomass item, so it's best to make Biomass out of excess ingredients rather than mass create it due to it not being a great fuel source
  - It's crafted from 3 Pasta, Rice Grain, Lettuce Leafs, or Bone Meal and at least 1 Leaf Litter or Lettuce Leaf
  - It can only be used as fuel on its own, but can be ground in a Mortar & Pestle into Biomash
- Added Biomash
  - Biomash is a mashed version of Biomass that is too small to be used effectively as Furnace fuel, so instead it can only be composted into Bone Meal
  - It is obtained from grinding Biomass in a Mortar & Pestle, which returns 3 Biomash items
    - NOTE: Parrots do not like the taste of Biomash, and will instantly perish upon tasting it. Please do not feed your parrots Biomash
- Added Bowls of Dog Food
  - Dog Food is a unique item exclusive to Wolfs. It doesn't do anything special for them when eaten, but it looks cool and makes them happy!
  - Please note that Dog Food is meant for dogs. Please refrain from eating Dog Food.
- Added Bowls of Raw Omelette
  - To craft Omelettes, players must first make a bowl of the raw ingredients
  - It's crafted from an Assorted Seasoning, 2 Eggs, a variety of fillings (from mushrooms, to raw meats, to vegetables!), and a Bowl
  - Obviously, the Bowl of Raw Omelette cannot be eaten on its own. It must be fried in the Frying Pan to become an Omelette, which can be eaten
- Added Salt
  - Salt is a new ingredient created from burning away salt water (water barrels) in a Furnace or Blast Furnace
  - Smelting Water Barrels in a Furnace is slow, but doing so in a Blast Furnace is much faster though requires more fuel. Either way, each barrel of water yields one Salt for use in crafting
  - Salt is used and required to craft Assorted Seasoning, replacing Gunpowder in the recipe (no more "crunchy" flavors!) and can be placed in Item Crates
- Added Baking Pans
  - The discovery of new recipes means a new kind of kitchen tool must be utilized! Sadly, the Frying Pan simply won't do.
  - To this end, players can now craft the Baking Pan, a (much hotter!) version of the Frying Pan which works identically to it
  - It is crafted from 1 Leather, 4 Nether Bricks, and 4 Copper Ingots (which works as a thermal conductor)
  - Although made of Nether Bricks, the Baking Pan is actually quite fragile. It only has 80 durability (and takes twice as much damage when used as a weapon!), though deals more damage than the Frying Pan
  - Baking Pans also come with natural Fire Aspect due to their heat retention
    - Because of this, players who want to take advantage of the increased damage should consider enchanting it with Unbreaking, or keeping spare Nether Bricks to repair it
  - Baking Pans require a lot of heat to cook their food, and as such cannot be used on Fire or Campfire blocks (though Soul Fire/Soul Campfires should get the job done a-ok)
    - Blast Furnaces and Magma Blocks will still cook foods, but at a reduced effect (still faster than using a Furnace/Smoker)
- Added Salt & Seasoning (Decorative)
  - A cute set of Salt and Seasoning bottles that can be placed on a countertop.
  - Crafted from Salt, Seasoning, and an Item Frame
- Added Glass Bottle Displays (Decorative)
  - A model of a Glass Bottle that can be placed on a countertop.
  - Crafted from a Glass Bottle and an Item Frame
  - Can be used as a makeshift space helmet if necessary
- Added Triple Glass Bottle Displays (Decorative)
  - A model of 3 Glass Bottles that can be placed on a countertop.
  - Crafted from 3 Glass Bottles and an Item Frame
- Added Mixing Bowls
  - The Mixing Bowl is a new item designed to help players craft recipes that require custom ingredients, such as Strawberries, Bananas, Peanuts, and pretty much every custom ingredient added by Reg's More Foods.
  - Using the bowl will bring up a menu of recipes for crafting, seperated by food classification. If a player is able to craft one, clicking it will craft the recipe (once at a time)
    - Unlike the Shaker Cup, simply having all the ingredients in the inventory will be enough for crafting instead of having to add them one at a time
    - Because of this, it's important to be careful of what ingredients one has in their inventory before crafting to avoid accidentally using ingredients meant for something else
  - It is crafted from 5 Wooden Planks and 1 Bowl
- Added Powder Snow Slabs
  - Powder Snow Slabs make storing a lot of Powder Snow easy!
  - 2 of them can be crafted from just 1 Powder Snow Bucket, and can be used in place of Powder Snow in recipes
    - Do note that placing a Powder Snow Slab will, well, place and waste the slab. Please be careful when handling them!
- Added Pie Crusts
  - Pie Crust is a new ingredient required to make certain Pies in the Mixing Bowl
  - It is easily crafted from putting Dough in the Stonecutter and selecting it
  - Other pies can also be made in the Mixing Bowl using Pie Crust, which saves on ingredients
  - Foods made with Pie Crusts will obviously need to be baked first before they can be eaten, so these raw pie items won't be mentioned here
- Added Taiga Beans (thanks kianzozow!)
  - Taiga Beans, inspired by real life Navy Beans, can be found in any non-snowy Taiga biome when using a Punnet
    - In the event that a regular Taiga biome is not available to players, it can also be crafted from crafting White Dye, Cocoa Beans, and Bone Meal together (don't question it)
  - They're primarily used for making foods that involve them (duh), but can also be ground up to make flour
- Added Wheat Flour & Taiga Flour
  - To create Dough, players must now grind Wheat or Taiga Beans into Flour
  - Flour can then be mixed with Water in a Mixing Bowl to create Dough
  - Crafting Dough from Wheat Flour requires only the flour and some water, but using Taiga Flour requires triple the amount of flour due to the low yield of the beans
    - Because crafting Flour from Wheat is is 1:1, Bread can now be crafted from 1 Wheat given the player has the supplies and utlities
- Added Crowbars
  - In order to open Item Crates, a Crowbar will now be required
  - The Crowbar is crafted from 2 Iron Ingots and 1 Leather, and has 250 durability
  - It also doubles as a weapon, dealing +5 Attack Damage--or can be used to break open Iron Doors and Iron Trapdoors like a pickaxe would mine it
    - Item Crates requiring Crowbars to open can be disabled in the Config menu
    - Using a Crowbar to open an Item Crate does not use durability
- Added Mixed Herbs
  - Mixed Herbs are a new item that will be required for crafting Seasoning, and will replace the assortment of small flowers previously required
  - Crafting Mixed Herbs will still require the same set of flowers, but with Wheat Seeds mixed into the recipe. However, each craft of the recipe will yield 3 Mixed Herbs for crafting
- Added Coffee Grounds
  - To make Coffee, players will first need to grind Coffee Beans into Coffee Grounds using a Mortar & Pestle. It should be a bit obvious.

#### Advancements
6 new advancements have been added in this update:
- "Watch Your Fingers!" for crafting a Cutting Board
- "Renewable Fuel" for crafting Biomass
- "BLEAH!" for eating food meant for your dog
- "Nether Bakeware" for crafting a Baking Pan
- "Getting Mixed Up" for obtaining a Mixing Bowl
- "Courting Death" for consuming an item that WOULD kill you, but then drinking a milk item to clear its effects

#### Recipes
- Added a recipe to smelt Soul Sand into Glass (takes 20 seconds to smelt due to burning away the spirits)

#### Misc
- Cleavers now have a new 16x16 inventory texture
  - The cleaver now shows this texture in GUI menus, when dropped on the ground, and when displayed in Item Frames
- Added a new sound for Shaker Cups shaking their contents
- Added a new sound subtitle for Shaker Cups emptying their contents
- Added two new recipe advancements for Fried Rice and Bowls of Cooked Rice
- Introduced **Decorative Items**
  - Items that are Decorative won't do anything, but can be displayed in an Item Frame placed on a surface
  - Decorative Items will have the word "Decorative" written in the tooltip to easily tell them apart from other items
  - To craft them, an Item Frame will always be required in the recipe. This also makes it easy to tell them apart from other recipes
  - More decorative items will be added in the future!
- Added a predicate for checking if the player is holding a Mixing Bowl in either hand (`rmf:using_mixing_bowl`)
- Added new item tag `rmf:water` for items that can be used as water in recipes
- Added new item tag `rmf:milk` for items that can be used as milk in recipes
  - Please note that neither of these item tags are used in the Shaker Cup or Mixing Bowl as it would require another function for returning the bucket if it's used
- Created a new Config Menu using Dialogs
  - This means that the datapack now brings up an "experimental settings" menu on load. This is annoying, but there are ways around it for modded and servers don't get the popup, so it only really affects singleplayer. Most other datapacks already use experimental settings so this likely doesn't change much for many players. Sorry.
  - Config options can now be changed from this menu
  - To access it, use `/function rmf:_config`. This will show it and all of its options on screen
- Added new scores for tracking players breaking Bushes and Ferns
- Players nearby someone frying or baking something can now hear them doing so
- Players can now gain experience points when frying items (one point per item)

### Changed 
#### Foods
- Stuffed Potatoes now restore 10 Saturation (from 7)
- Several drinks crafted from the Shaker Cup have been buffed:
  - Banana Smoothies now restore 6 Nutrition (from 4)
  - Berry Smoothies now restore 6 Nutrition (from 4)
  - Mango Smoothies now restore 6 Nutrition and 8 Saturation (from 4 Nutrition and 5 Saturation)
  - Melon Smoothies now restore 5 Nutrition (from 4)
  - Peach Smoothies now restore 6 Nutrition (from 4)
- Marshmallow on a Sticks have been changed slightly
  - The item is no longer edible
  - To cook a Marshmallow on a Stick, players must hold the use key (Right Mouse Button by default) over a Campfire, Soul Campfire, Fire, Soul Fire, Magma Block, or Lava
  - When one of the above blocks are used to cook a marshmallow, it will either be Toasted, Burned, or Incinerated
    - Toasting a marshmallow will turn it into a Roasted Marshmallow on a Stick
    - Burning a marshmallow will turn it into a Burned Marshmallow on a Stick
    - Incinerating a marshmallow will turn it into Charcoal on a Stick
  - Cooking a marshmallow over a heat source will take a different amount of time depending on the source used, but it will be consistantly cooked for that source (for examples, Campfires will always cook it perfectly)
- Changed the texture of Mac & Cheese
- Cut Potatoes now restore 3 Nutrition and Saturation (from 2)
- Stuffed Pumpkins now take 2 seconds to consume (from 3)
- Apple Pie Slices now restore 4 Nutrition and 2.4 Saturation (from 2 and 1.2 respectively)
- Apple Pie now restores 9 Saturation (from 4.8)

#### Items
- Functionally changed how Shaker Cups work
  - Shaker Cups now work by using them like an item (default is Right Mouse Button)
  - To craft an item with them, valid ingredients must be held in the offhand
    - As before, all recipes with the Shaker Cup can be found in the Gourmand's Digest Cookbook in their related pages
  - Once all ingredients have been inserted, the Shaker Cup must actually be shaken to "mix" ingredients inside
  - The Shaker Cup now also shows which recipe is being crafted inside of it, and what is filled with if no recipes are being made
  - The Shaker Cup can now empty its contents if it is used while crouching with an empty offhand
- Functionally changed how Mortar & Pestles work
  - Like Shaker Cups, the item is now activated with the Use Key (RMB by default)
  - To grind an item, hold the item you wish to grind in the offhand and use the Mortar & Pestle
  - The item is now put on a 0.5 second cooldown every time an ingredient is successfully ground into something else
    - The previous `set_grinding_speed` command function has been removed, meaning this time cannot be edited or changed
- Functionally changed how the Gourmand's Digest (cookbook) works
  - The cookbook still works like it did previously when used while holding it, but it can no longer be placed in Lecturns
  - The cookbook now opens a dialog screen with all of the different categories within it, and every item is displayed there instead of the previous system
    - This change has been made to make it much easier for me to add new pages in the future, as well as making it look much cleaner and easier to navigate
- Charcoal on a Stick can no longer be roasted over a Fire or Campfire
- Crafting Marshmallow Sandwiches now requires pressing the Use Key (Right Click Button by default) while holding 2 Wheat Crackers in the mainhand and a Roasted Marshmallow Stick in the offhand
- Made the following items compostable (they can now be turned into Bone Meal in a composter):
  - Strawberries
  - Blueberries
  - Raspberries
  - Blackberries
  - Bananas
  - Oranges
  - Peaches
  - Mangoes
  - Prickly Pears
  - Coconuts
  - Coconut Halves
  - Sweet Berry Cookies
  - Glow Berry Cookies
  - Cocoa Cookies
  - Honey Cookies
  - Corn
  - Pumpkin Pie Slices
  - Apple Pie
  - Apple Pie Slices
    - NOTE: This comes with the unfortunate consequence of making Parrots deathly allergic to all of the above items. Please do not feed your parrots any of these items.
- Replaced the dummy item for Vinegar and Vinegar Item Crates
- Assorted Seasoning and Salt both now have display models for Item Frames
- Updated the texture of Ramen
- Punnets now have a description to help players understand how they work
- Clocks no longer tell the time in the Nether and End dimensions
- Gave each Popcorn Bag size their own item names to help distinguish them

#### Blocks
- Tall Grass now has a 25% chance to drop Maize when broken with a Punnet (from 10%)
- Short Grass now has a 1% chance to drop Tomato Seeds when broken with a Punnet (from 2%)

#### Mobs
- Hoglins will now always have a chance to drop Bone-In Ham, and not just when holding a Cleaver
- The chance of a Hoglin dropping Bone-In Ham is now 40% (from 60%)

#### Recipes
- Cooking Pots can now be crafted with Polished Blackstone Slabs
- Seperated the Shaker Cup recipe from the Mortar & Pestle recipes in the Recipe Book
- Changed the recipe group for the Mortar & Pestle recipes to `mortar_and_pestle` (from `smoothie`)
- Crafting Ominous Cookies now requires Wheat and Cocoa Beans instead of a Cookie
  - The shape of the recipe has also been changed slightly
- Wooden Shears are now crafted from 2 Wood Logs instead of Planks
- Drink recipes in the Shaker Cup have been changed to only output 1 bottle per recipe
- Dough and Dough-type items can now only be cooked in the Baking Pan
- Cut Potatoes now require Salt to be crafted
- Cut Potatoes can no longer be made in the Stonecutter
- Dough is no longer crafted in the Crafting Table. Instead, it must be made in a Mixing Bowl
  - The recipe is the same for doing so, still requiring 2 Wheat and 1 Water Barrel
- Dough now requires Water Barrels to craft, instead of Water Buckets
- Apple Pie is now crafted from 2 Apples, Sugar, and any Egg
- Coffee is now crafted using the Shaker Cup, rather than the Crafting Table
  - To make a Bottle of Coffee, place Water, Sugar, and Coffee Grounds into a Shaker Cup
- Crafting Rice now yields 6 Rice Grains per craft (from 1)

#### Advancements
- Changed the requirements of the "Crafting With Extra Steps" advancement
  - To obtain the advancement, players must now craft a torch with a Charcoal on a Stick rather than cooking it on a Campfire
- Changed the description of the "Crafting With Extra Steps" advancement
- Changed the order of the "Iron Belly" and "Desperate Times" advancements ("Desperate Times" is now displayed before "Iron Belly")
- Renamed the "Iron Belly" advancement to "Very Desperate Times"
- Moved the "Extreme Dieting" advancement to be under "Extra Dietary Options"
- Changed the description of the "...Wait, What?" advancement
- Updated the "Chef's Kitchen" advancement to include the Baking Pan and Mixing Bowl
- Moved the "Beware The Cookie's Crumbles" advancement under "Extra Dietary Options"
- Changed the description of the "Extreme Dieting" advancement
- Moved the "Beating a Dead Hoglin" advancement under "Extra Dietary Options" as a Cleaver is no longer required to get it

#### Data & Misc
- Moved all config files to background function subfolders
  - They can still be used, but it's intended that server admins or operators use `/function rmf:_config` instead
- Renamed and repurposed the `rmf:juice_cooldown` function to be used for the Shaker Cup and Mortar & Pestle
  - The function is now also called `rmf:item_cooldown`
- Changed the translation key for trying to use an Item Crate without a valid item in the offhand to `chat.rmf.use_item.empty_hand` (from `chat.rmf.item_crate.no_item`)
  - This translation key is now shared with other items when they fit the same conditions
- Changed the translation text for trying to use a utility item without a valid ingredient (for example, trying to use a shaker cup without holding a valid ingredient)
- Completely redid the Shaker Cup's function files and command structure
  - Several function files and commands have either been removed, redone, or renamed to make use of it easier and cleaner
- Renamed several translation keys for the Shaker Cup
- Changed the translation text for using the Mortar & Pestle without a valid ingredient
- Changed the `item_id` for the Charcoal on a Stick to `rmf:incinerated_marshmallow_stick` (from `rmf:burned_marshmallow_stick`) 
- Updated the data for the following items (these will be automatically upgraded):
  - Mortar & Pestles
  - Shaker Cups
  - Marshmallow on a Sticks
- Changed the dummy item used for Cheese
  - The item will be automatically upgraded in-world, players just have to keep it in their inventory and it'll be fixed
- Moved the `rmf:grind_item` background function into the `grinding` subfolder
- Moved the `rmf:shake_item` background function into the `shaking` subfolder
- Moved the `rmf:juice_item` background function into the `juicing` subfolder
- Moved the `rmf:crate_item` background function into the `crating`
- Renamed the `rmf:reset_scores` background advancement to `rmf:failsafe`
- Renamed Cut Potatoes to Potato Fries
- Changed the name of the `rmf:grind_item` function in the `bg/grinding` subfolder (now `rmf:_grind_item`)
- Changed the name of the `rmf:juice_item` function in the `bg/juicing` subfolder (now `rmf:_juice_item`)
- Changed the name of the `rmf:crate_item` function in the `bg/crating` subfolder (now `rmf:_crate_item`)
- Changed the name of the `rmf:shake_item` function in the `bg/shaking` subfolder (now `rmf:_shake_item`)
- Changed the name of the `rmf:fix_items` function in the `bg/fix` subfolder (now `rmf:_fix_item`)
- Changed the name of the `rmf:recipes` function in `bg/frying` subfolder (now `rmf:_recipes`)
  - This is to make it easier to find when searching through the folder for its recipes
- Renamed `rmf:ice_cream_refunder` backround advancement to `rmf:bucket_refunder`
- Renamed `rmf:ice_cream_refund` background function to `rmf:bucket_refunder`
- Changed the code for some Item Crates to work with the Crowbar
- Changed how the `rmf:give_item` function command works
  - To give custom items, operators must now use `/function rmf:_give_item`, which will now bring up a new dialog menu
  - This menu is meant to make it easier to spawn items
  - Operators can still use the old system of spawning items if they wish, the menu is just a simpler way of doing it
- Renamed `rmf:herbs` item tag to `rmf:herb_ingredients`
- Renamed the "veggie_corn_dog" `give_item` function to "veg_corn_dog" to match internal name

### Removed
- Removed some leftover unused model files
- Removed a leftover unused predicate file
- Removed the `rmf.shakerCooldown` scoreboard
- Removed the `rmf.grindingCooldown` scoreboard
- Removed the `rmf.grindingMaxCooldown` scoreboard
- Removed the `rmf:grinding_stuff` function
- Removed the `rmf:bg/crate_cooldown` function
- Removed the `rmf:roasting_marshmallow` predicate
- Removed the `rmf:half_marshmallow_sandwich` item (it will be upgraded to Marshmallow Sandwiches instead)
- Removed the `rmf:set_grinding_speed` config command
- Removed the `rmf:grinding_item` predicate
- Removed the Dough variant recipe for crafting Cereal
  - It felt kinda weird to make cereal with dough idk
- Removed the `rmf:rice_foods` recipe advancement
- Removed the `rmf:whats_new` text file in the `fix` folder
  - I couldn't be arsed to keep updating it since almost nobody reads it to be honest
- Removed the `rmf:dough` recipe
- Removed the `rmf:cutting` recipe subfolder
- Removed the "uninstall" and "help" config functions
  - "Uninstall" is now in the config menu, and each button comes with a tooltip now, so both functions are not needed anymore
- Removed the recipe for Apple Pie Slices, and crafting Apple Pie and Apple Pie Slices from Dough
- Removed the advancement recipe for Coffee
- Removed the recipe for Coffee
- Removed the "rice bowl" recipe group
- Removed old cookbook functions and commands
- Removed the `rmf:cleaver_model` texture file as it's now unused

### Fixes
10 bugs have been fixed in this version:
- [RMF-20](https://github.com/regfunkid/reg-more-foods/issues/20): Expert Fishermen Villagers buy Cheese named "Tropical Fish"
- [RMF-55](https://github.com/regfunkid/reg-more-foods/issues/55): Item Fix function triggers when crafting Smoothies
- [RMF-57](https://github.com/regfunkid/reg-more-foods/issues/57): Entity Loot Table Modified
- [RMF-58](https://github.com/regfunkid/reg-more-foods/issues/58): `rmf:reset_all_scores` function doesn't affect `rmf.fryingProgress` score
- [RMF-59](https://github.com/regfunkid/reg-more-foods/issues/59): Minor incompatibility with Tide
- [RMF-60](https://github.com/regfunkid/reg-more-foods/issues/60): Loot table for `minecraft:brown_mushroom_block` has a typo
- [RMF-61](https://github.com/regfunkid/reg-more-foods/issues/61): Loot table for `minecraft:potatoes` has incorrect component definition
- [RMF-64](https://github.com/regfunkid/reg-more-foods/issues/64): "A Balanced Breakfast" advancement is broken
- [RMF-66](https://github.com/regfunkid/reg-more-foods/issues/66): Lava Chicken Music Disc is unobtainable
- [RMF-67](https://github.com/regfunkid/reg-more-foods/issues/67): `rmf:tick` causes major TPS lag in large servers

### Bugs
- There is a known bug where using a filled Item Crate from an earlier version will cause it to duplicate itself due to the new version having different item data. I will not be fixing this bug, because I don't mind it existing. I also do not have the time to fix the bug, and by the time I do, it will have already fixed itself.
  - The few people who bother to read these changelogs will also be the few who know this exists c: