#version 150

layout(std140) uniform DynamicTransforms {
    mat4 ModelViewMat;
    vec4 ColorModulator;
    vec3 ModelOffset;
    mat4 TextureMat;
    float LineWidth;
};

uniform sampler2D Sampler0;

in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

float f_spread = .5;
float f_desaturate = 15.0;
float contrast = 55.0;

float truncate(float val) {
    if (val > 255.0) {
        return 255.0;
    }
    if (val < 0.0) {
        return 0.0;
    }
    return val;
}

vec3 spread(vec3 color, float factor)
{
    float mul = 1.0 + ((color.r + color.g + color.b) * 1.0 - 1.0) * factor;
    return color * mul;
}

vec3 desaturate(vec3 color, float factor) {
    vec3 luma = vec3(0.299, 0.587, 0.114);
    vec3 gray = vec3(dot(luma, color));
    return vec3(mix(color, gray, factor));
}

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    color.rgb = desaturate(spread(color.rgb, f_spread), f_desaturate);
    if (color.a < 0.1) {
        discard;
    }

    float rr = .393;
    float rg = .769;
    float rb = .189;
    float ra = 0.0;

    float gr = .349;
    float gg = .686;
    float gb = .168;
    float ga = 0.0;

    float br = .272;
    float bg = .534;
    float bb = .131;
    float ba = 0.0;

    // sepia calculation
    float s_red = (rr * color.r) + (rb * color.b) + (rg * color.g) + (ra * color.a);
    float s_green = (gr * color.r) + (gb * color.b) + (gg * color.g) + (ga * color.a);
    float s_blue = (br * color.r) + (bb * color.b) + (bg * color.g) + (ba * color.a);

    // increase contrast
    float factor = (259.0 * (contrast + 255.0)) / (255.0 * (259.0 - contrast));
    float c_red = truncate(factor * ((s_red - contrast) + contrast));
    float c_green = truncate(factor * ((s_green - contrast) + contrast));
    float c_blue = truncate(factor * ((s_blue - contrast) + contrast));

    //    color = vec4(s_red, s_green, s_blue, 1.0);
    color = vec4(c_red, c_green, c_blue, 1.0);

    //        color = vec4(color.r, color.g, color.b, 1.0);
    fragColor = color;
}

