/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.letmedespawn;

import com.frikinjay.almanac.Almanac;
import com.frikinjay.letmedespawn.command.LetMeDespawnCommands;
import com.frikinjay.letmedespawn.config.LetMeDespawnConfig;
import com.mojang.logging.LogUtils;
import java.io.File;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.slf4j.Logger;

public final class LetMeDespawn {
    public static final String MOD_ID = "letmedespawn";
    public static final Logger logger = LogUtils.getLogger();
    public static final File CONFIG_FILE = new File("config/letmedespawn.json");
    public static LetMeDespawnConfig config;
    private static class_2378<class_1792> cachedItemRegistry;
    private static class_2378<class_1299<?>> cachedMobRegistry;

    public static void init() {
        config = LetMeDespawnConfig.load();
        Almanac.addConfigChangeListener((File)CONFIG_FILE, newConfig -> {
            config = (LetMeDespawnConfig)newConfig;
            logger.info("LetMeDespawn config reloaded");
        });
        config.save();
        Almanac.addCommandRegistration(LetMeDespawnCommands::register);
    }

    public static class_2378<class_1792> getItemRegistry(class_1937 level) {
        if (cachedItemRegistry == null && level != null) {
            cachedItemRegistry = level.method_30349().method_30530(class_7924.field_41197);
        }
        return cachedItemRegistry;
    }

    public static String getItemKey(class_1799 itemStack, class_1308 entity) {
        class_2378<class_1792> itemRegistry;
        class_2960 itemId = null;
        if (!itemStack.method_7960() && (itemRegistry = LetMeDespawn.getItemRegistry(entity.method_73183())) != null) {
            itemId = itemRegistry.method_10221((Object)itemStack.method_7909());
        }
        return itemId != null ? itemId.toString() : "";
    }

    public static class_2378<class_1299<?>> getMobRegistry(class_1937 level) {
        if (cachedMobRegistry == null && level != null) {
            cachedMobRegistry = level.method_30349().method_30530(class_7924.field_41266);
        }
        return cachedMobRegistry;
    }

    public static String getMobKey(class_1308 entity) {
        class_2960 mobId = null;
        class_2378<class_1299<?>> mobRegistry = LetMeDespawn.getMobRegistry(entity.method_73183());
        if (mobRegistry != null) {
            mobId = mobRegistry.method_10221((Object)entity.method_5864());
        }
        return mobId != null ? mobId.toString() : "";
    }

    public static void clearRegistryCache() {
        cachedItemRegistry = null;
        cachedMobRegistry = null;
    }

    public static void setPersistence(class_1308 entity, class_1304 slot) {
        class_1799 itemStack = entity.method_6118(slot);
        class_9279 component = (class_9279)itemStack.method_58694(class_9334.field_49628);
        class_2487 nbt = component != null ? component.method_57461() : new class_2487();
        nbt.method_10556("picked", true);
        itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        Almanac.pickedItems = true;
        entity.field_6200 = config.getMobNames().contains(LetMeDespawn.getMobKey(entity)) || !LetMeDespawn.hasDespawnableName(entity);
    }

    public static boolean hasDespawnableName(class_1308 entity) {
        if (entity.method_16914()) {
            return Almanac.matchesStackedName((String)entity.method_5797().getString(), (class_1297)entity);
        }
        return true;
    }

    static {
        cachedItemRegistry = null;
        cachedMobRegistry = null;
    }
}

