/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay;

import com.dooji.underlay.Underlay;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class UnderlayPersistenceHandler {
    private static final int MAX_OVERLAY_SAVE_ATTEMPTS = 3;

    private static String getSaveFileName(class_1937 world) {
        String dimensionId = world.method_27983().method_29177().toString();
        if ("minecraft:overworld".equals(dimensionId)) {
            return "underlays.dat";
        }
        return "underlays_" + dimensionId.replace(':', '_') + ".dat";
    }

    public static void saveOverlays(class_1937 world, Map<class_2338, class_2680> overlays) {
        if (world == null || overlays == null) {
            Underlay.LOGGER.warn("Attempted to save overlays with null parameters");
            return;
        }
        if (world.method_8608() || !(world instanceof class_3218)) {
            return;
        }
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                class_2487 rootTag = new class_2487();
                class_2499 overlayList = new class_2499();
                for (Map.Entry<class_2338, class_2680> entry : overlays.entrySet()) {
                    class_2338 pos = entry.getKey();
                    class_2680 state = entry.getValue();
                    class_2487 overlayTag = new class_2487();
                    overlayTag.method_10569("x", pos.method_10263());
                    overlayTag.method_10569("y", pos.method_10264());
                    overlayTag.method_10569("z", pos.method_10260());
                    overlayTag.method_10566("state", (class_2520)class_2512.method_10686((class_2680)state));
                    class_2960 blockId = class_7923.field_41175.method_10221((Object)state.method_26204());
                    overlayTag.method_10582("block", blockId.toString());
                    overlayList.add((Object)overlayTag);
                }
                rootTag.method_10566("overlays", (class_2520)overlayList);
                class_3218 serverWorld = (class_3218)world;
                Path saveDir = serverWorld.method_8503().method_27050(class_5218.field_24188).resolve("data");
                String fileName = UnderlayPersistenceHandler.getSaveFileName(world);
                File saveFile = saveDir.resolve(fileName).toFile();
                saveDir.toFile().mkdirs();
                try (FileOutputStream fos = new FileOutputStream(saveFile);){
                    class_2507.method_10634((class_2487)rootTag, (OutputStream)fos);
                    break;
                }
            }
            catch (IOException e) {
                Underlay.LOGGER.error("Failed to save overlays (Attempt " + (attempt + 1) + ")", (Throwable)e);
                try {
                    Thread.sleep(100 * (attempt + 1));
                    continue;
                }
                catch (InterruptedException ie) {
                    Underlay.LOGGER.warn("Overlay save interrupted", (Throwable)ie);
                    break;
                }
            }
        }
    }

    public static Map<class_2338, class_2680> loadOverlays(class_1937 world) {
        HashMap<class_2338, class_2680> overlays = new HashMap<class_2338, class_2680>();
        if (world == null) {
            Underlay.LOGGER.warn("Attempted to load overlays with null world");
            return overlays;
        }
        if (world.method_8608() || !(world instanceof class_3218)) {
            return overlays;
        }
        try {
            class_3218 serverWorld = (class_3218)world;
            class_2378 lookup = serverWorld.method_30349().method_30530(class_7924.field_41254);
            Path saveDir = serverWorld.method_8503().method_27050(class_5218.field_24188).resolve("data");
            String fileName = UnderlayPersistenceHandler.getSaveFileName(world);
            File saveFile = saveDir.resolve(fileName).toFile();
            if (!saveFile.exists()) {
                Underlay.LOGGER.info("No existing overlay save file found");
                return overlays;
            }
            try (FileInputStream fis = new FileInputStream(saveFile);){
                class_2487 rootTag = class_2507.method_10629((InputStream)fis, (class_2505)class_2505.method_53898());
                if (rootTag.method_10545("overlays")) {
                    class_2499 overlayList = rootTag.method_68569("overlays");
                    for (int i = 0; i < overlayList.size(); ++i) {
                        class_2680 state;
                        class_2487 overlayTag = overlayList.method_68582(i);
                        int x = overlayTag.method_68083("x", 0);
                        int y = overlayTag.method_68083("y", 0);
                        int z = overlayTag.method_68083("z", 0);
                        Optional optNbt = overlayTag.method_10562("state");
                        class_2487 stateTag = optNbt.orElse(new class_2487());
                        class_2338 pos = new class_2338(x, y, z);
                        if (!stateTag.method_33133()) {
                            state = class_2512.method_10681((class_7871)lookup, (class_2487)stateTag);
                        } else {
                            String blockIdString = overlayTag.method_68564("block", "");
                            class_2960 blockId = class_2960.method_12829((String)blockIdString);
                            if (blockId != null) {
                                state = ((class_2248)class_7923.field_41175.method_63535(blockId)).method_9564();
                            } else {
                                Underlay.LOGGER.warn("Invalid block ID in overlay save: " + blockIdString);
                                continue;
                            }
                        }
                        overlays.put(pos, state);
                    }
                    Underlay.LOGGER.info("Loaded " + overlays.size() + " overlays");
                }
            }
        }
        catch (IOException e) {
            Underlay.LOGGER.error("Failed to load overlays", (Throwable)e);
        }
        return overlays;
    }
}

