/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.resources.v1;

import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import fuzs.puzzleslib.impl.resources.ModPackResourcesSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import net.minecraft.class_7662;
import net.minecraft.class_7677;
import net.minecraft.class_7699;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class AbstractModPackResources
implements class_3262 {
    protected final String modLogoPath;
    @Nullable
    private class_3264 packType;
    @Nullable
    private class_9224 info;
    @Nullable
    private class_7662 metadata;

    public AbstractModPackResources() {
        this("mod_logo.png");
    }

    public AbstractModPackResources(String modLogoPath) {
        Objects.requireNonNull(modLogoPath, "mod logo path is null");
        this.modLogoPath = modLogoPath;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... elements) {
        String path = String.join((CharSequence)"/", elements);
        if ("pack.png".equals(path)) {
            return ModLoaderEnvironment.INSTANCE.getModContainer(this.getNamespace()).flatMap(container -> container.findResource(this.modLogoPath)).map(modResource -> () -> Files.newInputStream(modResource, new OpenOption[0])).orElse(null);
        }
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        return null;
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
    }

    public Set<String> method_14406(class_3264 type) {
        Objects.requireNonNull(this.packType, "pack type is null");
        return this.packType == type ? Collections.singleton(this.getNamespace()) : Collections.emptySet();
    }

    @Nullable
    public <T> T method_14407(class_7677<T> type) throws IOException {
        Objects.requireNonNull(this.metadata, "metadata is null");
        return (T)this.metadata.method_45173(type);
    }

    public class_9224 method_56926() {
        Objects.requireNonNull(this.info, "info is null");
        return this.info;
    }

    public void close() {
    }

    public String getNamespace() {
        return ResourceLocationHelper.parse(this.method_14409()).method_12836();
    }

    @ApiStatus.OverrideOnly
    protected void setup() {
    }

    public static class_3288 buildPack(class_3264 packType, class_2960 resourceLocation, Supplier<AbstractModPackResources> factory, class_2561 titleComponent, class_2561 descriptionComponent, boolean required, class_3288.class_3289 position, boolean fixedPosition, boolean hidden, class_7699 featureFlagSet) {
        class_9224 info = new class_9224(resourceLocation.toString(), titleComponent, class_5352.field_25348, Optional.empty());
        ModPackResourcesSupplier resourcesSupplier = ModPackResourcesSupplier.create(packType, info, AbstractModPackResources.createSupplier(factory), descriptionComponent);
        class_3288.class_7679 metadata = PackResourcesHelper.createPackInfo(resourceLocation, descriptionComponent, class_3281.field_14224, featureFlagSet, hidden);
        class_9225 config = new class_9225(required, position, fixedPosition);
        return new class_3288(info, (class_3288.class_7680)resourcesSupplier, metadata, config);
    }

    private static ModPackResourcesSupplier.PackResourcesSupplier<AbstractModPackResources> createSupplier(Supplier<AbstractModPackResources> factory) {
        return (packType, info, metadata) -> {
            AbstractModPackResources packResources = (AbstractModPackResources)factory.get();
            packResources.info = info;
            packResources.metadata = metadata;
            packResources.packType = packType;
            packResources.setup();
            return packResources;
        };
    }
}

