/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components;

import java.util.List;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_7417;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

public final class ScreenElementPositioner {
    private ScreenElementPositioner() {
    }

    public static boolean tryPositionElement(class_8021 element, List<? extends class_364> widgets, String ... translationKeys) {
        return ScreenElementPositioner.tryPositionElement(element, widgets, false, translationKeys);
    }

    public static boolean tryPositionElement(class_8021 element, List<? extends class_364> widgets, boolean tryPositionRightFirst, String ... translationKeys) {
        return ScreenElementPositioner.tryPositionElement(element, widgets, tryPositionRightFirst, 4, translationKeys);
    }

    public static boolean tryPositionElement(class_8021 element, List<? extends class_364> widgets, boolean tryPositionRightFirst, int horizontalOffset, String ... translationKeys) {
        int originalX = element.method_46426();
        int originalY = element.method_46427();
        for (String translationKey : translationKeys) {
            class_8021 otherElement = ScreenElementPositioner.findElement(widgets, translationKey);
            if (otherElement == null) continue;
            ScreenElementPositioner.moveElementToOther(element, otherElement, tryPositionRightFirst, horizontalOffset);
            if (ScreenElementPositioner.noOverlapWithExisting(widgets, element)) {
                return true;
            }
            ScreenElementPositioner.moveElementToOther(element, otherElement, !tryPositionRightFirst, horizontalOffset);
            if (!ScreenElementPositioner.noOverlapWithExisting(widgets, element)) continue;
            return true;
        }
        element.method_48229(originalX, originalY);
        return false;
    }

    private static void moveElementToOther(class_8021 element, class_8021 otherElement, boolean tryPositionRightFirst, int horizontalOffset) {
        if (tryPositionRightFirst) {
            ScreenElementPositioner.moveToRight(element, otherElement, horizontalOffset);
        } else {
            ScreenElementPositioner.moveToLeft(element, otherElement, horizontalOffset);
        }
    }

    private static void moveToLeft(class_8021 element, class_8021 otherElement, int horizontalOffset) {
        element.method_48229(otherElement.method_46426() - element.method_25368() - horizontalOffset, otherElement.method_46427());
    }

    private static void moveToRight(class_8021 element, class_8021 otherElement, int horizontalOffset) {
        element.method_48229(otherElement.method_46426() + otherElement.method_25368() + horizontalOffset, otherElement.method_46427());
    }

    private static boolean noOverlapWithExisting(List<? extends class_364> widgets, class_8021 element) {
        for (class_364 class_3642 : widgets) {
            if (!(class_3642 instanceof class_8021)) continue;
            class_8021 otherElement = (class_8021)class_3642;
            if (element.method_48202().method_49701(otherElement.method_48202()) == null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static class_8021 findElement(List<? extends class_364> widgets, String translationKey) {
        for (class_364 class_3642 : widgets) {
            class_339 widget;
            if (!(class_3642 instanceof class_339) || !ScreenElementPositioner.matchesTranslationKey(widget = (class_339)class_3642, translationKey)) continue;
            return widget;
        }
        return null;
    }

    private static boolean matchesTranslationKey(class_339 widget, String translationKey) {
        class_2588 contents;
        class_7417 message = widget.method_25369().method_10851();
        return message instanceof class_2588 && (contents = (class_2588)message).method_11022().equals(translationKey);
    }
}

