/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones;

import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.pneumono.gravestones.Gravestones;
import net.pneumono.gravestones.GravestonesConfig;
import net.pneumono.gravestones.api.GravestoneCollectedCallback;
import net.pneumono.gravestones.api.GravestonesApi;
import net.pneumono.gravestones.block.TechnicalGravestoneBlockEntity;
import net.pneumono.gravestones.gravestones.GravestoneManager;
import net.pneumono.gravestones.multiversion.GraveOwner;
import net.pneumono.gravestones.multiversion.VersionUtil;

public class GravestoneCollection
extends GravestoneManager {
    public static boolean collect(class_3218 world, class_1657 player, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TechnicalGravestoneBlockEntity) {
            TechnicalGravestoneBlockEntity gravestone = (TechnicalGravestoneBlockEntity)class_25862;
            GravestoneCollection.info("----- Beginning Gravestone Collection -----");
            GravestoneCollection.info("If you don't want to see this, disable 'Console Info' in the configs!");
            boolean success = GravestoneCollection.collect(world, player, pos, gravestone);
            GravestoneCollection.info("----- Finishing Gravestone Collection -----");
            return success;
        }
        return false;
    }

    private static boolean collect(class_3218 world, class_1657 player, class_2338 pos, TechnicalGravestoneBlockEntity gravestone) {
        GravestoneCollection.info("Performing checks...");
        if (player instanceof FakePlayer) {
            GravestoneCollection.info("Player cannot collect gravestone because they are a FakePlayer");
            return false;
        }
        if (player.method_29504()) {
            GravestoneCollection.info("Player cannot collect gravestone because they are dead");
            return false;
        }
        GraveOwner graveOwner = gravestone.getGraveOwner();
        if (graveOwner == null) {
            GravestoneCollection.info("Player cannot collect gravestone because it has no owner");
            player.method_7353((class_2561)class_2561.method_43471((String)"gravestones.cannot_open_no_owner"), true);
            return false;
        }
        boolean isOwner = graveOwner.getUuid().equals(VersionUtil.getId(player.method_7334()));
        if (!isOwner && ((Boolean)GravestonesConfig.GRAVESTONE_ACCESSIBLE_OWNER_ONLY.getValue()).booleanValue()) {
            GravestoneCollection.info("Player cannot collect gravestone because they are not the owner");
            player.method_7353((class_2561)class_2561.method_43469((String)"gravestones.cannot_open_wrong_player", (Object[])new Object[]{graveOwner.getNotNullName()}), true);
            return false;
        }
        GravestoneCollection.info("All checks passed");
        GravestoneCollection.info("Returning gravestone contents...");
        GravestonesApi.onCollect(world, pos, player, gravestone.getDecay(), gravestone.getContents());
        class_2487 contents = gravestone.getContents();
        if (!contents.method_33133()) {
            GravestoneCollection.warn("Some gravestone contents were not returned: {}", contents);
            return false;
        }
        gravestone.setContents(new class_2487());
        Object uuid = "";
        if (((Boolean)GravestonesConfig.CONSOLE_INFO.getValue()).booleanValue()) {
            uuid = " (" + String.valueOf(VersionUtil.getId(player.method_7334())) + ")";
        }
        if (isOwner) {
            Gravestones.LOGGER.info("{}{} has found their grave at {}", new Object[]{player.method_5477().getString(), uuid, GravestoneManager.posToString(pos)});
        } else {
            Gravestones.LOGGER.info("{}{} has found {}{}'s grave at {}", new Object[]{player.method_5477().getString(), uuid, graveOwner.getNotNullName(), graveOwner.getUuid(), pos.toString()});
        }
        GravestoneCollection.info("Broadcasting chat message...");
        if (((Boolean)GravestonesConfig.BROADCAST_COLLECT_IN_CHAT.getValue()).booleanValue()) {
            class_5250 text = ((Boolean)GravestonesConfig.BROADCAST_COORDINATES_IN_CHAT.getValue()).booleanValue() ? (isOwner ? class_2561.method_43469((String)"gravestones.player_collected_grave_at_coords", (Object[])new Object[]{player.method_5477().getString(), GravestoneManager.posToString(pos)}) : class_2561.method_43469((String)"gravestones.player_collected_others_grave_at_coords", (Object[])new Object[]{player.method_5477().getString(), graveOwner.getNotNullName(), GravestoneManager.posToString(pos)})) : (isOwner ? class_2561.method_43469((String)"gravestones.player_collected_grave", (Object[])new Object[]{player.method_5477().getString()}) : class_2561.method_43469((String)"gravestones.player_collected_others_grave", (Object[])new Object[]{player.method_5477().getString(), graveOwner.getNotNullName()}));
            world.method_8503().method_3760().method_43514((class_2561)text, false);
        }
        GravestoneCollection.info("Breaking gravestone...");
        world.method_22352(pos, true);
        ((GravestoneCollectedCallback)GravestoneCollectedCallback.EVENT.invoker()).afterGravestoneCollect(world, player, pos);
        return true;
    }
}

