/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryOnData {
    private CarryType type;
    private class_2487 nbt;
    private boolean keyPressed = false;
    private CarryOnScript activeScript;
    private int selectedSlot = 0;
    private static final class_8942 problemReporter = new class_8942.class_11340(Constants.LOG);
    public static final Codec<CarryOnData> CODEC = class_2487.field_25128.flatXmap(tag -> {
        try {
            return DataResult.success((Object)new CarryOnData((class_2487)tag));
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }, carry -> {
        try {
            return DataResult.success((Object)carry.getNbt());
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    });
    public static final class_9139<class_9129, CarryOnData> STREAM_CODEC = class_9135.method_56896(CODEC);
    public static final String SERIALIZATION_KEY = "CarryOnData";

    public CarryOnData(class_2487 data) {
        this.type = data.method_10545("type") ? CarryType.valueOf(data.method_68564("type", "INVALID")) : CarryType.INVALID;
        this.nbt = data;
        this.keyPressed = data.method_68566("keyPressed", false);
        if (data.method_10545("activeScript")) {
            DataResult res = CarryOnScript.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)data.method_10580("activeScript"));
            this.activeScript = (CarryOnScript)res.getOrThrow(s -> {
                throw new RuntimeException("Failed to decode activeScript during CarryOnData serialization: " + s);
            });
        }
        this.selectedSlot = data.method_68083("selected", 0);
    }

    public CarryType getType() {
        return this.type;
    }

    public class_2487 getNbt() {
        this.nbt.method_10582("type", this.type.toString());
        this.nbt.method_10556("keyPressed", this.keyPressed);
        if (this.activeScript != null) {
            DataResult res = CarryOnScript.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.activeScript);
            class_2520 tag = (class_2520)res.getOrThrow(s -> {
                throw new RuntimeException("Failed to encode activeScript during CarryOnData serialization: " + s);
            });
            this.nbt.method_10566("activeScript", tag);
        }
        this.nbt.method_10569("selected", this.selectedSlot);
        return this.nbt;
    }

    public class_2487 getContentNbt() {
        if (this.type == CarryType.BLOCK && this.nbt.method_10545("block")) {
            return this.nbt.method_68568("block");
        }
        if (this.type == CarryType.ENTITY && this.nbt.method_10545("entity")) {
            return this.nbt.method_68568("entity");
        }
        return null;
    }

    public void setBlock(class_2680 state, @Nullable class_2586 tile, class_3222 player, class_2338 pos) {
        this.type = CarryType.BLOCK;
        if (state.method_28498((class_2769)class_2741.field_12508)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
        }
        class_2487 stateData = class_2512.method_10686((class_2680)state);
        this.nbt.method_10566("block", (class_2520)stateData);
        if (tile != null) {
            class_11362 output = class_11362.method_71459((class_8942)problemReporter, (class_7225.class_7874)player.method_56673());
            tile.method_38243((class_11372)output);
            class_2487 tileData = output.method_71475();
            this.nbt.method_10566("tile", (class_2520)tileData);
        }
    }

    public class_2680 getBlock() {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlock on data that contained " + String.valueOf((Object)this.type));
        }
        return class_2512.method_10681((class_7871)class_7923.field_41175, (class_2487)this.nbt.method_68568("block"));
    }

    @Nullable
    public class_2586 getBlockEntity(class_2338 pos, class_7225.class_7874 lookup) {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlockEntity on data that contained " + String.valueOf((Object)this.type));
        }
        if (!this.nbt.method_10545("tile")) {
            return null;
        }
        return class_2586.method_11005((class_2338)pos, (class_2680)this.getBlock(), (class_2487)this.nbt.method_68568("tile"), (class_7225.class_7874)lookup);
    }

    public void setEntity(class_1297 entity) {
        this.type = CarryType.ENTITY;
        class_11362 output = class_11362.method_71459((class_8942)new class_8942.class_11340(Constants.LOG), (class_7225.class_7874)entity.method_56673());
        entity.method_5662((class_11372)output);
        class_2487 entityData = output.method_71475();
        this.nbt.method_10566("entity", (class_2520)entityData);
    }

    public class_1297 getEntity(class_1937 level) {
        if (this.type != CarryType.ENTITY) {
            throw new IllegalStateException("Called getEntity on data that contained " + String.valueOf((Object)this.type));
        }
        class_11368 in = class_11352.method_71417((class_8942)problemReporter, (class_7225.class_7874)level.method_30349(), (class_2487)this.nbt.method_68568("entity"));
        Optional optionalEntity = class_1299.method_5892((class_11368)in, (class_1937)level, (class_3730)class_3730.field_16473);
        if (optionalEntity.isPresent()) {
            return (class_1297)optionalEntity.get();
        }
        Constants.LOG.error("Called EntityType#create even though no entity data was present. Data: " + this.nbt.toString());
        this.clear();
        return new class_1295(level, 0.0, 0.0, 0.0);
    }

    public Optional<CarryOnScript> getActiveScript() {
        if (this.activeScript == null) {
            return Optional.empty();
        }
        return Optional.of(this.activeScript);
    }

    public void setActiveScript(CarryOnScript script) {
        this.activeScript = script;
    }

    public void setCarryingPlayer(class_1657 player) {
        this.type = CarryType.PLAYER;
        this.nbt.method_10582("player", player.method_5845().toString());
    }

    public class_1657 getCarryingPlayer(class_1937 level) {
        if (this.type != CarryType.PLAYER) {
            throw new IllegalStateException("Called getCarryingPlayer on data that contained " + String.valueOf((Object)this.type));
        }
        if (!this.nbt.method_10545("player")) {
            return null;
        }
        UUID uuid = UUID.fromString((String)this.nbt.method_10558("player").get());
        return level.method_8503().method_3760().method_14602(uuid);
    }

    public boolean isCarrying() {
        return this.type != CarryType.INVALID;
    }

    public boolean isCarrying(CarryType type) {
        return this.type == type;
    }

    public boolean isKeyPressed() {
        return this.keyPressed;
    }

    public void setKeyPressed(boolean val) {
        this.keyPressed = val;
        this.nbt.method_10556("keyPressed", val);
    }

    public void setSelected(int selectedSlot) {
        this.selectedSlot = selectedSlot;
    }

    public int getSelected() {
        return this.selectedSlot;
    }

    public void clear() {
        this.type = CarryType.INVALID;
        this.nbt = new class_2487();
        this.activeScript = null;
    }

    public CarryOnData clone() {
        return new CarryOnData(this.nbt.method_10553());
    }

    public int getTick() {
        return this.nbt.method_68083("tick", -1);
    }

    public void setTick(int tick) {
        this.nbt.method_10569("tick", tick);
    }

    public static enum CarryType {
        BLOCK,
        ENTITY,
        PLAYER,
        INVALID;

    }
}

