/*
 * Decompiled with CFR 0.152.
 */
package jagm.jagmkiwis;

import jagm.jagmkiwis.KiwiDigGoal;
import jagm.jagmkiwis.KiwiModEntities;
import jagm.jagmkiwis.KiwiModItems;
import jagm.jagmkiwis.KiwiModSounds;
import jagm.jagmkiwis.LaserBeamEntity;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1451;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7995;

public class KiwiEntity
extends class_1429
implements class_1603 {
    private static final class_2940<Integer> DATA_TYPE_ID = class_2945.method_12791(KiwiEntity.class, (class_2941)class_2943.field_13327);
    private static final int CHANCE_OF_LASERS = 5;
    private static final class_4048 BABY_DIMENSIONS = KiwiModEntities.KIWI.method_18386().method_18383(0.75f).method_55685(0.25f);
    private KiwiDigGoal digGoal;
    private int digAnimationTick;
    public int eggTime;
    public boolean isKiwiJockey;

    protected KiwiEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.eggTime = this.field_5974.method_43048(12000) + 12000;
        this.isKiwiJockey = false;
    }

    protected void method_5959() {
        this.digGoal = new KiwiDigGoal((class_1308)this);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.0, stack -> stack.method_31573(class_3489.field_49943), false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new class_1338((class_1314)this, class_1451.class, 8.0f, 1.0, 1.0));
        this.field_6201.method_6277(6, (class_1352)this.digGoal);
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5958(class_3218 level) {
        this.digAnimationTick = this.digGoal.getDigAnimationTick();
        super.method_5958(level);
    }

    public void method_6007() {
        class_1937 class_19372;
        if (this.method_73183().method_8608()) {
            this.digAnimationTick = Math.max(0, this.digAnimationTick - 1);
        }
        if ((class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.method_5805() && !this.method_6109() && !this.isKiwiJockey && --this.eggTime <= 0) {
                this.method_5783(KiwiModSounds.KIWI_LAY_EGG, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
                this.method_5706(serverLevel, (class_1935)KiwiModItems.KIWI_EGG);
                this.method_32876((class_6880)class_5712.field_28738);
                this.eggTime = this.field_5974.method_43048(12000) + 12000;
            }
        }
        super.method_6007();
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(class_3489.field_49943);
    }

    public void method_5711(byte id) {
        if (id == 10) {
            this.digAnimationTick = 40;
        } else {
            super.method_5711(id);
        }
    }

    public float getHeadEatPositionScale(float partialTicks) {
        if (this.digAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.digAnimationTick >= 4 && this.digAnimationTick <= 36) {
            return 1.0f;
        }
        return this.digAnimationTick < 4 ? ((float)this.digAnimationTick - partialTicks) / 4.0f : -((float)(this.digAnimationTick - 40) - partialTicks) / 4.0f;
    }

    public float getHeadEatAngleScale(float partialTicks) {
        if (this.digAnimationTick > 4 && this.digAnimationTick <= 36) {
            float f = ((float)(this.digAnimationTick - 4) - partialTicks) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(f * 28.7f));
        }
        return this.digAnimationTick > 0 ? 0.62831855f : this.method_36455() * ((float)Math.PI / 180);
    }

    public KiwiEntity getBreedOffspring(class_3218 world, class_1296 kiwi) {
        boolean isLaserVariant;
        KiwiEntity babyKiwi = (KiwiEntity)KiwiModEntities.KIWI.method_5883((class_1937)world, class_3730.field_16466);
        boolean bl = isLaserVariant = this.method_59922().method_43048(100) < 5;
        if (babyKiwi != null) {
            babyKiwi.setVariant(isLaserVariant ? Variant.LASER : Variant.NORMAL);
        }
        return babyKiwi;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_61457().method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23716, 5.0).method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_23717, 40.0);
    }

    protected class_3414 method_5994() {
        return KiwiModSounds.KIWI_AMBIENT;
    }

    public void method_5966() {
        if (this.method_73183().method_8597().method_29960() || this.method_73183().method_23886()) {
            super.method_5966();
        }
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return KiwiModSounds.KIWI_HURT;
    }

    protected class_3414 method_6002() {
        return KiwiModSounds.KIWI_DEATH;
    }

    protected void method_5712(class_2338 pos, class_2680 blockState) {
        this.method_5783(class_3417.field_14685, 0.15f, 1.0f);
    }

    protected float method_6107() {
        return 0.3f;
    }

    public int method_5970() {
        return 160;
    }

    private void setVariant(Variant variant) {
        if (variant == Variant.LASER) {
            this.method_5996(class_5134.field_23724).method_6192(8.0);
            this.field_6201.method_6277(3, (class_1352)new class_1381((class_1603)this, 1.0, 20, 40, 20.0f));
            this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
            this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1588.class, true, (target, level) -> !(target instanceof class_1548)));
        } else {
            this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.0));
        }
        this.field_6011.method_12778(DATA_TYPE_ID, (Object)variant.id);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.field_6011.method_12789(DATA_TYPE_ID));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_TYPE_ID, (Object)Variant.NORMAL.id);
    }

    public void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71472("IsKiwiJockey", this.isKiwiJockey);
        valueOutput.method_71465("EggLayTime", this.eggTime);
        valueOutput.method_71465("KiwiType", this.getVariant().id);
    }

    public void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        this.isKiwiJockey = valueInput.method_71433("IsKiwiJockey", false);
        valueInput.method_71439("EggLayTime").ifPresent(eggTime -> {
            this.eggTime = eggTime;
        });
        Optional id = valueInput.method_71439("KiwiType");
        this.setVariant(id.isPresent() ? Variant.byId((Integer)id.get()) : Variant.NORMAL);
    }

    public class_1315 method_5943(class_5425 levelAccessor, class_1266 difficulty, class_3730 spawnReason, class_1315 spawnGroupData) {
        boolean isLaserVariant = levelAccessor.method_8409().method_43048(100) < 5;
        this.setVariant(isLaserVariant ? Variant.LASER : Variant.NORMAL);
        return super.method_5943(levelAccessor, difficulty, spawnReason, spawnGroupData);
    }

    public void method_7105(class_1309 target, float velocity) {
        LaserBeamEntity laser = new LaserBeamEntity(this.method_73183(), (class_1309)this);
        double d0 = target.method_23317() - this.method_23317();
        double d1 = target.method_23320() - this.method_23320();
        double d2 = target.method_23321() - this.method_23321();
        laser.method_33574(new class_243(this.method_23317(), this.method_23320(), this.method_23321()).method_1019(new class_243(d0, d1, d2).method_1029()));
        laser.method_7485(d0, d1, d2, 1.5f, 0.0f);
        this.method_73183().method_8649((class_1297)laser);
        if (!this.method_5701()) {
            this.method_43077(KiwiModSounds.LASER_SHOOT);
        }
    }

    public class_4048 method_55694(class_4050 pose) {
        return this.method_6109() ? BABY_DIMENSIONS : super.method_55694(pose);
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 size, float partialTicks) {
        class_243 offset = new class_243(0.0, 0.0, -0.1875);
        return super.method_52533(passenger, size, partialTicks).method_1019(offset.method_1024(-this.field_6283 * (float)Math.PI / 180.0f));
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 moveFunction) {
        super.method_5865(passenger, moveFunction);
        if (passenger instanceof class_1309) {
            class_1309 livingPassenger = (class_1309)passenger;
            livingPassenger.field_6283 = this.field_6283;
        }
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return this.isKiwiJockey;
    }

    public static enum Variant implements class_3542
    {
        NORMAL(0, "normal"),
        LASER(99, "laser");

        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public int id() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = class_7995.method_47915(Variant::id, (Object[])Variant.values(), (Object)((Object)NORMAL));
        }
    }
}

