/*
 * Decompiled with CFR 0.152.
 */
package com.franco227.stone_is_stone.config;

import com.franco227.stone_is_stone.StoneIsStone;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.spongepowered.include.com.google.gson.Gson;
import org.spongepowered.include.com.google.gson.GsonBuilder;
import org.spongepowered.include.com.google.gson.JsonSyntaxException;

public class SISConfig {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public String version = "1";
    public List<String> stone_variants = List.of("minecraft:andesite", "minecraft:diorite", "minecraft:granite", "minecraft:end_stone", "minecraft:stone", "minecraft:deepslate", "minecraft:mossy_cobblestone");

    public List<class_1792> getStoneVariantsItems() {
        ArrayList<class_1792> STONE_VARIANTS_ITEMS = new ArrayList<class_1792>(List.of());
        this.stone_variants.forEach(variant -> STONE_VARIANTS_ITEMS.add((class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)variant))));
        return STONE_VARIANTS_ITEMS;
    }

    public static SISConfig loadConfig(File file) {
        SISConfig config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (SISConfig)gson.fromJson((Reader)fileReader, SISConfig.class);
            }
            catch (JsonSyntaxException e) {
                String error_message = "[Stone Is Stone] Failed to load config: %s".formatted(e.getMessage().split(": ")[1]);
                StoneIsStone.LOGGER.error(error_message);
            }
            catch (Exception e) {
                StoneIsStone.LOGGER.error("[Stone Is Stone] Failed to load config: ", (Throwable)e);
            }
        }
        if (config == null) {
            StoneIsStone.LOGGER.info("[Stone Is Stone] Recreating config.");
            config = new SISConfig();
        }
        config.saveConfig(file);
        String loaded_message = "[Stone Is Stone] Loaded config! (config v%s)".formatted(config.version);
        StoneIsStone.LOGGER.info(loaded_message);
        return config;
    }

    public void saveConfig(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            StoneIsStone.LOGGER.error("[Stone Is Stone] Failed to save config: ", (Throwable)e);
        }
    }
}

