/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.utils.statistics;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.interfaces.IMinecraftServer;
import me.wesley1808.servercore.common.utils.ChunkManager;
import me.wesley1808.servercore.common.utils.statistics.entry.EntityStatisticEntry;
import me.wesley1808.servercore.common.utils.statistics.entry.StatisticEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5562;
import net.minecraft.server.MinecraftServer;

public class Statistics {
    private final MinecraftServer server;

    public Statistics(MinecraftServer server) {
        this.server = server;
    }

    public static Statistics getInstance(MinecraftServer server) {
        return ((IMinecraftServer)server).servercore$getStatistics();
    }

    public List<class_1297> getAllEntities() {
        return this.getAll(class_3218::method_27909);
    }

    public List<class_5562> getAllBlockEntities() {
        return this.getAll(level -> level.field_27082);
    }

    public Map<String, StatisticEntry<class_1297>> getEntitiesByType(Iterable<class_1297> entities) {
        return this.getByType(entities, entity -> class_1299.method_5890((class_1299)entity.method_5864()).toString(), EntityStatisticEntry::new);
    }

    public Map<String, StatisticEntry<class_5562>> getBlockEntitiesByType(Iterable<class_5562> blockEntities) {
        return this.getByType(blockEntities, class_5562::method_31706, StatisticEntry::new);
    }

    public Map<String, StatisticEntry<class_1297>> getEntitiesByPlayer(Iterable<class_3222> players) {
        return this.getByPlayer(players, this::getEntitiesNear, EntityStatisticEntry::new);
    }

    public Map<String, StatisticEntry<class_5562>> getBlockEntitiesByPlayer(Iterable<class_3222> players) {
        return this.getByPlayer(players, this::getBlockEntitiesNear, StatisticEntry::new);
    }

    private <T> List<T> getAll(Function<class_3218, Iterable<T>> function) {
        ObjectArrayList list = new ObjectArrayList();
        for (class_3218 level : this.server.method_3738()) {
            Iterables.addAll((Collection)list, function.apply(level));
        }
        return list;
    }

    private <T> Map<String, StatisticEntry<T>> getByType(Iterable<T> iterable, Function<T, String> function, Supplier<StatisticEntry<T>> supplier) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (T value : iterable) {
            String key = function.apply(value);
            StatisticEntry entry = map.computeIfAbsent(key, k -> (StatisticEntry)supplier.get());
            entry.increment(value);
        }
        return map;
    }

    private <T> Map<String, StatisticEntry<T>> getByPlayer(Iterable<class_3222> players, Function<class_3222, List<T>> function, Supplier<StatisticEntry<T>> supplier) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (class_3222 player : players) {
            StatisticEntry<T> entry = supplier.get();
            for (T value : function.apply(player)) {
                entry.increment(value);
            }
            map.put(player.method_5820(), entry);
        }
        return map;
    }

    public List<class_1297> getEntitiesNear(class_3222 player) {
        ObjectArrayList list = new ObjectArrayList();
        for (class_1297 entity : player.method_51469().method_27909()) {
            if (!this.isNearby((class_1657)player, entity.method_31476())) continue;
            list.add(entity);
        }
        return list;
    }

    public List<class_5562> getBlockEntitiesNear(class_3222 player) {
        ObjectArrayList list = new ObjectArrayList();
        for (class_5562 blockEntity : player.method_51469().field_27082) {
            class_2338 pos = blockEntity.method_31705();
            if (pos == null || !this.isNearby((class_1657)player, new class_1923(pos))) continue;
            list.add(blockEntity);
        }
        return list;
    }

    public int getChunkCount(boolean onlyLoaded) {
        int count = 0;
        for (class_3218 level : this.server.method_3738()) {
            if (onlyLoaded) {
                for (class_3193 holder : level.method_14178().field_17254.field_17220.values()) {
                    if (!ChunkManager.hasChunk(level, holder)) continue;
                    ++count;
                }
                continue;
            }
            count += level.method_14178().method_14151();
        }
        return count;
    }

    private boolean isNearby(class_1657 player, class_1923 pos) {
        return player.method_31476().method_24022(pos) <= DynamicSetting.VIEW_DISTANCE.get();
    }
}

