/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config.data.activation_range;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import me.wesley1808.servercore.common.activation_range.EntityTypeTests;
import me.wesley1808.servercore.common.config.data.activation_range.ActivationType;
import me.wesley1808.servercore.common.config.data.activation_range.CustomActivationType;
import me.wesley1808.servercore.common.config.impl.activation_range.CustomActivationTypeImpl;
import me.wesley1808.servercore.common.config.serialization.EntityTypeSerializer;
import net.minecraft.class_1299;
import net.minecraft.class_5575;
import space.arim.dazzleconf.annote.ConfComments;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.ConfSerialisers;
import space.arim.dazzleconf.annote.SubSection;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

@ConfSerialisers(value={EntityTypeSerializer.class})
public interface ActivationRangeConfig {
    @AnnotationBasedSorter.Order(value=1)
    @ConfKey(value="enabled")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Enables activation range."})
    public boolean enabled();

    @AnnotationBasedSorter.Order(value=2)
    @ConfKey(value="tick-new-entities")
    @ConfDefault.DefaultBoolean(value=true)
    @ConfComments(value={"Briefly ticks entities newly added to the world for 10 seconds (includes both spawning and loading).", "This gives them a chance to properly immunize when they are spawned if they should be. Can be helpful for mobfarms."})
    public boolean tickNewEntities();

    @AnnotationBasedSorter.Order(value=3)
    @ConfKey(value="use-vertical-range")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Enables vertical range checks. By default, activation ranges only work horizontally.", "This can greatly improve performance on taller worlds, but might break a few very specific ai-based mobfarms."})
    public boolean useVerticalRange();

    @AnnotationBasedSorter.Order(value=4)
    @ConfKey(value="skip-non-immune")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Skips 1/4th of entity ticks whilst not immune.", "This affects entities that are within the activation range, but not immune (for example by falling or being in water)."})
    public boolean skipNonImmune();

    @AnnotationBasedSorter.Order(value=5)
    @ConfKey(value="villager-tick-panic")
    @ConfDefault.DefaultBoolean(value=true)
    @ConfComments(value={"Allows villagers to tick regardless of the activation range when panicking."})
    public boolean villagerTickPanic();

    @AnnotationBasedSorter.Order(value=6)
    @ConfKey(value="villager-work-immunity-after")
    @ConfDefault.DefaultInteger(value=20)
    @ConfComments(value={"The time in seconds that a villager needs to be inactive for before obtaining work immunity (if it has work tasks)."})
    public int villagerWorkImmunityAfter();

    @AnnotationBasedSorter.Order(value=7)
    @ConfKey(value="villager-work-immunity-for")
    @ConfDefault.DefaultInteger(value=20)
    @ConfComments(value={"The amount of ticks an inactive villager will wake up for when it has work immunity."})
    public int villagerWorkImmunityFor();

    @AnnotationBasedSorter.Order(value=8)
    @ConfKey(value="excluded-entity-types")
    @ConfDefault.DefaultObject(value="defaultExcludedEntityTypes")
    @ConfComments(value={"A list of entity types that should be excluded from activation range checks."})
    public Set<class_1299<?>> excludedEntityTypes();

    @AnnotationBasedSorter.Order(value=9)
    @SubSection
    @ConfKey(value="default-activation-type")
    @ConfComments(value={"The activation type that will get assigned to any entity that doesn't have a custom activation type.", "\u25ba activation-range = The range an entity is required to be in from a player to be activated.", "\u25ba tick-interval = The interval between 'active' ticks whilst the entity is inactive. Negative values will disable these active ticks.", "\u25ba wakeup-interval = The interval between inactive entity wakeups in seconds.", "\u25ba extra-height-up = Allows entities to be ticked when far above the player when vertical range is in use.", "\u25ba extra-height-down = Allows entities to be ticked when far below the player when vertical range is in use."})
    public ActivationType defaultActivationType();

    @AnnotationBasedSorter.Order(value=10)
    @ConfKey(value="custom-activation-types")
    @ConfDefault.DefaultObject(value="defaultActivationTypes")
    @ConfComments(value={"A list of custom activation types.", "\u25ba name = The name of the activation type.", "\u25ba entity-matcher = A list of conditions to filter entities. Only one of these conditions needs to be met for an entity to match.", "\u25ba If an entity matches multiple activation types, the one highest in the list will be used. The conditions accept the following formats:", "  - Entity type matching    |   Uses the entity type's identifier.  |  'minecraft:zombie' matches zombies, but for example not husks or drowned.", "  - Typeof class matching   |   Uses the 'typeof:' prefix.          |  'typeof:monster' matches all monsters.", "\u25ba Available typeof classes: mob, monster, raider, neutral, ambient, animal, water_animal, flying_animal, villager, projectile."})
    public List<@SubSection CustomActivationType> activationTypes();

    public static Set<class_1299<?>> defaultExcludedEntityTypes() {
        return Sets.newHashSet((Object[])new class_1299[]{class_1299.field_6058, class_1299.field_38095, class_1299.field_6107});
    }

    public static List<CustomActivationType> defaultActivationTypes() {
        return Lists.newArrayList((Object[])new CustomActivationType[]{new CustomActivationTypeImpl("raider", Lists.newArrayList((Object[])new class_5575[]{EntityTypeTests.RAIDER}), 48, 20, 20, true, false), new CustomActivationTypeImpl("water", Lists.newArrayList((Object[])new class_5575[]{EntityTypeTests.WATER_ANIMAL}), 16, 20, 60, false, false), new CustomActivationTypeImpl("villager", Lists.newArrayList((Object[])new class_5575[]{EntityTypeTests.VILLAGER}), 16, 20, 30, false, false), new CustomActivationTypeImpl("zombie", Lists.newArrayList((Object[])new class_5575[]{class_1299.field_6051, class_1299.field_6071}), 16, 20, 20, true, false), new CustomActivationTypeImpl("monster-below", Lists.newArrayList((Object[])new class_5575[]{class_1299.field_6046, class_1299.field_6069, class_1299.field_6102, class_1299.field_21973}), 32, 20, 20, true, true), new CustomActivationTypeImpl("flying-monster", Lists.newArrayList((Object[])new class_5575[]{class_1299.field_6107, class_1299.field_6078}), 48, 20, 20, true, false), new CustomActivationTypeImpl("monster", Lists.newArrayList((Object[])new class_5575[]{EntityTypeTests.MONSTER}), 32, 20, 20, true, false), new CustomActivationTypeImpl("animal", Lists.newArrayList((Object[])new class_5575[]{EntityTypeTests.ANIMAL, EntityTypeTests.AMBIENT}), 16, 20, 60, false, false), new CustomActivationTypeImpl("creature", Lists.newArrayList((Object[])new class_5575[]{EntityTypeTests.MOB}), 24, 20, 30, false, false)});
    }
}

