/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.snowundertrees.compat;

import dev.imb11.snowundertrees.config.SnowUnderTreesConfig;
import dev.imb11.snowundertrees.mixins.ThreadedAnvilChunkStorageInvoker;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2493;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4538;
import net.minecraft.class_9259;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsEntrypoint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SnowUnderTrees/SereneSeasons");
    public static boolean isSereneSeasonsLoaded = false;
    private static final HashMap<Object, Integer> MELT_CHANCES = new HashMap();

    public static boolean isBiomeSuitable(class_3218 world, class_2338 biomeCheckPos) {
        return SeasonHooks.coldEnoughToSnowSeasonal((class_4538)world, (class_2338)biomeCheckPos, (int)world.method_8615());
    }

    public static boolean isWarmEnoughToRainSeasonal(class_3218 world, class_2338 pos) {
        return SeasonHooks.warmEnoughToRainSeasonal((class_4538)world, (class_2338)pos, (int)world.method_8615());
    }

    public static void initialize() {
        if (!FabricLoader.getInstance().isModLoaded("sereneseasons")) {
            return;
        }
        LOGGER.info("Serene Seasons detected!");
        isSereneSeasonsLoaded = true;
    }

    public static void attemptMeltSnow(class_3218 serverWorld) {
        if (SereneSeasonsEntrypoint.isWinter((class_1937)serverWorld) && !SnowUnderTreesConfig.get().meltSnowSeasonally) {
            return;
        }
        if (!SereneSeasonsEntrypoint.shouldMeltSnow(serverWorld, SeasonHelper.getSeasonState((class_1937)serverWorld).getSubSeason())) {
            return;
        }
        ThreadedAnvilChunkStorageInvoker chunkStorage = (ThreadedAnvilChunkStorageInvoker)serverWorld.method_14178().field_17254;
        for (class_3193 chunkHolder : chunkStorage.invokeEntryIterator(class_2806.field_12798).toList()) {
            class_2680 before;
            class_2338 pos;
            class_2338 randomPosition;
            class_2338 heightmapPosition;
            class_2680 blockState;
            class_2818 chunk;
            class_9259 optionalChunk = chunkHolder.method_16145().getNow(class_3193.field_16427);
            if (!optionalChunk.method_57122() || !serverWorld.method_39425((chunk = (class_2818)optionalChunk.method_57132(() -> new IllegalStateException("Chunk is not present"))).method_12004().method_8324()) || !(blockState = serverWorld.method_8320(heightmapPosition = serverWorld.method_8598(class_2902.class_2903.field_13197, randomPosition = serverWorld.method_8536(chunk.method_12004().method_8326(), 0, chunk.method_12004().method_8328(), 15)).method_10074())).method_26164(class_3481.field_15503) || !SereneSeasonsEntrypoint.isWarmEnoughToRainSeasonal(serverWorld, pos = serverWorld.method_8598(class_2902.class_2903.field_13203, randomPosition)) || !(before = serverWorld.method_8320(pos)).method_27852(class_2246.field_10477)) continue;
            serverWorld.method_8501(pos, class_2246.field_10124.method_9564());
            class_2338 downPos = pos.method_10074();
            class_2680 below = serverWorld.method_8320(downPos);
            if (!below.method_28498((class_2769)class_2493.field_11522)) continue;
            serverWorld.method_8652(downPos, (class_2680)below.method_11657((class_2769)class_2493.field_11522, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    private static boolean shouldMeltSnow(class_3218 world, Season.SubSeason subSeason) {
        int chance = MELT_CHANCES.getOrDefault(subSeason, -1);
        if (chance == -1) {
            return false;
        }
        int rnd = world.field_9229.method_39332(0, chance);
        return rnd == 0;
    }

    public static boolean isWinter(class_1937 world) {
        return SeasonHelper.getSeasonState((class_1937)world).getSeason() == Season.WINTER;
    }

    public static boolean shouldPlaceSnow(class_1937 world, class_2338 pos) {
        if (isSereneSeasonsLoaded) {
            return ModConfig.seasons.generateSnowAndIce && SereneSeasonsEntrypoint.isBiomeSuitable((class_3218)world, pos);
        }
        return false;
    }

    static {
        if (FabricLoader.getInstance().isModLoaded("sereneseasons")) {
            MELT_CHANCES.put(Season.SubSeason.EARLY_SPRING, 16);
            MELT_CHANCES.put(Season.SubSeason.MID_SPRING, 12);
            MELT_CHANCES.put(Season.SubSeason.LATE_SPRING, 8);
            MELT_CHANCES.put(Season.SubSeason.EARLY_SUMMER, 4);
            MELT_CHANCES.put(Season.SubSeason.MID_SUMMER, 2);
            MELT_CHANCES.put(Season.SubSeason.LATE_SUMMER, 1);
            MELT_CHANCES.put(Season.SubSeason.EARLY_AUTUMN, 8);
            MELT_CHANCES.put(Season.SubSeason.MID_AUTUMN, 12);
            MELT_CHANCES.put(Season.SubSeason.LATE_AUTUMN, 16);
        }
    }
}

