/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.tanks;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TanksUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidWidget;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.FluidUtil;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class TankWidget
extends UpgradeWidgetBase<TanksUpgrade> {
    public final WidgetElement leftTankElement;
    public final WidgetElement rightTankElement;
    public final int tankWidth = 18;
    public final int tankHeight;
    public final Point leftTankPos;
    public final Point rightTankPos;

    public TankWidget(BackpackScreen screen, TanksUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(0, 0), "screen.travelersbackpack.tanks_upgrade");
        this.tankHeight = 18 * screen.visibleRows;
        this.leftTankPos = new Point(screen.getGuiLeft() + 7, screen.getGuiTop() + 17);
        this.rightTankPos = new Point(screen.getGuiLeft() + 195 + (screen.getWrapper().isExtended() ? 36 : 0), screen.getGuiTop() + 17);
        this.leftTankElement = new WidgetElement(this.leftTankPos, new Point(this.tankWidth, this.tankHeight));
        this.rightTankElement = new WidgetElement(this.rightTankPos, new Point(this.tankWidth, this.tankHeight));
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.inTank(this.leftTankElement, mouseX, mouseY)) {
            guiGraphics.method_51434(((BackpackScreen)this.screen).method_64506(), this.getTankTooltip(((TanksUpgrade)this.upgrade).leftTank), mouseX, mouseY);
        }
        if (this.inTank(this.rightTankElement, mouseX, mouseY)) {
            guiGraphics.method_51434(((BackpackScreen)this.screen).method_64506(), this.getTankTooltip(((TanksUpgrade)this.upgrade).rightTank), mouseX, mouseY);
        }
    }

    @Override
    public void renderAboveBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int rows = ((TanksUpgrade)this.upgrade).getUpgradeManager().getWrapper().getRows();
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).leftTank, this.leftTankPos.x() + 1, this.leftTankPos.y() + 1, 0.0, this.getTankHeight(rows), 16.0);
        this.renderTank(guiGraphics, this.leftTankElement, 0, mouseX, mouseY, rows, this.leftTankPos.x(), this.leftTankPos.y());
        RenderHelper.renderScreenTank(guiGraphics, ((TanksUpgrade)this.upgrade).rightTank, this.rightTankPos.x() + 1, this.rightTankPos.y() + 1, 0.0, this.getTankHeight(rows), 16.0);
        this.renderTank(guiGraphics, this.rightTankElement, 1, mouseX, mouseY, rows, this.rightTankPos.x(), this.rightTankPos.y());
    }

    public int getTankHeight(int rows) {
        return (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) * 18 - 2;
    }

    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (this.inTank(this.leftTankElement, event.comp_4798(), event.comp_4799()) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_34255())) {
            ServerboundActionTagPacket.create(5, true);
            return true;
        }
        if (this.inTank(this.rightTankElement, event.comp_4798(), event.comp_4799()) && this.isValid(((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_34255())) {
            ServerboundActionTagPacket.create(5, false);
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    @Override
    public boolean method_25405(double pMouseX, double pMouseY) {
        if ((this.inTank(this.leftTankElement, pMouseX, pMouseY) || this.inTank(this.rightTankElement, pMouseX, pMouseY)) && !((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).method_34255().method_7960()) {
            return true;
        }
        return super.method_25405(pMouseX, pMouseY);
    }

    public boolean isValid(class_1799 stack) {
        return FluidUtil.hasFluidStorageConstant(stack) || stack.method_7909() instanceof class_1812;
    }

    public void renderTank(class_332 guiGraphics, WidgetElement tankElement, int tankIndex, int mouseX, int mouseY, int rows, int x, int y) {
        WidgetBase<?> widgetBase = ((BackpackScreen)this.screen).mappedWidgets.get(VoidUpgrade.class);
        if (widgetBase instanceof VoidWidget) {
            VoidWidget voidWidget = (VoidWidget)widgetBase;
            voidWidget.drawRedTankHighlight(guiGraphics, x + 1, y + 1, this.inTank(tankElement, mouseX, mouseY), this.getTankHeight(rows), tankIndex);
        }
        guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, x, y, 0.0f, 95.0f, 18, 18, 256, 256);
        for (int i = 1; i <= (((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) - 2; ++i) {
            guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, x, y + 18 * i, 0.0f, 113.0f, 18, 18, 256, 256);
        }
        guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, x, y + 18 * ((((BackpackScreen)this.screen).isScrollable ? ((BackpackScreen)this.screen).visibleRows : rows) - 1), 0.0f, 131.0f, 18, 18, 256, 256);
    }

    @Environment(value=EnvType.CLIENT)
    public List<class_2561> getTankTooltip(FluidTank tank) {
        Object fluidAmount;
        FluidVariantWrapper fluidStack = tank.getFluid();
        ArrayList<class_2561> tankTips = new ArrayList<class_2561>();
        String fluidName = !fluidStack.isEmpty() ? FluidTypeHelper.getFluidVariantName(fluidStack.fluidVariant()).getString() : class_1074.method_4662((String)"screen.travelersbackpack.none", (Object[])new Object[0]);
        Object object = fluidAmount = !fluidStack.isEmpty() ? fluidStack.getAmount() + "/" + tank.getCapacity() : class_1074.method_4662((String)"screen.travelersbackpack.empty", (Object[])new Object[0]);
        if (!fluidStack.isEmpty() && fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651) != null && fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651).isPresent()) {
            float durationFactor = 1.0f;
            if (fluidStack.fluidVariant().getComponentMap().method_57832(class_9334.field_49628) && ((class_9279)fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49628).get()).method_57461().method_10545("PotionType")) {
                int potionType = ((class_9279)fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49628).get()).method_57461().method_68083("PotionType", 0);
                if (potionType == 1) {
                    tankTips.add((class_2561)class_2561.method_43471((String)"item.minecraft.splash_potion"));
                }
                if (potionType == 2) {
                    tankTips.add((class_2561)class_2561.method_43471((String)"item.minecraft.lingering_potion"));
                    durationFactor = 0.25f;
                }
            }
            fluidName = null;
            class_1844 contents = (class_1844)fluidStack.fluidVariant().getComponents().method_57845(class_9334.field_49651).get();
            if (class_310.method_1551().field_1687 != null) {
                class_1844.method_8065((Iterable)contents.method_57397(), tankTips::add, (float)durationFactor, (float)class_310.method_1551().field_1687.method_54719().method_54748());
            }
        }
        if (fluidName != null) {
            tankTips.add((class_2561)class_2561.method_43470((String)fluidName));
        }
        tankTips.add((class_2561)class_2561.method_43470((String)fluidAmount));
        return tankTips;
    }

    public boolean inTank(WidgetElement tankElement, double mouseX, double mouseY) {
        return mouseX >= (double)tankElement.pos().x() && mouseX < (double)(tankElement.pos().x() + tankElement.size().x()) && mouseY >= (double)tankElement.pos().y() && mouseY < (double)(tankElement.pos().y() + tankElement.size().y());
    }
}

