/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.jukebox;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.UpgradeWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetElement;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxUpgrade;
import com.tiviacz.travelersbackpack.network.ServerboundActionTagPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1101;
import net.minecraft.class_1117;
import net.minecraft.class_11909;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import net.minecraft.class_9793;
import org.jetbrains.annotations.Nullable;

public class JukeboxWidget
extends UpgradeWidgetBase<JukeboxUpgrade> {
    private final WidgetElement playButton = new WidgetElement(new Point(24, 22), new Point(18, 18));
    private final WidgetElement stopButton = new WidgetElement(new Point(42, 22), new Point(18, 18));

    public JukeboxWidget(BackpackScreen screen, JukeboxUpgrade upgrade, Point pos) {
        super(screen, upgrade, pos, new Point(137, 103), "screen.travelersbackpack.jukebox_upgrade");
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.isTabOpened()) {
            if (this.isMouseOverPlayButton(mouseX, mouseY)) {
                guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.pos.x() + this.playButton.pos().x(), this.pos.y() + this.playButton.pos().y(), 24.0f, 18.0f, this.playButton.size().x(), this.playButton.size().y(), 256, 256);
            }
            if (this.isMouseOverStopButton(mouseX, mouseY)) {
                guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.pos.x() + this.stopButton.pos().x(), this.pos.y() + this.stopButton.pos().y(), 24.0f, 18.0f, this.stopButton.size().x(), this.stopButton.size().y(), 256, 256);
            }
        }
    }

    @Override
    public void renderBg(class_332 guiGraphics, int x, int y, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, x, y, mouseX, mouseY);
        if (this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).isPlayingRecord()) {
            guiGraphics.method_25290(class_10799.field_56883, BackpackScreen.ICONS, this.pos.x() + 6, this.pos.y() + 22, 24.0f, 36.0f, 18, 18, 256, 256);
        }
    }

    @Override
    public boolean method_25402(class_11909 event, boolean doubleClick) {
        if (((JukeboxUpgrade)this.upgrade).getUpgradeManager().getWrapper().getScreenID() == 2 && this.isMouseOverPlayButton(event.comp_4798(), event.comp_4799()) && this.isBackpackOwner() && this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).canPlayRecord()) {
            ServerboundActionTagPacket.create(0, this.dataHolderSlot, true, 3);
            this.playDiscToPlayer(((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).getPlayerInventory().field_7546.method_5628(), this.getFromDisk(((JukeboxUpgrade)this.upgrade).diskHandler.getStackInSlot(0)));
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        if (this.isMouseOverStopButton(event.comp_4798(), event.comp_4799()) && this.isBackpackOwner() && this.isTabOpened() && ((JukeboxUpgrade)this.upgrade).isPlayingRecord()) {
            ServerboundActionTagPacket.create(0, this.dataHolderSlot, false, 3);
            if (((JukeboxUpgrade)this.upgrade).getUpgradeManager().getWrapper().getScreenID() == 2) {
                this.stopDisc(this.getFromDisk(((JukeboxUpgrade)this.upgrade).diskHandler.getStackInSlot(0)));
            }
            ((BackpackScreen)this.screen).playUIClickSound();
            return true;
        }
        return super.method_25402(event, doubleClick);
    }

    public boolean isMouseOverPlayButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.playButton);
    }

    public boolean isMouseOverStopButton(double mouseX, double mouseY) {
        return this.isWithinBounds(mouseX, mouseY, this.stopButton);
    }

    @Nullable
    public class_9793 getFromDisk(class_1799 stack) {
        if (stack.method_57826(class_9334.field_52175)) {
            return (class_9793)((class_6880)class_9793.method_60753((class_7225.class_7874)((BackpackBaseMenu)((BackpackScreen)this.screen).method_17577()).getPlayerInventory().field_7546.method_56673(), (class_1799)stack).get()).comp_349();
        }
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public void playDiscToPlayer(int entityId, @Nullable class_9793 jukeboxSong) {
        if (jukeboxSong == null) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(entityId);
        if (entity == null) {
            return;
        }
        class_310.method_1551().method_1483().method_22140((class_1117)new MovingSound(entity, (class_3414)jukeboxSong.comp_2835().comp_349()));
        class_310.method_1551().field_1705.method_1732(jukeboxSong.comp_2836());
    }

    @Environment(value=EnvType.CLIENT)
    public void stopDisc(class_9793 jukeboxSong) {
        if (jukeboxSong == null) {
            return;
        }
        class_310.method_1551().method_1483().method_4875(((class_3414)jukeboxSong.comp_2835().comp_349()).comp_3319(), class_3419.field_15254);
    }

    public static class MovingSound
    extends class_1101 {
        private final class_1297 entity;

        public MovingSound(class_1297 entityIn, class_3414 soundIn) {
            super(soundIn, class_3419.field_15254, entityIn.method_73183().method_8409());
            this.entity = entityIn;
            this.field_5446 = false;
            this.field_5451 = 0;
            this.field_5442 = 1.0f;
        }

        public void method_16896() {
            class_1657 player;
            class_1297 class_12972 = this.entity;
            if (!(!(class_12972 instanceof class_1657) || ComponentUtils.isWearingBackpack(player = (class_1657)class_12972) && this.shouldStopPlaying(player))) {
                this.method_24876();
            }
            if (!this.entity.method_5805()) {
                this.method_24876();
            } else {
                this.field_5439 = (float)this.entity.method_23317();
                this.field_5450 = (float)this.entity.method_23318();
                this.field_5449 = (float)this.entity.method_23321();
            }
        }

        public boolean shouldStopPlaying(class_1657 player) {
            return ComponentUtils.getBackpackWrapper(player, ComponentUtils.UPGRADES_ONLY).getUpgradeManager().getUpgrade(JukeboxUpgrade.class).isPresent();
        }
    }
}

