/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.jukebox;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.components.BackpackContainerContents;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.UpgradeSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.jukebox.JukeboxWidget;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_9334;

public class JukeboxUpgrade
extends UpgradeBase<JukeboxUpgrade> {
    public ItemStackHandler diskHandler;

    public JukeboxUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> musicDiskContents) {
        super(manager, dataHolderSlot, new Point(66, 46));
        this.diskHandler = this.createHandler(musicDiskContents);
    }

    @Override
    public void onUpgradeRemoved(class_1799 removedStack) {
        removedStack.method_57379(ModDataComponents.IS_PLAYING, (Object)false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new JukeboxWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Pair<Integer, Integer>> getUpgradeSlotsPosition(int x, int y) {
        ArrayList<Pair<Integer, Integer>> positions = new ArrayList<Pair<Integer, Integer>>();
        positions.add(Pair.of((Object)(x + 7), (Object)(y + 23)));
        return positions;
    }

    @Override
    public List<class_1735> getUpgradeSlots(BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        slots.add(new UpgradeSlotItemHandler<JukeboxUpgrade>(this, this.diskHandler, 0, x + 7, y + 23){

            @Override
            public boolean method_7680(class_1799 pStack) {
                return JukeboxUpgrade.this.isTabOpened() && (Boolean)JukeboxUpgrade.this.getDataHolderStack().method_58695(ModDataComponents.IS_PLAYING, (Object)false) == false;
            }

            @Override
            public boolean method_7674(class_1657 playerIn) {
                return super.method_7674(playerIn) && (Boolean)JukeboxUpgrade.this.getDataHolderStack().method_58695(ModDataComponents.IS_PLAYING, (Object)false) == false;
            }
        });
        return slots;
    }

    public boolean isPlayingRecord() {
        return (Boolean)this.getDataHolderStack().method_58695(ModDataComponents.IS_PLAYING, (Object)false);
    }

    public boolean canPlayRecord() {
        return !this.isPlayingRecord() && !this.diskHandler.getStackInSlot(0).method_7960();
    }

    public void setSlotChanged(class_1799 dataHolderStack, int index, class_1799 stack) {
        dataHolderStack.method_57367(ModDataComponents.BACKPACK_CONTAINER, (Object)new BackpackContainerContents(1), (Object)new BackpackContainerContents.Slot(index, stack), BackpackContainerContents::updateSlot);
    }

    private ItemStackHandler createHandler(class_2371<class_1799> stacks) {
        return new ItemStackHandler(stacks){

            @Override
            protected void onContentsChanged(int slot) {
                JukeboxUpgrade.this.updateDataHolderUnchecked(dataHolderStack -> JukeboxUpgrade.this.setSlotChanged((class_1799)dataHolderStack, slot, this.getStackInSlot(slot)));
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return stack.method_57826(class_9334.field_52175);
            }
        };
    }
}

