/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.trashslot;

import com.google.common.collect.Lists;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.trashslot.api.SlotRenderStyle;
import net.blay09.mods.trashslot.api.Snap;
import net.blay09.mods.trashslot.client.gui.layout.SimpleGuiContainerLayout;
import net.minecraft.class_465;
import net.minecraft.class_768;

public class BackpackLayout
extends SimpleGuiContainerLayout {
    public static final int PLAYER_INVENTORY_WIDTH = 176;

    public BackpackLayout() {
        this.setEnabledByDefault();
    }

    public int getDefaultSlotX(class_465<?> screen) {
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
        if (screen.field_22790 - screenAccessor.getImageHeight() > 2 * SlotRenderStyle.LONE.getHeight()) {
            return 88 - SlotRenderStyle.LONE.getWidth();
        }
        return 88;
    }

    public int getDefaultSlotY(class_465<?> screen) {
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
        if (screen.field_22790 - screenAccessor.getImageHeight() > 2 * SlotRenderStyle.LONE.getHeight()) {
            return screenAccessor.getImageHeight() / 2;
        }
        return screenAccessor.getImageHeight() / 2 - SlotRenderStyle.LONE.getHeight();
    }

    public List<class_768> getCollisionAreas(class_465<?> screen) {
        if (screen instanceof BackpackScreen) {
            BackpackScreen backpackScreen = (BackpackScreen)screen;
            ArrayList<class_768> collisionAreas = new ArrayList<class_768>();
            AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
            collisionAreas.add(new class_768(screenAccessor.getLeftPos(), screenAccessor.getTopPos(), screenAccessor.getImageWidth(), screenAccessor.getImageHeight() - 88));
            collisionAreas.add(new class_768(screenAccessor.getLeftPos() + backpackScreen.getWidthAdditions(), screenAccessor.getTopPos() + 88, screenAccessor.getImageWidth() - backpackScreen.getWidthAdditions() * 2, screenAccessor.getImageHeight() - 88));
            backpackScreen.method_25396().forEach(child -> {
                if (child instanceof WidgetBase) {
                    WidgetBase widget = (WidgetBase)child;
                    collisionAreas.add(new class_768(widget.getWidgetSizeAndPos()[0], widget.getWidgetSizeAndPos()[1], widget.getWidgetSizeAndPos()[2], widget.getWidgetSizeAndPos()[3]));
                }
            });
            backpackScreen.upgradeSlots.forEach(upgradeSlot -> collisionAreas.add(new class_768(upgradeSlot.getUpgradeSlotSizeAndPos()[0], upgradeSlot.getUpgradeSlotSizeAndPos()[1], upgradeSlot.getUpgradeSlotSizeAndPos()[2], upgradeSlot.getUpgradeSlotSizeAndPos()[3])));
            if (backpackScreen.getWrapper().showToolSlots()) {
                collisionAreas.add(new class_768(backpackScreen.toolSlotsWidget.getAdditionSizeAndPos()[0], backpackScreen.toolSlotsWidget.getAdditionSizeAndPos()[1], backpackScreen.toolSlotsWidget.getAdditionSizeAndPos()[2], backpackScreen.toolSlotsWidget.getAdditionSizeAndPos()[3]));
            }
            return collisionAreas;
        }
        this.enableDefaultCollision();
        return super.getCollisionAreas(screen);
    }

    public List<Snap> getSnaps(class_465<?> screen, SlotRenderStyle renderStyle) {
        ArrayList list = Lists.newArrayList();
        AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
        if (screen instanceof BackpackScreen) {
            BackpackScreen backpackScreen = (BackpackScreen)screen;
            if (backpackScreen.getWidthAdditions() == 0) {
                list.add(new Snap(Snap.Type.HORIZONTAL, 0, screenAccessor.getTopPos()));
                list.add(new Snap(Snap.Type.HORIZONTAL, 0, screenAccessor.getTopPos() + screenAccessor.getImageHeight() - renderStyle.getHeight()));
                list.add(new Snap(Snap.Type.VERTICAL, screenAccessor.getLeftPos(), 0));
                list.add(new Snap(Snap.Type.VERTICAL, screenAccessor.getLeftPos() + screenAccessor.getImageWidth() - renderStyle.getWidth(), 0));
                return list;
            }
            list.add(new Snap(Snap.Type.HORIZONTAL, 0, screenAccessor.getTopPos()));
            list.add(new Snap(Snap.Type.HORIZONTAL, 0, screenAccessor.getTopPos() + screenAccessor.getImageHeight() - renderStyle.getHeight()));
        }
        return list;
    }

    public SlotRenderStyle getSlotRenderStyle(class_465<?> screen, int slotX, int slotY) {
        if (screen instanceof BackpackScreen) {
            int slotRight;
            int slotBottom;
            BackpackScreen storageScreen = (BackpackScreen)screen;
            AbstractContainerScreenAccessor screenAccessor = (AbstractContainerScreenAccessor)screen;
            int leftSnap = storageScreen.getGuiLeft() + storageScreen.getWidthAdditions();
            int rightSnap = leftSnap + 7 + 162 + 7;
            int extensionY = storageScreen.visibleRows * 18 + 25;
            if (slotX + SlotRenderStyle.LONE.getWidth() == screenAccessor.getLeftPos()) {
                slotBottom = slotY + SlotRenderStyle.LONE.getHeight();
                if (slotY == screenAccessor.getTopPos()) {
                    return SlotRenderStyle.ATTACH_LEFT_TOP;
                }
                if (slotY >= screenAccessor.getTopPos() && slotBottom < screenAccessor.getTopPos() + extensionY) {
                    return SlotRenderStyle.ATTACH_LEFT_CENTER;
                }
                if (slotBottom == screenAccessor.getTopPos() + extensionY) {
                    return SlotRenderStyle.ATTACH_LEFT_BOTTOM;
                }
            }
            if (slotX + SlotRenderStyle.LONE.getWidth() == leftSnap) {
                slotBottom = slotY + SlotRenderStyle.LONE.getHeight();
                if (slotY == screenAccessor.getTopPos()) {
                    return SlotRenderStyle.ATTACH_LEFT_TOP;
                }
                if (slotBottom == screenAccessor.getTopPos() + screenAccessor.getImageHeight() || slotBottom == extensionY) {
                    return SlotRenderStyle.ATTACH_LEFT_BOTTOM;
                }
                if (slotY >= screenAccessor.getTopPos() && slotBottom < screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
                    return SlotRenderStyle.ATTACH_LEFT_CENTER;
                }
            }
            if (slotX == rightSnap) {
                slotBottom = slotY + SlotRenderStyle.LONE.getHeight();
                if (slotY == screenAccessor.getTopPos()) {
                    return SlotRenderStyle.ATTACH_RIGHT_TOP;
                }
                if (slotBottom == screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
                    return SlotRenderStyle.ATTACH_RIGHT_BOTTOM;
                }
                if (slotY >= screenAccessor.getTopPos() && slotBottom < screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
                    return SlotRenderStyle.ATTACH_RIGHT_CENTER;
                }
            }
            if (slotY + SlotRenderStyle.LONE.getHeight() == screenAccessor.getTopPos()) {
                slotRight = slotX + SlotRenderStyle.LONE.getWidth();
                if (slotX == screenAccessor.getLeftPos()) {
                    return SlotRenderStyle.ATTACH_TOP_LEFT;
                }
                if (slotRight == screenAccessor.getLeftPos() + screenAccessor.getImageWidth()) {
                    return SlotRenderStyle.ATTACH_TOP_RIGHT;
                }
                if (slotX >= screenAccessor.getLeftPos() && slotRight < screenAccessor.getLeftPos() + screenAccessor.getImageWidth()) {
                    return SlotRenderStyle.ATTACH_TOP_CENTER;
                }
            }
            if (slotY == screenAccessor.getTopPos() + screenAccessor.getImageHeight()) {
                slotRight = slotX + SlotRenderStyle.LONE.getWidth();
                if (slotX == screenAccessor.getLeftPos() + storageScreen.getWidthAdditions()) {
                    return SlotRenderStyle.ATTACH_BOTTOM_LEFT;
                }
                if (slotRight == screenAccessor.getLeftPos() + screenAccessor.getImageWidth() - storageScreen.getWidthAdditions()) {
                    return SlotRenderStyle.ATTACH_BOTTOM_RIGHT;
                }
                if (slotX >= screenAccessor.getLeftPos() && slotRight < screenAccessor.getLeftPos() + screenAccessor.getImageWidth() - storageScreen.getWidthAdditions()) {
                    return SlotRenderStyle.ATTACH_BOTTOM_CENTER;
                }
            }
        }
        return SlotRenderStyle.LONE;
    }

    public String getContainerId(class_465<?> screen) {
        if (screen instanceof BackpackScreen) {
            BackpackScreen backpackScreen = (BackpackScreen)screen;
            return "travelersbackpack_" + backpackScreen.getWrapper().getStorageSize();
        }
        return super.getContainerId(screen);
    }
}

