/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10314;
import net.minecraft.class_10591;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9697;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;

public class BackpackUpgradeRecipe
implements class_8059 {
    final Optional<class_1856> template;
    final class_1856 base;
    final Optional<class_1856> addition;
    final class_10591 result;
    @Nullable
    private class_9887 placementInfo;

    public BackpackUpgradeRecipe(Optional<class_1856> pTemplate, class_1856 pBase, Optional<class_1856> pAddition, class_10591 pResult) {
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public class_1799 assemble(class_9697 pInput, class_7225.class_7874 pRegistries) {
        class_1799 result = this.result.method_66340(pInput.comp_2678());
        result.method_57366(this.result.comp_3485());
        class_1799 base = pInput.method_59984(1);
        class_1799 addition = pInput.method_59984(2);
        int tier = (Integer)base.method_58695(ModDataComponents.TIER, (Object)0);
        if (addition.method_31574(Tiers.of(tier).getTierUpgradeIngredient())) {
            this.upgradeInventory(result, Tiers.of(tier).getNextTier());
            return result;
        }
        return class_1799.field_8037;
    }

    public void upgradeInventory(class_1799 stack, Tiers.Tier nextTier) {
        stack.method_57379(ModDataComponents.TIER, (Object)nextTier.getOrdinal());
        stack.method_57379(ModDataComponents.STORAGE_SLOTS, (Object)nextTier.getStorageSlots());
        stack.method_57379(ModDataComponents.UPGRADE_SLOTS, (Object)nextTier.getUpgradeSlots());
        stack.method_57379(ModDataComponents.TOOL_SLOTS, (Object)nextTier.getToolSlots());
        if (stack.method_57826(ModDataComponents.RENDER_INFO)) {
            stack.method_57379(ModDataComponents.RENDER_INFO, (Object)this.getUpgradedTanksCapacity(stack, nextTier.getStorageSlots()));
        }
    }

    public RenderInfo getUpgradedTanksCapacity(class_1799 stack, int storageSlots) {
        boolean extended = storageSlots > 81;
        int rows = (int)Math.ceil((double)storageSlots / (double)(extended ? 11 : 9)) + (extended ? 2 : 0);
        class_2487 infoTag = ((RenderInfo)stack.method_58694(ModDataComponents.RENDER_INFO)).compoundTag().method_10553();
        RenderInfo newInfo = new RenderInfo(infoTag);
        newInfo.updateCapacity(Tiers.of((Integer)stack.method_58695(ModDataComponents.TIER, (Object)0)).getTankCapacityPerRow() * (long)rows);
        return newInfo;
    }

    public class_1865<BackpackUpgradeRecipe> method_8119() {
        return ModRecipeSerializers.BACKPACK_UPGRADE;
    }

    public class_9887 method_61671() {
        if (this.placementInfo == null) {
            this.placementInfo = class_9887.method_61683(List.of(this.template, Optional.of(this.base), this.addition));
        }
        return this.placementInfo;
    }

    public Optional<class_1856> method_64722() {
        return this.template;
    }

    public class_1856 method_64723() {
        return this.base;
    }

    public Optional<class_1856> method_64724() {
        return this.addition;
    }

    public List<class_10295> method_64664() {
        return List.of(new class_10314(class_1856.method_64980(this.template), this.base.method_64673(), class_1856.method_64980(this.addition), this.result.method_66338(), (class_10302)new class_10302.class_10306(class_1802.field_16308)));
    }

    public static class Serializer
    implements class_1865<BackpackUpgradeRecipe> {
        private static final MapCodec<BackpackUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340782_ -> p_340782_.group((App)class_1856.field_46095.optionalFieldOf("template").forGetter(p_301310_ -> p_301310_.template), (App)class_1856.field_46095.fieldOf("base").forGetter(p_300938_ -> p_300938_.base), (App)class_1856.field_46095.optionalFieldOf("addition").forGetter(p_301153_ -> p_301153_.addition), (App)class_10591.field_55714.fieldOf("result").forGetter(p_300935_ -> p_300935_.result)).apply((Applicative)p_340782_, BackpackUpgradeRecipe::new));
        public static final class_9139<class_9129, BackpackUpgradeRecipe> STREAM_CODEC = class_9139.method_56905((class_9139)class_1856.field_52595, smithingTransformRecipe -> smithingTransformRecipe.template, (class_9139)class_1856.field_48355, smithingTransformRecipe -> smithingTransformRecipe.base, (class_9139)class_1856.field_52595, smithingTransformRecipe -> smithingTransformRecipe.addition, (class_9139)class_10591.field_55715, smithingTransformRecipe -> smithingTransformRecipe.result, BackpackUpgradeRecipe::new);

        public MapCodec<BackpackUpgradeRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, BackpackUpgradeRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

