/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.netherportalfix.ReturnPortal;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1946;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ReturnPortalManager {
    private static final int MAX_PORTAL_DISTANCE_SQ = 16;
    private static final String RETURN_PORTAL_LIST = "ReturnPortalList";
    private static final String RETURN_PORTAL_UID = "UID";
    private static final String FROM_DIM = "FromDim";
    private static final String FROM_POS = "FromPos";
    private static final String TO_POS = "ToPos";

    public static class_2338 findPortalAt(class_1657 player, class_5321<class_1937> dim, class_2338 pos) {
        class_3218 fromWorld;
        MinecraftServer server = player.method_73183().method_8503();
        if (server != null && (fromWorld = server.method_3847(dim)) != null) {
            class_1946 portalForcer = fromWorld.method_14173();
            return portalForcer.method_30483(pos, false, fromWorld.method_8621()).orElse(null);
        }
        return null;
    }

    public static class_2499 getPlayerPortalList(class_1297 entity) {
        class_2487 data = Balm.getHooks().getPersistentData(entity);
        class_2499 list = data.method_68569(RETURN_PORTAL_LIST);
        data.method_10566(RETURN_PORTAL_LIST, (class_2520)list);
        return list;
    }

    @Nullable
    public static ReturnPortal findReturnPortal(class_1297 entity, class_5321<class_1937> fromDim, class_2338 fromPos) {
        class_2499 portalList = ReturnPortalManager.getPlayerPortalList(entity);
        for (class_2520 entry : portalList) {
            class_2338 portalTrigger;
            class_2487 portal = (class_2487)entry;
            class_5321 entryFromDim = portal.method_10558(FROM_DIM).map(class_2960::method_60654).map(it -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)it)).orElse(null);
            if (entryFromDim != fromDim || (portalTrigger = (class_2338)portal.method_10537(FROM_POS).map(class_2338::method_10092).orElse(null)) == null || !(portalTrigger.method_10262((class_2382)fromPos) <= 16.0)) continue;
            UUID uid = portal.method_67491(RETURN_PORTAL_UID, class_4844.field_25122).orElseGet(UUID::randomUUID);
            class_2338 pos = portal.method_10537(TO_POS).map(class_2338::method_10092).orElse(null);
            if (pos == null) continue;
            return new ReturnPortal(uid, pos);
        }
        return null;
    }

    public static void storeReturnPortal(class_3222 player, class_5321<class_1937> fromDim, class_2338 fromPos, class_2338 toPos) {
        class_2499 portalList = ReturnPortalManager.getPlayerPortalList((class_1297)player);
        ReturnPortal returnPortal = ReturnPortalManager.findReturnPortal((class_1297)player, fromDim, fromPos);
        if (returnPortal != null) {
            ReturnPortalManager.removeReturnPortal(player, returnPortal);
        }
        class_2487 portalCompound = new class_2487();
        portalCompound.method_67494(RETURN_PORTAL_UID, class_4844.field_25122, (Object)UUID.randomUUID());
        portalCompound.method_10582(FROM_DIM, String.valueOf(fromDim.method_29177()));
        portalCompound.method_10544(FROM_POS, fromPos.method_10063());
        portalCompound.method_10544(TO_POS, toPos.method_10063());
        portalList.add((Object)portalCompound);
    }

    public static void removeReturnPortal(class_3222 player, ReturnPortal portal) {
        class_2499 portalList = ReturnPortalManager.getPlayerPortalList((class_1297)player);
        for (int i = 0; i < portalList.size(); ++i) {
            class_2487 entry = (class_2487)portalList.method_10534(i);
            if (!entry.method_67491(RETURN_PORTAL_UID, class_4844.field_25122).map(it -> it.equals(portal.getUid())).orElse(false).booleanValue()) continue;
            portalList.method_10536(i);
            break;
        }
    }
}

