/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import win.demistorm.stormiespiders.Constants;

public final class NonClimbableBlocksConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_FILE = Path.of("config/stormiespiders/non-climbable-blocks.json", new String[0]);
    private static volatile Set<String> nonClimbablePatterns = ConcurrentHashMap.newKeySet();
    private static volatile Set<class_2960> exactMatchCache = ConcurrentHashMap.newKeySet();

    public static void init() {
        NonClimbableBlocksConfig.loadNonClimbableBlocks();
    }

    public static boolean isBlockNonClimbable(class_2680 state) {
        if (nonClimbablePatterns.isEmpty()) {
            return false;
        }
        class_2960 blockKey = class_7923.field_41175.method_10221((Object)state.method_26204());
        String blockId = blockKey.toString();
        if (exactMatchCache.contains(blockKey)) {
            return true;
        }
        for (String pattern : nonClimbablePatterns) {
            if (!NonClimbableBlocksConfig.matchesPattern(blockId, pattern)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesPattern(String blockId, String pattern) {
        if (!pattern.contains("*")) {
            return blockId.equals(pattern);
        }
        if (pattern.startsWith("*") && pattern.endsWith("*")) {
            String search = pattern.substring(1, pattern.length() - 1);
            return blockId.contains(search);
        }
        if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1);
            return blockId.endsWith(suffix);
        }
        if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            return blockId.startsWith(prefix);
        }
        return blockId.equals(pattern);
    }

    public static List<String> getNonClimbableBlocksList() {
        return new ArrayList<String>(nonClimbablePatterns);
    }

    public static void setNonClimbableBlocksList(List<String> patterns) {
        ConcurrentHashMap.KeySetView<String, Boolean> newPatterns = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView<class_2960, Boolean> newCache = ConcurrentHashMap.newKeySet();
        for (String pattern : patterns) {
            String trimmed = pattern.trim();
            if (trimmed.isEmpty()) continue;
            if (!trimmed.contains("*")) {
                try {
                    class_2960 key = class_2960.method_60654((String)trimmed);
                    if (class_7923.field_41175.method_10250(key)) {
                        newPatterns.add(trimmed);
                        newCache.add(key);
                        continue;
                    }
                    Constants.LOG.warn("[NonClimbableBlocksConfig] Unknown block in config: {}", (Object)trimmed);
                }
                catch (Exception e) {
                    Constants.LOG.warn("[NonClimbableBlocksConfig] Invalid block ID in config: {}", (Object)trimmed, (Object)e);
                }
                continue;
            }
            newPatterns.add(trimmed);
        }
        nonClimbablePatterns = newPatterns;
        exactMatchCache = newCache;
        NonClimbableBlocksConfigData config = new NonClimbableBlocksConfigData();
        config.non_climbable_blocks = new ArrayList<String>(patterns);
        NonClimbableBlocksConfig.writeConfig(config);
        Constants.LOG.info("[NonClimbableBlocksConfig] Updated {} non-climbable block patterns in config", (Object)newPatterns.size());
    }

    private static void loadNonClimbableBlocks() {
        NonClimbableBlocksConfigData config = NonClimbableBlocksConfig.readConfig();
        ConcurrentHashMap.KeySetView<String, Boolean> patterns = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView<class_2960, Boolean> cache = ConcurrentHashMap.newKeySet();
        for (String pattern : config.non_climbable_blocks) {
            String trimmed = pattern.trim();
            if (trimmed.isEmpty()) continue;
            if (!trimmed.contains("*")) {
                try {
                    class_2960 key = class_2960.method_60654((String)trimmed);
                    if (class_7923.field_41175.method_10250(key)) {
                        patterns.add(trimmed);
                        cache.add(key);
                        continue;
                    }
                    Constants.LOG.warn("[NonClimbableBlocksConfig] Unknown block in config: {}", (Object)trimmed);
                }
                catch (Exception e) {
                    Constants.LOG.warn("[NonClimbableBlocksConfig] Invalid block ID in config: {}", (Object)trimmed, (Object)e);
                }
                continue;
            }
            patterns.add(trimmed);
        }
        nonClimbablePatterns = patterns;
        exactMatchCache = cache;
        Constants.LOG.info("[NonClimbableBlocksConfig] Loaded {} non-climbable block patterns from config", (Object)patterns.size());
    }

    private static NonClimbableBlocksConfigData readConfig() {
        try {
            if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
                String json = Files.readString(CONFIG_FILE);
                return (NonClimbableBlocksConfigData)GSON.fromJson(json, NonClimbableBlocksConfigData.class);
            }
        }
        catch (IOException e) {
            Constants.LOG.error("[NonClimbableBlocksConfig] Failed to read config file", (Throwable)e);
        }
        NonClimbableBlocksConfigData config = new NonClimbableBlocksConfigData();
        NonClimbableBlocksConfig.writeConfig(config);
        return config;
    }

    private static void writeConfig(NonClimbableBlocksConfigData config) {
        try {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)config);
            Files.writeString(CONFIG_FILE, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            Constants.LOG.error("[NonClimbableBlocksConfig] Failed to write config file", (Throwable)e);
        }
    }

    public static void reloadConfig() {
        NonClimbableBlocksConfig.loadNonClimbableBlocks();
    }

    private NonClimbableBlocksConfig() {
    }

    private static class NonClimbableBlocksConfigData {
        public List<String> non_climbable_blocks = List.of("*trapdoor");

        private NonClimbableBlocksConfigData() {
        }
    }
}

