/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import win.demistorm.stormiespiders.Constants;

public final class ModConfig {
    private static final Path CONFIG_FILE = Paths.get("config", "stormiespiders", "stormiespiders.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean preventClimbingInRain = false;
    private static boolean disableDataSync = false;
    private static boolean canCrawlOnCeiling = true;
    private static boolean enableFallbackRotation = true;
    private static int fallbackUpdateInterval = 1;

    public static void load() {
        try {
            if (Files.notExists(CONFIG_FILE.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            }
            if (Files.notExists(CONFIG_FILE, new LinkOption[0])) {
                ModConfig.save();
                return;
            }
            String content = Files.readString(CONFIG_FILE).trim();
            if (content.isEmpty()) {
                ModConfig.save();
                return;
            }
            ConfigData data = (ConfigData)GSON.fromJson(content, ConfigData.class);
            if (data != null && data.general != null) {
                preventClimbingInRain = data.general.prevent_climbing_in_rain;
                disableDataSync = data.general.disable_data_sync;
                canCrawlOnCeiling = data.general.can_crawl_on_ceiling;
                enableFallbackRotation = data.general.enable_fallback_rotation;
                fallbackUpdateInterval = data.general.fallback_update_interval;
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to load config, using defaults", (Throwable)e);
            preventClimbingInRain = false;
            disableDataSync = false;
            canCrawlOnCeiling = true;
            enableFallbackRotation = true;
            fallbackUpdateInterval = 1;
        }
    }

    public static void save() {
        try {
            if (Files.notExists(CONFIG_FILE.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            }
            ConfigData data = new ConfigData();
            data.general.prevent_climbing_in_rain = preventClimbingInRain;
            data.general.disable_data_sync = disableDataSync;
            data.general.can_crawl_on_ceiling = canCrawlOnCeiling;
            data.general.enable_fallback_rotation = enableFallbackRotation;
            data.general.fallback_update_interval = fallbackUpdateInterval;
            Files.writeString(CONFIG_FILE, (CharSequence)GSON.toJson((Object)data), new OpenOption[0]);
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to save config", (Throwable)e);
        }
    }

    public static final class ConfigData {
        public GeneralSection general = new GeneralSection();

        public static final class GeneralSection {
            public boolean prevent_climbing_in_rain = false;
            public boolean disable_data_sync = false;
            public boolean can_crawl_on_ceiling = true;
            public boolean enable_fallback_rotation = true;
            public int fallback_update_interval = 1;
        }
    }

    public static final class Data {
        public static boolean preventClimbingInRain() {
            return preventClimbingInRain;
        }

        public static void setPreventClimbingInRain(boolean value) {
            preventClimbingInRain = value;
            ModConfig.save();
        }

        public static boolean disableDataSync() {
            return disableDataSync;
        }

        public static boolean canCrawlOnCeiling() {
            return canCrawlOnCeiling;
        }

        public static void setCanCrawlOnCeiling(boolean value) {
            canCrawlOnCeiling = value;
            ModConfig.save();
        }

        public static boolean enableFallbackRotation() {
            return enableFallbackRotation;
        }

        public static int fallbackUpdateInterval() {
            return fallbackUpdateInterval;
        }
    }
}

