/*
 * Decompiled with CFR 0.152.
 */
package win.demistorm.stormiespiders.client.config;

import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import win.demistorm.stormiespiders.config.NonClimbableBlocksConfig;

public class NonClimbableBlocksScreen
extends class_437 {
    private final class_437 parent;
    private final class_310 client = class_310.method_1551();
    private class_342 blockIdInput;
    private BlockListWidget blockList;
    private int listTopY;
    private List<String> nonClimbableBlocks;

    protected NonClimbableBlocksScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Configure Disabled Climbing Blocks"));
        this.parent = parent;
        this.nonClimbableBlocks = NonClimbableBlocksConfig.getNonClimbableBlocksList();
    }

    protected void method_25426() {
        int topY = 40;
        int listTopY = topY + 80;
        int bottomMargin = 70;
        this.blockIdInput = new class_342(this.field_22793, 20, topY, 180, 18, (class_2561)class_2561.method_43470((String)"Block ID"));
        this.blockIdInput.method_47404((class_2561)class_2561.method_43470((String)"*trapdoor"));
        this.blockIdInput.method_1880(100);
        this.method_37063((class_364)this.blockIdInput);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), btn -> this.addBlockId()).method_46434(205, topY, 40, 18).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"?"), btn -> {}).method_46434(250, topY, 18, 18).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Wildcard Syntax:\n  *trapdoor - Anything ending with 'trapdoor'\n  *door* - Anything with 'door'\n  minecraft:* - All minecraft blocks\n  Exact: minecraft:oak_trapdoor"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear All"), btn -> {
            this.nonClimbableBlocks.clear();
            this.blockList.updateEntries();
            NonClimbableBlocksConfig.setNonClimbableBlocksList(this.nonClimbableBlocks);
        }).method_46434(this.field_22789 - 180, topY, 160, 18).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Remove all blocks from the list"))).method_46431());
        int listBottom = this.field_22790 - bottomMargin;
        this.blockList = new BlockListWidget(this.client, this.field_22789, this.field_22790, listTopY, listBottom);
        this.blockList.updateEntries();
        this.method_25429((class_364)this.blockList);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), btn -> this.client.method_1507(this.parent)).method_46434(this.field_22789 / 2 - 50, this.field_22790 - 50, 100, 20).method_46431());
    }

    private void addBlockId() {
        String text = this.blockIdInput.method_1882().trim();
        if (!text.isEmpty() && !this.nonClimbableBlocks.contains(text)) {
            this.nonClimbableBlocks.add(text);
            this.blockIdInput.method_1852("");
            this.blockList.updateEntries();
            NonClimbableBlocksConfig.setNonClimbableBlocksList(this.nonClimbableBlocks);
        }
    }

    private void removeBlockId(String blockId) {
        this.nonClimbableBlocks.remove(blockId);
        this.blockList.updateEntries();
        NonClimbableBlocksConfig.setNonClimbableBlocksList(this.nonClimbableBlocks);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.blockList != null) {
            this.blockList.method_25394(context, mouseX, mouseY, delta);
        }
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        context.method_25303(this.field_22793, "Add Block ID or Wildcard:", 20, 28, 0xFFFFFF);
        context.method_25303(this.field_22793, "Non-Climbable Blocks:", 20, this.listTopY - 10, 0xFFFFFF);
        context.method_25303(this.field_22793, "(" + this.nonClimbableBlocks.size() + " entries)", 160, this.listTopY - 10, 0xAAAAAA);
        String instructions = "Wildcards: *trapdoor matches all trapdoors, *door* matches anything with 'door'";
        context.method_25300(this.field_22793, instructions, this.field_22789 / 2, this.field_22790 - 75, 0x808080);
    }

    public boolean method_25404(class_11908 event) {
        if (this.blockIdInput.method_25370() && (event.comp_4795() == 257 || event.comp_4795() == 335)) {
            this.addBlockId();
            return true;
        }
        return super.method_25404(event);
    }

    private class BlockListWidget
    extends class_4280<BlockEntry> {
        public BlockListWidget(class_310 client, int width, int height, int y, int bottom) {
            super(client, width, bottom - y, y, 20);
        }

        public void updateEntries() {
            this.method_25339();
            for (int i = 0; i < NonClimbableBlocksScreen.this.nonClimbableBlocks.size(); i += 2) {
                String leftBlock = NonClimbableBlocksScreen.this.nonClimbableBlocks.get(i);
                String rightBlock = i + 1 < NonClimbableBlocksScreen.this.nonClimbableBlocks.size() ? NonClimbableBlocksScreen.this.nonClimbableBlocks.get(i + 1) : null;
                this.method_25321((class_350.class_351)new BlockEntry(leftBlock, rightBlock));
            }
        }

        public int method_25322() {
            return this.field_22758 - 60;
        }

        public class BlockEntry
        extends class_4280.class_4281<BlockEntry> {
            private final String leftBlock;
            private final String rightBlock;
            private final class_4185 leftRemoveButton;
            private final class_4185 rightRemoveButton;

            public BlockEntry(String leftBlock, String rightBlock) {
                this.leftBlock = leftBlock;
                this.rightBlock = rightBlock;
                this.leftRemoveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00d7"), btn -> NonClimbableBlocksScreen.this.removeBlockId(leftBlock)).method_46434(0, 0, 16, 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)("Remove " + leftBlock)))).method_46431();
                this.rightRemoveButton = rightBlock != null ? class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u00d7"), btn -> NonClimbableBlocksScreen.this.removeBlockId(rightBlock)).method_46434(0, 0, 16, 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)("Remove " + rightBlock)))).method_46431() : null;
            }

            public void method_25343(class_332 context, int mouseX, int mouseY, boolean isHovering, float delta) {
                int x = this.method_46426();
                int y = this.method_46427();
                int width = this.method_25368();
                int height = this.method_25364();
                int columnWidth = width / 2;
                this.leftRemoveButton.method_48229(x + columnWidth - 20, y + 6);
                this.leftRemoveButton.method_25394(context, mouseX, mouseY, delta);
                context.method_27535(NonClimbableBlocksScreen.this.field_22793, (class_2561)class_2561.method_43470((String)this.leftBlock).method_27694(style -> style.method_30938(Boolean.valueOf(true))), x + 5, y + 9, -1);
                if (this.rightBlock != null) {
                    this.rightRemoveButton.method_48229(x + width - 20, y + 6);
                    this.rightRemoveButton.method_25394(context, mouseX, mouseY, delta);
                    context.method_27535(NonClimbableBlocksScreen.this.field_22793, (class_2561)class_2561.method_43470((String)this.rightBlock).method_27694(style -> style.method_30938(Boolean.valueOf(true))), x + columnWidth + 5, y + 9, -1);
                }
            }

            public boolean method_25402(class_11909 event, boolean isDoubleClick) {
                if (this.leftRemoveButton.method_25402(event, isDoubleClick)) {
                    return true;
                }
                return this.rightRemoveButton != null && this.rightRemoveButton.method_25402(event, isDoubleClick);
            }

            public class_2561 method_37006() {
                return class_2561.method_43470((String)(this.leftBlock + (String)(this.rightBlock != null ? " and " + this.rightBlock : "")));
            }
        }
    }
}

