/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective_common_neoforge.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.natamus.collective_common_neoforge.data.Constants;
import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.globalcallbacks.JSONCallback;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class GenerateJSONFiles {
    private static final List<String> requestedJsonFiles = new ArrayList<String>();

    public static void requestJSONFile(String modid, List<String> fileNames) {
        for (String fileName : fileNames) {
            GenerateJSONFiles.requestJSONFile(modid, fileName);
        }
    }

    public static void requestJSONFile(String modid, String fileName) {
        if (!requestedJsonFiles.contains(fileName)) {
            requestedJsonFiles.add(fileName);
        }
        Constants.LOG.info("[Collective] JSON file '{}' generation requested by mod '{}'.", (Object)fileName, (Object)modid);
    }

    public static void initGeneration(ServerLevel serverLevel) {
        GenerateJSONFiles.initGeneration(serverLevel.getServer());
    }

    public static void initGeneration(MinecraftServer minecraftServer) {
        if (requestedJsonFiles.isEmpty()) {
            return;
        }
        String dirpath = DataFunctions.getConfigDirectory() + File.separator + "collective";
        File dir = new File(dirpath);
        if (!dir.isDirectory()) {
            boolean bl = dir.mkdirs();
        }
        for (String fileName : requestedJsonFiles) {
            boolean isCreated = false;
            JsonElement jsonElement = null;
            File file = new File(dirpath + File.separator + fileName);
            if (!file.isFile()) {
                InputStream inputStream = DataFunctions.getDataInputStream(minecraftServer, "collective", "json", fileName);
                if (inputStream != null) {
                    jsonElement = JsonParser.parseReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    PrintWriter writer = null;
                    try {
                        writer = new PrintWriter(dirpath + File.separator + fileName, StandardCharsets.UTF_8);
                        writer.print(Constants.GSON.toJson(jsonElement));
                    }
                    catch (IOException ex) {
                        Constants.LOG.warn("[Collective] Unable to write the JSON file: {}", (Object)fileName);
                    }
                    if (writer != null) {
                        writer.close();
                    }
                } else {
                    Constants.LOG.warn("[Collective] Unable to get Input Stream for: {}", (Object)fileName);
                }
            }
            JSONCallback.JSON_FILE_AVAILABLE.invoker().onJsonFileAvailable(dirpath, fileName, isCreated, jsonElement);
        }
        JSONCallback.ALL_JSON_FILES_AVAILABLE.invoker().onAllJsonFilesAvailable(dirpath);
    }
}

