/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.utils;

public class GaussianBlur {
    public static double[][] gaussianBlur(double[][] input, boolean[][] mask, int radius, double sigma) {
        double w;
        int k;
        double weightSum;
        double sum;
        int x;
        int y;
        int height = input.length;
        int width = input[0].length;
        double[][] output = new double[height][width];
        double[] kernel = GaussianBlur.kernel(radius, sigma);
        double[][] temp = new double[height][width];
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (mask != null && mask[y][x]) {
                    temp[y][x] = input[y][x];
                    continue;
                }
                sum = 0.0;
                weightSum = 0.0;
                for (k = -radius; k <= radius; ++k) {
                    int nx = x + k;
                    if (nx < 0 || nx >= width) continue;
                    w = kernel[Math.abs(k)];
                    sum += input[y][nx] * w;
                    weightSum += w;
                }
                temp[y][x] = weightSum > 0.0 ? sum / weightSum : input[y][x];
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                if (mask != null && mask[y][x]) {
                    output[y][x] = temp[y][x];
                    continue;
                }
                sum = 0.0;
                weightSum = 0.0;
                for (k = -radius; k <= radius; ++k) {
                    int ny = y + k;
                    if (ny < 0 || ny >= height) continue;
                    w = kernel[Math.abs(k)];
                    sum += temp[ny][x] * w;
                    weightSum += w;
                }
                output[y][x] = weightSum > 0.0 ? sum / weightSum : temp[y][x];
            }
        }
        return output;
    }

    private static double[] kernel(int radius, double sigma) {
        int i;
        double[] kernel = new double[radius + 1];
        double sum = 0.0;
        double sigma2 = 2.0 * sigma * sigma;
        for (i = 0; i <= radius; ++i) {
            double value;
            kernel[i] = value = Math.exp((double)(-(i * i)) / sigma2);
            sum += i == 0 ? value : 2.0 * value;
        }
        i = 0;
        while (i <= radius) {
            int n = i++;
            kernel[n] = kernel[n] / sum;
        }
        return kernel;
    }
}

