/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.LandmarksMod;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.features.Palette;
import io.github.orlouge.landmarks.features.Parameter;
import io.github.orlouge.landmarks.features.VariantContext;
import io.github.orlouge.landmarks.generation.BlockTemplate;
import io.github.orlouge.landmarks.utils.RandomProperty;
import io.github.orlouge.landmarks.utils.RandomWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6910;
import net.minecraft.class_7924;

public record ProcessingStep(Parameter.Sampler mask, Map<String, Parameter.Sampler> localParameters, boolean xAscending, boolean yAscending, boolean zAscending, List<Rule> rules) {
    public void process(class_5281 world, class_5819 random, VariantContext context) {
        if (this.rules.isEmpty()) {
            return;
        }
        VariantContext localContext = context.withParameters(this.localParameters);
        Optional<BoundedFunction> maskBounds = this.mask.bounds();
        int minX = localContext.minPos().method_10263();
        int minY = localContext.minPos().method_10264();
        int minZ = localContext.minPos().method_10260();
        int maxX = localContext.maxPos().method_10263();
        int maxY = localContext.maxPos().method_10264();
        int maxZ = localContext.maxPos().method_10260();
        if (maskBounds.isPresent()) {
            minZ = Math.max(minZ, maskBounds.get().minZ());
            maxZ = Math.min(maxZ, maskBounds.get().maxZ());
            minX = Math.max(minX, maskBounds.get().minX());
            maxX = Math.min(maxX, maskBounds.get().maxX());
            minY = Math.max(minY, maskBounds.get().minY());
            maxY = Math.min(maxY, maskBounds.get().maxY());
        }
        for (int _z = 0; _z <= maxZ - minZ; ++_z) {
            for (int _x = 0; _x <= maxX - minX; ++_x) {
                for (int _y = 0; _y <= maxY - minY; ++_y) {
                    int x = this.xAscending ? minX + _x : maxX - _x;
                    int y = this.yAscending ? minY + _y : maxY - _y;
                    int z = this.zAscending ? minZ + _z : maxZ - _z;
                    if (this.mask.sample((class_6910.class_6912)new class_6910.class_6914(x, y, z)) <= 0.0) continue;
                    class_2338 pos = new class_2338(x, y, z);
                    class_6910.class_6914 noisePos = new class_6910.class_6914(x, y, z);
                    HashMap copiedEntries = new HashMap();
                    BiFunction<String, Boolean, BlockTemplate> palette = (entry, strict) -> (BlockTemplate)localContext.palette().get((String)entry, (boolean)strict).map(actualTemplate -> actualTemplate, resolved -> copiedEntries.computeIfAbsent(entry, entry2 -> ProcessingStep.copyBlock(world, resolved, noisePos)));
                    for (Rule rule : this.rules) {
                        if (rule.process(pos, world.method_8320(pos), palette, world, random, localContext)) break;
                    }
                }
            }
        }
    }

    private static BlockTemplate copyBlock(class_5281 world, Palette.ResolvedCopiedEntry resolved, class_6910.class_6914 noisePos) {
        int x = (int)resolved.x().sample((class_6910.class_6912)noisePos);
        int y = (int)resolved.y().sample((class_6910.class_6912)noisePos);
        int z = (int)resolved.z().sample((class_6910.class_6912)noisePos);
        class_2680 state = world.method_8320(new class_2338(x, y, z));
        if (!resolved.canCopy().method_40241(state.method_41520())) {
            return BlockTemplate.empty();
        }
        if (resolved.resetState()) {
            state = state.method_26204().method_9564();
        }
        return BlockTemplate.block(state);
    }

    public record Rule(Either<BlockTemplate, Palette.ResolvedCopiedEntry> template, boolean postProcessing, boolean autoWaterlog, boolean passThroughIfNotReplaced, boolean impossible, Optional<class_6885<class_2248>> blockBelow, Optional<class_6885<class_2248>> blockBeingReplaced, Optional<class_6885<class_2248>> blockAbove, Either<class_6862<class_2248>, class_6885<class_2248>> cantReplace, List<Parameter.Condition> densityConditions) {
        public static Rule sampleAll(RandomizedRule rule, class_5819 random, VariantContext context) throws RandomProperty.NoRandomMatchException {
            Optional<class_6885<class_2248>> blockBelow = Optional.empty();
            Optional<class_6885<class_2248>> blockBeingReplaced = Optional.empty();
            Optional<class_6885<class_2248>> blockAbove = Optional.empty();
            ArrayList<Parameter.Condition> conditions = new ArrayList<Parameter.Condition>();
            if (rule.blockBelow.isPresent()) {
                blockBelow = Optional.of(rule.blockBelow.get().sample(random, context));
            }
            if (rule.blockBeingReplaced.isPresent()) {
                blockBeingReplaced = Optional.of(rule.blockBeingReplaced.get().sample(random, context));
            }
            if (rule.blockAbove.isPresent()) {
                blockAbove = Optional.of(rule.blockAbove.get().sample(random, context));
            }
            Either cantReplace = rule.cantReplace.left().isPresent() ? Either.left((Object)((class_6862)rule.cantReplace.left().get())) : Either.right((Object)((class_6885)((RandomProperty)rule.cantReplace().right().get()).sample(random, context)));
            for (RandomProperty<String, VariantContext, VariantContext.Predicate> condition : rule.densityConditions.sample(random, context)) {
                conditions.add(Parameter.Condition.parse(condition.sample(random, context), context.userParameters()));
            }
            Either template = null;
            try {
                template = (Either)rule.template.sample(random, context).referenceOrTemplate().map(context.palette()::get, t -> Either.left((Object)t.copy()));
            }
            catch (RandomProperty.NoRandomMatchException noRandomMatchException) {
                // empty catch block
            }
            return new Rule((Either<BlockTemplate, Palette.ResolvedCopiedEntry>)template, rule.postProcessing, rule.autoWaterlog, rule.passThroughIfNotReplaced, rule.impossible, blockBelow, blockBeingReplaced, blockAbove, (Either<class_6862<class_2248>, class_6885<class_2248>>)cantReplace, conditions);
        }

        public boolean process(class_2338 pos, class_2680 currentBlockState, BiFunction<String, Boolean, BlockTemplate> palette, class_5281 world, class_5819 random, VariantContext context) {
            class_2680 blockToPlace;
            if (this.impossible) {
                return false;
            }
            class_6880 currentBlock = currentBlockState.method_41520();
            if (this.blockAbove.isPresent() && !this.blockAbove.get().method_40241(world.method_8320(pos.method_10069(0, 1, 0)).method_41520())) {
                return false;
            }
            if (this.blockBelow.isPresent() && !this.blockBelow.get().method_40241(world.method_8320(pos.method_10069(0, -1, 0)).method_41520())) {
                return false;
            }
            if (this.blockBeingReplaced.isPresent() && !this.blockBeingReplaced.get().method_40241(currentBlock)) {
                return false;
            }
            if (((Boolean)this.cantReplace.map(arg_0 -> ((class_6880)currentBlock).method_40220(arg_0), list -> list.method_40241(currentBlock))).booleanValue()) {
                return false;
            }
            class_6910.class_6914 noisePos = new class_6910.class_6914(pos.method_10263(), pos.method_10264(), pos.method_10260());
            for (Parameter.Condition condition : this.densityConditions) {
                if (condition.test((class_6910.class_6912)noisePos)) continue;
                return false;
            }
            class_2680 class_26802 = blockToPlace = this.template == null ? null : (class_2680)this.template.map(template2 -> template2.getBlockState(world, random, palette), resolved -> ProcessingStep.copyBlock(world, resolved, noisePos).getBlockState(world, random, palette));
            if (blockToPlace != null) {
                if (this.autoWaterlog && currentBlockState.method_26227().method_15767(class_3486.field_15517) && blockToPlace.method_28498((class_2769)class_2741.field_12508)) {
                    blockToPlace = (class_2680)blockToPlace.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                }
                if (!this.postProcessing) {
                    LandmarksMod.DISABLE_POST_PROCESSING_ONCE = true;
                }
                world.method_8652(pos, blockToPlace, 2);
                return true;
            }
            return !this.passThroughIfNotReplaced;
        }

        public record RandomizedRule(RandomProperty<Palette.PalettedBlockTemplate, VariantContext, VariantContext.Predicate> template, boolean postProcessing, boolean autoWaterlog, boolean passThroughIfNotReplaced, boolean impossible, Optional<RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> blockBelow, Optional<RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> blockBeingReplaced, Optional<RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> blockAbove, Either<class_6862<class_2248>, RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> cantReplace, RandomProperty<List<RandomProperty<String, VariantContext, VariantContext.Predicate>>, VariantContext, VariantContext.Predicate> densityConditions) {
            public static final MapCodec<RandomizedRule> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VariantContext.wrappedRandomCodec(Palette.PalettedBlockTemplate.CODEC, "block").optionalFieldOf("place", VariantContext.defaultRandomProperty(new Palette.PalettedBlockTemplate((Either<String, BlockTemplate>)Either.right((Object)BlockTemplate.empty())))).forGetter(RandomizedRule::template), (App)Codec.BOOL.optionalFieldOf("post_processing", (Object)true).forGetter(RandomizedRule::postProcessing), (App)Codec.BOOL.optionalFieldOf("auto_waterlog", (Object)false).forGetter(RandomizedRule::autoWaterlog), (App)Codec.BOOL.optionalFieldOf("pass_through_if_not_replaced", (Object)false).forGetter(RandomizedRule::passThroughIfNotReplaced), (App)Codec.BOOL.optionalFieldOf("impossible", (Object)false).forGetter(RandomizedRule::impossible), (App)VariantContext.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").optionalFieldOf("block_below_is").forGetter(RandomizedRule::blockBelow), (App)VariantContext.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").optionalFieldOf("block_is").forGetter(RandomizedRule::blockBeingReplaced), (App)VariantContext.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").optionalFieldOf("block_above_is").forGetter(RandomizedRule::blockAbove), (App)Codec.either((Codec)class_6862.method_40093((class_5321)class_7924.field_41254), VariantContext.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks")).optionalFieldOf("cant_replace", (Object)Either.left((Object)class_3481.field_33757)).forGetter(RandomizedRule::cantReplace), (App)VariantContext.strictWrappedRandomCodec(VariantContext.strictWrappedRandomCodec(Codec.STRING).listOf(), "conditions").optionalFieldOf("conditions", VariantContext.defaultRandomProperty(List.of())).forGetter(RandomizedRule::densityConditions)).apply((Applicative)instance, RandomizedRule::new));
        }
    }

    public record RandomizedProcessingStep(Optional<Integer> index, RandomProperty<Either<String, Parameter>, VariantContext, VariantContext.Predicate> mask, Map<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>> localParameters, List<RandomProperty<Rule.RandomizedRule, VariantContext, VariantContext.Predicate>> rules, RandomProperty<Boolean, VariantContext, VariantContext.Predicate> xAscending, RandomProperty<Boolean, VariantContext, VariantContext.Predicate> yAscending, RandomProperty<Boolean, VariantContext, VariantContext.Predicate> zAscending) implements RandomWrapper<ProcessingStep, VariantContext>
    {
        public static final MapCodec<RandomizedProcessingStep> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("index").forGetter(RandomizedProcessingStep::index), (App)VariantContext.wrappedRandomCodec(Parameter.CODEC_NAMED, "parameter").optionalFieldOf("mask", VariantContext.defaultRandomProperty(Either.right((Object)new Parameter.Constant(1.0)))).forGetter(RandomizedProcessingStep::mask), (App)Codec.unboundedMap((Codec)Codec.STRING, VariantContext.wrappedRandomCodec(Parameter.CODEC)).optionalFieldOf("parameters", Collections.emptyMap()).forGetter(RandomizedProcessingStep::localParameters), (App)VariantContext.strictWrappedRandomCodec(Rule.RandomizedRule.CODEC.codec(), "rule").listOf().fieldOf("rules").forGetter(RandomizedProcessingStep::rules), (App)VariantContext.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("x_ascending", VariantContext.defaultRandomProperty(true)).forGetter(RandomizedProcessingStep::xAscending), (App)VariantContext.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("y_ascending", VariantContext.defaultRandomProperty(true)).forGetter(RandomizedProcessingStep::yAscending), (App)VariantContext.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("z_ascending", VariantContext.defaultRandomProperty(true)).forGetter(RandomizedProcessingStep::zAscending)).apply((Applicative)instance, RandomizedProcessingStep::new));

        @Override
        public ProcessingStep sample(class_5819 random, VariantContext context) throws RandomProperty.NoRandomMatchException {
            HashMap<String, Parameter.Sampler> localParameters = new HashMap<String, Parameter.Sampler>();
            for (Map.Entry<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>> entry : this.localParameters.entrySet()) {
                localParameters.put(entry.getKey(), entry.getValue().sample(random, context).createSampler(context.getVisitor()));
            }
            VariantContext localContext = context.withParameters(localParameters);
            ArrayList<Rule> rules = new ArrayList<Rule>();
            for (RandomProperty<Rule.RandomizedRule, VariantContext, VariantContext.Predicate> rule : this.rules) {
                try {
                    rules.add(Rule.sampleAll(rule.sample(random, context), random, context));
                }
                catch (RandomProperty.NoRandomMatchException noRandomMatchException) {}
            }
            Either<String, Parameter> mask = this.mask.sample(random, localContext);
            return new ProcessingStep((Parameter.Sampler)mask.map(parRef -> localContext.userParameters().get(parRef), par -> par.createSampler(localContext.getVisitor())), localParameters, this.xAscending.sample(random, context), this.yAscending.sample(random, context), this.zAscending.sample(random, context), rules);
        }
    }
}

