/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import io.github.orlouge.landmarks.utils.MaxDensitySquare;
import net.minecraft.class_5819;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class MaxDensitySquare
implements class_6910,
BoundedFunction,
FunctionWithCache.Simple {
    public static final MapCodec<MaxDensitySquare> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(s -> s.key), (App)class_6910.field_37059.fieldOf("min_x").forGetter(s -> s.x1), (App)class_6910.field_37059.fieldOf("max_x").forGetter(s -> s.x2), (App)class_6910.field_37059.fieldOf("min_y").forGetter(s -> s.y1), (App)class_6910.field_37059.fieldOf("max_y").forGetter(s -> s.y2), (App)class_6910.field_37059.fieldOf("min_z").forGetter(s -> s.z1), (App)class_6910.field_37059.fieldOf("max_z").forGetter(s -> s.z2), (App)class_6910.field_37059.fieldOf("argument").forGetter(s -> s.density), (App)class_6910.field_37059.fieldOf("min_side").forGetter(s -> s.minSide), (App)class_6910.field_37059.fieldOf("max_side").forGetter(s -> s.maxSide)).apply((Applicative)instance, MaxDensitySquare::new));
    public static final class_7243<MaxDensitySquare> CODEC_HOLDER = class_7243.method_42116(CODEC);
    public final String key;
    public final class_6910 x1;
    public final class_6910 x2;
    public final class_6910 y1;
    public final class_6910 y2;
    public final class_6910 z1;
    public final class_6910 z2;
    public final class_6910 density;
    public final class_6910 minSide;
    public final class_6910 maxSide;
    private final Cache cache;

    public MaxDensitySquare(String key, class_6910 x1, class_6910 x2, class_6910 y1, class_6910 y2, class_6910 z1, class_6910 z2, class_6910 density, class_6910 minSide, class_6910 maxSide, Cache cache) {
        this.key = key;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.z1 = z1;
        this.z2 = z2;
        this.density = density;
        this.minSide = minSide;
        this.maxSide = maxSide;
        this.cache = cache;
    }

    public MaxDensitySquare(String key, class_6910 x1, class_6910 x2, class_6910 y1, class_6910 y2, class_6910 z1, class_6910 z2, class_6910 density, class_6910 minSide, class_6910 maxSide) {
        this(key.isEmpty() ? null : key, x1, x2, y1, y2, z1, z2, density, minSide, maxSide, new Cache());
    }

    public double method_40464(class_6910.class_6912 pos) {
        this.compute(pos);
        if (this.cache.invalid) {
            return 0.0;
        }
        return pos.comp_371() >= this.cache.minX && pos.comp_371() <= this.cache.maxX && pos.comp_372() >= this.cache.minY && pos.comp_372() <= this.cache.maxY && pos.comp_373() >= this.cache.minZ && pos.comp_373() <= this.cache.maxZ ? 1.0 : 0.0;
    }

    private void compute(class_6910.class_6912 pos) {
        if (!this.cache.computed) {
            this.cache.computed = true;
            this.cache.minY = -30000000;
            this.cache.maxY = 30000000;
            int _x1 = (int)this.x1.method_40464(pos);
            int _x2 = (int)this.x2.method_40464(pos);
            int _y1 = (int)this.y1.method_40464(pos);
            int _y2 = (int)this.y2.method_40464(pos);
            int _z1 = (int)this.z1.method_40464(pos);
            int _z2 = (int)this.z2.method_40464(pos);
            class_6910 class_69102 = this.density;
            if (class_69102 instanceof BoundedFunction) {
                BoundedFunction maskBounds = (BoundedFunction)class_69102;
                _z1 = Math.max(_z1, maskBounds.minZ());
                _z2 = Math.min(_z2, maskBounds.maxZ());
                _x1 = Math.max(_x1, maskBounds.minX());
                _x2 = Math.min(_x2, maskBounds.maxX());
                _y1 = Math.max(_y1, maskBounds.minY());
                _y2 = Math.min(_y2, maskBounds.maxY());
            }
            int _minSide = (int)this.minSide.method_40464(pos);
            int _maxSide = (int)this.maxSide.method_40464(pos);
            if (_x2 < _x1 || _z2 < _z1 || _y2 < _y1 || _maxSide < _minSide) {
                this.cache.minX = _x2;
                this.cache.maxX = _x2;
                this.cache.minZ = _z2;
                this.cache.maxZ = _z2;
                this.cache.invalid = true;
                return;
            }
            double[][] density = new double[_x2 - _x1 + 1][_z2 - _z1 + 1];
            for (int x = _x1; x <= _x2; ++x) {
                for (int z = _z1; z <= _z2; ++z) {
                    for (int y = _y1; y <= _y2; ++y) {
                        double[] dArray = density[x - _x1];
                        int n = z - _z1;
                        dArray[n] = dArray[n] + this.density.method_40464((class_6910.class_6912)new class_6910.class_6914(x, y, z));
                    }
                }
            }
            MaxDensitySquare.Result square = io.github.orlouge.landmarks.utils.MaxDensitySquare.findDenseSquare(density, 1000, class_5819.method_43049((long)0L), rnd -> rnd.method_39332(_minSide, _maxSide), r -> r.density());
            this.cache.minX = _x1 + square.x();
            this.cache.maxX = this.cache.minX + square.size();
            this.cache.minZ = _z1 + square.y();
            this.cache.maxZ = this.cache.minZ + square.size();
        }
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new MaxDensitySquare(this.key, this.x1.method_40469(visitor), this.x2.method_40469(visitor), this.y1.method_40469(visitor), this.y2.method_40469(visitor), this.z1.method_40469(visitor), this.z2.method_40469(visitor), this.density.method_40469(visitor), this.minSide.method_40469(visitor), this.maxSide.method_40469(visitor), this.cache));
    }

    public double comp_377() {
        return 0.0;
    }

    public double comp_378() {
        return 1.0;
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }

    @Override
    public int minX() {
        return this.cache.minX;
    }

    @Override
    public int maxX() {
        return this.cache.maxX;
    }

    @Override
    public int minY() {
        return this.cache.minY;
    }

    @Override
    public int maxY() {
        return this.cache.maxY;
    }

    @Override
    public int minZ() {
        return this.cache.minZ;
    }

    @Override
    public int maxZ() {
        return this.cache.maxZ;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return new Cache();
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        MaxDensitySquare fun = new MaxDensitySquare(this.key, this.x1, this.x2, this.y1, this.y2, this.z1, this.z2, this.density, this.minSide, this.maxSide, (Cache)cache);
        fun.compute((class_6910.class_6912)new class_6910.class_6914(0, 0, 0));
        return fun;
    }

    private static class Cache {
        public boolean computed = false;
        public boolean invalid = false;
        public int minX;
        public int maxX;
        public int minY;
        public int maxY;
        public int minZ;
        public int maxZ;

        private Cache() {
        }
    }
}

