/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.screen;

import com.supermartijn642.chunkloaders.ChunkLoaders;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import com.supermartijn642.chunkloaders.packet.PacketToggleChunk;
import com.supermartijn642.chunkloaders.screen.ChunkImage;
import com.supermartijn642.chunkloaders.screen.PlayerRenderer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.network.BasePacket;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import org.joml.Matrix4f;

public class ChunkGridCell
extends BaseWidget {
    public static final class_2960 CELL_OVERLAY = class_2960.method_60655((String)"chunkloaders", (String)"gui/cell_overlay");
    public static final class_2960 GRID_OVERLAY = class_2960.method_60655((String)"chunkloaders", (String)"gui/grid_overlay");
    private final class_1923 pos;
    private final UUID player;
    private final BiFunction<Integer, Integer, Boolean> isLoaded;
    private final BiFunction<Integer, Integer, Boolean> isWithinRange;
    private final BiFunction<Integer, Integer, Boolean> isLoadedByOtherPlayer;
    private final ChunkImage image;

    public ChunkGridCell(int x, int y, class_1923 chunk, int loaderYLevel, UUID player, BiFunction<Integer, Integer, Boolean> isLoaded, BiFunction<Integer, Integer, Boolean> isWithinRange, BiFunction<Integer, Integer, Boolean> isLoadedByOtherPlayer) {
        super(x, y, 18, 18);
        this.pos = chunk;
        this.player = player;
        this.isLoaded = isLoaded;
        this.isWithinRange = isWithinRange;
        this.isLoadedByOtherPlayer = isLoadedByOtherPlayer;
        this.image = new ChunkImage(ClientUtils.getWorld(), chunk, loaderYLevel);
    }

    public class_2561 getNarrationMessage() {
        if (this.isLoaded.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.chunk.loaded").get();
        }
        if (this.isWithinRange.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.chunk.available").get();
        }
        if (this.isLoadedByOtherPlayer.apply(0, 0).booleanValue()) {
            return TextComponents.translation((String)"chunkloaders.gui.speech.chunk.others").get();
        }
        return TextComponents.translation((String)"chunkloaders.gui.speech.chunk.not_loaded").get();
    }

    public void renderBackground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        graphics.submitSprite(GRID_OVERLAY, (float)this.x, (float)this.y, (float)this.width, (float)this.height);
        graphics.submitTexture(this.image.getTexture(), (float)(this.x + 1), (float)(this.y + 1), 16.0f, 16.0f);
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        this.drawOutline(graphics, this.isLoadedByOtherPlayer, 40, 40, 40, 196, 196, 196, 97);
        this.drawOutline(graphics, this.isWithinRange, 0, 82, 196, 0, 82, 196, 58);
        this.drawOutline(graphics, this.isLoaded, 0, 99, 11, 0, 99, 11, 116);
    }

    public void renderForeground(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.isFocused() && this.canPlayerToggleChunk()) {
            graphics.submitSprite(CELL_OVERLAY, (float)(this.x - 1), (float)(this.y - 1), (float)(this.width + 2), (float)(this.height + 2));
        }
    }

    private void drawOutline(GuiGraphicsHelper graphics, BiFunction<Integer, Integer, Boolean> shouldConnect, int redBorder, int greenBorder, int blueBorder, int redFiller, int greenFiller, int blueFiller, int alphaFiller) {
        if (!shouldConnect.apply(0, 0).booleanValue()) {
            return;
        }
        graphics.submitRectangle((float)this.x, (float)this.y, (float)this.width, (float)this.height, p -> p.color(redFiller, greenFiller, blueFiller, alphaFiller));
        if (!shouldConnect.apply(0, -1).booleanValue()) {
            graphics.submitRectangle((float)this.x, (float)this.y, (float)this.width, 1.0f, p -> p.color(redBorder, greenBorder, blueBorder, 1));
        }
        if (!shouldConnect.apply(1, 0).booleanValue()) {
            graphics.submitRectangle((float)(this.x + this.width - 1), (float)this.y, 1.0f, (float)this.height, p -> p.color(redBorder, greenBorder, blueBorder, 1));
        }
        if (!shouldConnect.apply(0, 1).booleanValue()) {
            graphics.submitRectangle((float)this.x, (float)(this.y + this.height - 1), (float)this.width, 1.0f, p -> p.color(redBorder, greenBorder, blueBorder, 1));
        }
        if (!shouldConnect.apply(-1, 0).booleanValue()) {
            graphics.submitRectangle((float)this.x, (float)this.y, 1.0f, (float)this.height, p -> p.color(redBorder, greenBorder, blueBorder, 1));
        }
        if (shouldConnect.apply(0, -1).booleanValue() && shouldConnect.apply(-1, 0).booleanValue() && !shouldConnect.apply(-1, -1).booleanValue()) {
            graphics.submitRectangle((float)this.x, (float)this.y, 1.0f, 1.0f, p -> p.color(redBorder, greenBorder, blueBorder, 1));
        }
        if (shouldConnect.apply(0, -1).booleanValue() && shouldConnect.apply(1, 0).booleanValue() && !shouldConnect.apply(1, -1).booleanValue()) {
            graphics.submitRectangle((float)(this.x + this.width - 1), (float)this.y, 1.0f, 1.0f, p -> p.color(redBorder, greenBorder, blueBorder, 1));
        }
        if (shouldConnect.apply(0, 1).booleanValue() && shouldConnect.apply(-1, 0).booleanValue() && !shouldConnect.apply(-1, 1).booleanValue()) {
            graphics.submitRectangle((float)this.x, (float)(this.y + this.height - 1), 1.0f, 1.0f, p -> p.color(redBorder, greenBorder, blueBorder, 1));
        }
        if (shouldConnect.apply(0, 1).booleanValue() && shouldConnect.apply(1, 0).booleanValue() && !shouldConnect.apply(1, 1).booleanValue()) {
            graphics.submitRectangle((float)(this.x + this.width - 1), (float)(this.y + this.height - 1), 1.0f, 1.0f, p -> p.color(redBorder, greenBorder, blueBorder, 1));
        }
    }

    protected void getTooltips(Consumer<class_2561> tooltipConsumer) {
        if (this.isFocused()) {
            ArrayList<class_5250> tooltips = new ArrayList<class_5250>();
            boolean canToggleChunk = this.canPlayerToggleChunk();
            if (canToggleChunk) {
                if (this.isLoaded.apply(0, 0).booleanValue()) {
                    tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.loaded").color(class_124.field_1065).get());
                } else if (this.isWithinRange.apply(0, 0).booleanValue()) {
                    tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.available").color(class_124.field_1065).get());
                }
            }
            ChunkLoadingCapability capability = ChunkLoadingCapability.get(ClientUtils.getWorld());
            capability.getActivePlayersLoadingChunk(this.pos).stream().filter(uuid -> !canToggleChunk || !uuid.equals(this.player)).map(PlayerRenderer::getPlayerUsername).filter(Objects::nonNull).map(name -> TextComponents.string((String)(" " + name)).color(class_124.field_1080).italic().get()).forEach(tooltips::add);
            capability.getInactivePlayersLoadingChunk(this.pos).stream().filter(uuid -> !canToggleChunk || !uuid.equals(this.player)).map(PlayerRenderer::getPlayerUsername).filter(Objects::nonNull).map(name -> TextComponents.string((String)" ").string(name).color(class_124.field_1080).italic().strikethrough().get()).forEach(tooltips::add);
            if (tooltips.size() > (canToggleChunk ? 1 : 0)) {
                tooltips.add(canToggleChunk ? 1 : 0, TextComponents.translation((String)"chunkloaders.gui.chunk.others").color(class_124.field_1068).get());
            }
            if (!ClientUtils.getPlayer().method_5667().equals(this.player) && ClientUtils.getPlayer().method_64475(2) && !class_310.method_1551().method_74187() && (this.isWithinRange.apply(0, 0).booleanValue() || this.isLoaded.apply(0, 0).booleanValue())) {
                class_5250 keyName = TextComponents.translation((String)"key.keyboard.left.shift").color(class_124.field_1065).get();
                tooltips.add(TextComponents.translation((String)"chunkloaders.gui.chunk.overwrite", (Object[])new Object[]{keyName}).color(class_124.field_1068).get());
            }
            tooltips.forEach(tooltipConsumer);
        }
    }

    public void onPress() {
        if (this.canPlayerToggleChunk()) {
            AbstractButtonWidget.playClickSound();
            ChunkLoaders.CHANNEL.sendToServer((BasePacket)new PacketToggleChunk(this.player, this.pos));
        }
    }

    private boolean canPlayerToggleChunk() {
        class_1657 player = ClientUtils.getPlayer();
        return (player.method_5667().equals(this.player) || player.method_64475(2) && class_310.method_1551().method_74187()) && (this.isWithinRange.apply(0, 0) != false || this.isLoaded.apply(0, 0) != false);
    }

    public boolean isLoaded() {
        return this.isLoaded.apply(0, 0);
    }

    public void discard() {
        this.image.dispose();
    }

    public static void drawTexture(class_4587 poseStack, class_4588 buffer, float x, float y, float width, float height) {
        Matrix4f matrix = poseStack.method_23760().method_23761();
        buffer.method_22918(matrix, x, y + height, 0.0f).method_22913(0.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.method_22918(matrix, x + width, y + height, 0.0f).method_22913(1.0f, 1.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.method_22918(matrix, x + width, y, 0.0f).method_22913(1.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.method_22918(matrix, x, y, 0.0f).method_22913(0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

