/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.function.Consumer;

public final class ParsingUtils {
    public static void forEach(Object value, Consumer<Object> consumer) {
        if (value.getClass().getComponentType().isPrimitive()) {
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                consumer.accept(Array.get(value, i));
            }
        } else {
            for (Object o : (Object[])value) {
                consumer.accept(o);
            }
        }
    }

    public static Enum<?> parseEnum(Class<?> clazz, String name) {
        try {
            if (clazz.isEnum()) {
                return Enum.valueOf(clazz, name.toUpperCase(Locale.ROOT));
            }
            if (clazz.getSuperclass().isEnum()) {
                return Enum.valueOf(clazz.getSuperclass(), name.toUpperCase(Locale.ROOT));
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getField(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

