/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.text.multiline;

import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.text.multiline.MultilineStringView;
import com.teamresourceful.resourcefulconfig.client.components.options.text.multiline.MultilineTextInput;
import com.teamresourceful.resourcefulconfig.client.components.options.text.utils.TextBoxStringUtils;
import com.teamresourceful.resourcefulconfig.client.utils.ListenableState;
import com.teamresourceful.resourcefulconfig.client.utils.State;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public class MultilineTextBox
extends BaseWidget {
    private final MultilineTextInput state;
    private static final int WIDTH = 80;
    private class_327 font;
    private double scroll;
    private int lastHeight;
    private boolean scrollbarHovered;

    public MultilineTextBox(State<String> state) {
        super(80, 16);
        ListenableState<String> listenableState;
        this.font = class_310.method_1551().field_1772;
        this.scroll = -1.0;
        this.scrollbarHovered = false;
        if (state instanceof ListenableState) {
            ListenableState it = (ListenableState)state;
            listenableState = it;
        } else {
            listenableState = new ListenableState<String>(state);
        }
        this.state = new MultilineTextInput(listenableState);
    }

    public MultilineTextBox withFont(class_327 font) {
        this.font = font;
        return this;
    }

    protected void renderText(class_332 graphics, int x, int y, int width) {
        int cursor = this.state.cursor();
        MultilineStringView selection = this.state.selection();
        List<MultilineStringView> lines = this.state.lines(this.field_22758 - 8);
        for (MultilineStringView line : lines) {
            String text = this.state.value().substring(line.start(), line.end());
            graphics.method_35720(this.font, TextBoxStringUtils.format(text), x, y, -1);
            if (this.state.hasSelection()) {
                if (line.contains(selection.end()) || line.contains(selection.start())) {
                    int startIndex = Math.max(selection.start() - line.start(), 0);
                    int endIndex = selection.end() - line.start();
                    int startX = TextBoxStringUtils.width(this.font, text.substring(0, startIndex)) + x;
                    int endX = endIndex > text.length() ? x + width : startX + TextBoxStringUtils.width(this.font, text.substring(startIndex, endIndex));
                    Objects.requireNonNull(this.font);
                    graphics.method_25294(startX, y, endX, y + 9, -2136298838);
                } else if (selection.contains(line.start()) && selection.contains(line.end())) {
                    Objects.requireNonNull(this.font);
                    graphics.method_25294(x, y, x + width, y + 9, -2136298838);
                }
            }
            if (line.contains(cursor)) {
                String first = text.substring(0, cursor - line.start());
                int cursorX = TextBoxStringUtils.width(this.font, first) + x;
                Objects.requireNonNull(this.font);
                graphics.method_25294(cursorX, y, cursorX + 1, y + 9, System.currentTimeMillis() % 1000L < 500L ? -1 : 0);
            }
            Objects.requireNonNull(this.font);
            y += 9;
        }
        int n = lines.size();
        Objects.requireNonNull(this.font);
        this.lastHeight = n * 9;
        if (this.scroll == -1.0) {
            this.setScroll(this.lastHeight - (this.field_22759 - 8));
        }
    }

    protected void setScroll(double scroll) {
        this.scroll = class_3532.method_15350((double)scroll, (double)0.0, (double)Math.max(0, this.lastHeight - (this.field_22759 - 8)));
    }

    protected void changeScroll(double delta) {
        this.setScroll(this.scroll + delta);
    }

    @Override
    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (!this.isVisible()) {
            return;
        }
        class_2960 texture = ModSprites.BUTTON;
        graphics.method_52706(class_10799.field_56887, texture, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        boolean renderScrollbar = this.lastHeight > this.field_22759 - 8;
        graphics.method_44379(this.method_46426() + 2, this.method_46427() + 3, this.method_46426() + this.method_25368() - 4, this.method_46427() + this.method_25364() - 2);
        this.renderText(graphics, this.method_46426() + 6 - (renderScrollbar ? 2 : 0), (int)((double)(this.method_46427() + 4) - this.scroll), this.method_25368() - 12);
        graphics.method_44380();
        this.scrollbarHovered = false;
        if (renderScrollbar) {
            int minX = this.method_46426() + this.method_25368() - 5;
            int maxX = this.method_46426() + this.method_25368() - 3;
            graphics.method_25294(minX, this.method_46427() + 4, maxX, this.method_46427() + this.method_25364() - 4, -15592684);
            int scrollBarHeight = (int)((double)(this.field_22759 - 8) / (double)this.lastHeight * (double)(this.field_22759 - 8));
            int scrollBarY = (int)(this.scroll / (double)this.lastHeight * (double)(this.field_22759 - 8));
            this.scrollbarHovered = mouseX >= minX - 2 && mouseX < maxX + 2;
            graphics.method_25294(minX, this.method_46427() + 4 + scrollBarY, maxX, this.method_46427() + 4 + scrollBarY + scrollBarHeight, this.scrollbarHovered ? -12566464 : -13619152);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.isVisible()) {
            return false;
        }
        this.changeScroll(scrollY * -10.0);
        return true;
    }

    public boolean method_25402(@NotNull class_11909 event, boolean doubleClicked) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.lastHeight > this.field_22759 - 8 && event.comp_4798() > (double)(this.method_46426() + this.method_25368() - 7)) {
            this.setScroll((event.comp_4799() - (double)this.method_46427() - 4.0) / (double)(this.field_22759 - 8) * (double)this.lastHeight);
            return true;
        }
        return this.state.onMouseClick(event.comp_4798() - (double)this.method_46426() - 4.0, event.comp_4799() - (double)this.method_46427() - 4.0 + this.scroll, event.method_74228());
    }

    public boolean method_25403(@NotNull class_11909 event, double deltaX, double deltaY) {
        if (!this.isVisible()) {
            return false;
        }
        if (this.lastHeight > this.field_22759 - 8 && event.comp_4798() > (double)(this.method_46426() + this.method_25368() - 7)) {
            return this.method_25402(event, false);
        }
        return this.state.onMouseDrag(event.comp_4798() - (double)this.method_46426() - 4.0, event.comp_4799() - (double)this.method_46427() - 4.0 + this.scroll, event.method_74228());
    }

    public boolean method_25404(@NotNull class_11908 event) {
        if (!this.isVisible()) {
            return false;
        }
        boolean result = this.state.onKeyPress(event);
        int n = this.state.lines(this.field_22758 - 8).size();
        Objects.requireNonNull(this.font);
        this.lastHeight = n * 9;
        int n2 = this.state.getLineAtCursor();
        Objects.requireNonNull(this.font);
        this.setScroll(n2 * 9);
        return result;
    }

    public boolean method_25400(@NotNull class_11905 event) {
        if (!this.isVisible()) {
            return false;
        }
        int n = this.state.getLineAtCursor();
        Objects.requireNonNull(this.font);
        this.setScroll(n * 9);
        return this.state.onCharTyped(event);
    }

    public boolean isVisible() {
        return this.field_22764;
    }
}

