/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options;

import com.teamresourceful.resourcefulconfig.api.annotations.ConfigOption;
import com.teamresourceful.resourcefulconfig.api.client.ResourcefulConfigElementRenderer;
import com.teamresourceful.resourcefulconfig.api.client.ResourcefulConfigUI;
import com.teamresourceful.resourcefulconfig.api.client.options.ResourcefulConfigOptionUI;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigButton;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigElement;
import com.teamresourceful.resourcefulconfig.api.types.elements.ResourcefulConfigEntryElement;
import com.teamresourceful.resourcefulconfig.api.types.elements.ResourcefulConfigSeparatorElement;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigObjectEntry;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryType;
import com.teamresourceful.resourcefulconfig.api.types.options.Option;
import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.CustomButton;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionItem;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionsListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.SeparatorItem;
import com.teamresourceful.resourcefulconfig.client.components.options.range.DecimalOptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.range.OptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.range.WholeOptionRange;
import com.teamresourceful.resourcefulconfig.client.components.options.types.BooleanOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ColorOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.DraggableListOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.KeybindOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.MultilineStringOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.NumberOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ObjectOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.RangeOptionWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.ResetableWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.StringOptionWidget;
import com.teamresourceful.resourcefulconfig.common.utils.ModUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_339;

public final class Options {
    public static void populateOptions(OptionsListWidget widget, List<ResourcefulConfigElement> elements) {
        block6: for (ResourcefulConfigElement element : elements) {
            if (element.isHidden()) continue;
            ResourcefulConfigElementRenderer renderer = ResourcefulConfigUI.getElementRenderer(element);
            if (renderer != null) {
                widget.add(new OptionItem(renderer.title(), renderer.description(), renderer.widgets()));
                continue;
            }
            Objects.requireNonNull(element);
            int n = 0;
            block7: while (true) {
                ResourcefulConfigElement resourcefulConfigElement;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ResourcefulConfigButton.class, ResourcefulConfigEntryElement.class, ResourcefulConfigEntryElement.class, ResourcefulConfigSeparatorElement.class}, (Object)resourcefulConfigElement, n)) {
                    case 0: {
                        ResourcefulConfigButton button = (ResourcefulConfigButton)resourcefulConfigElement;
                        widget.add(new OptionItem((class_2561)class_2561.method_43471((String)button.title()), (class_2561)class_2561.method_43471((String)button.description()), List.of(new CustomButton(96, 12, (class_2561)class_2561.method_43471((String)button.text()), button::invoke))));
                        continue block6;
                    }
                    case 1: {
                        ResourcefulConfigEntryElement entry = (ResourcefulConfigEntryElement)resourcefulConfigElement;
                        ResourcefulConfigEntry resourcefulConfigEntry = entry.entry();
                        if (!(resourcefulConfigEntry instanceof ResourcefulConfigValueEntry)) {
                            n = 2;
                            continue block7;
                        }
                        ResourcefulConfigValueEntry value = (ResourcefulConfigValueEntry)resourcefulConfigEntry;
                        Options.populateValueEntry(widget, value);
                        continue block6;
                    }
                    case 2: {
                        ResourcefulConfigEntryElement entry = (ResourcefulConfigEntryElement)resourcefulConfigElement;
                        ResourcefulConfigEntry resourcefulConfigEntry = entry.entry();
                        if (!(resourcefulConfigEntry instanceof ResourcefulConfigObjectEntry)) {
                            n = 3;
                            continue block7;
                        }
                        ResourcefulConfigObjectEntry object = (ResourcefulConfigObjectEntry)resourcefulConfigEntry;
                        widget.add(new OptionItem(object, List.of(new ObjectOptionWidget(object))));
                        continue block6;
                    }
                    case 3: {
                        ResourcefulConfigSeparatorElement separator = (ResourcefulConfigSeparatorElement)resourcefulConfigElement;
                        widget.add(new SeparatorItem((class_2561)separator.title().toComponent(), (class_2561)separator.description().toComponent()));
                        continue block6;
                    }
                }
                break;
            }
        }
    }

    private static void populateValueEntry(OptionsListWidget list, ResourcefulConfigValueEntry entry) {
        EntryData data = entry.options();
        ArrayList<class_339> widgets = new ArrayList<class_339>();
        switch (entry.type()) {
            case BOOLEAN: {
                widgets.add(new BooleanOptionWidget(entry::getBoolean, entry::setBoolean));
                break;
            }
            case STRING: {
                if (data.hasOption(Option.MULTILINE)) {
                    widgets.add(new MultilineStringOptionWidget(entry::getString, entry::setString));
                    break;
                }
                if (entry.isArray()) {
                    widgets.add(new MultilineStringOptionWidget(() -> String.join((CharSequence)"\n", (String[])entry.getArray()), s -> entry.setArray(s.split("\n"))));
                    break;
                }
                widgets.add(new StringOptionWidget(entry::getString, entry::setString));
                break;
            }
            case ENUM: {
                if (entry.isArray()) {
                    if (data.hasOption(Option.DRAGGABLE)) {
                        widgets.add(DraggableListOptionWidget.of(entry, data));
                        break;
                    }
                    widgets.add(ResourcefulConfigOptionUI.select((class_2561)data.getOrDefaultOption(Option.SELECT, class_2561.method_43470((String)"Select")), List.of(ModUtils.getEnumConstants(entry.objectType())), () -> List.of(entry.getArray()), it -> entry.setArray(it.toArray())));
                    break;
                }
                widgets.add(ResourcefulConfigOptionUI.dropdown((class_2561)class_2561.method_43473(), List.of(ModUtils.getEnumConstants(entry.objectType())), entry::getEnum, entry::setEnum));
                break;
            }
            case INTEGER: {
                Record range = WholeOptionRange.of(entry);
                if (range.hasRange() && data.hasOption(Option.SLIDER)) {
                    widgets.add(new RangeOptionWidget((OptionRange)((Object)range)));
                    break;
                }
                if (data.hasOption(Option.COLOR)) {
                    ConfigOption.Color color = data.getOption(Option.COLOR);
                    widgets.add(new ColorOptionWidget(color.presets(), color.alpha(), () -> color.alpha() ? entry.getInt() : entry.getInt() | 0xFF000000, value -> {
                        value = color.alpha() ? value : value & 0xFFFFFF;
                        entry.setInt(value);
                    }));
                    widgets.add(new StringOptionWidget(() -> "#" + String.format("%06X", entry.getInt()), s -> {
                        try {
                            if (((String)s).length() == 8 && !color.alpha()) {
                                s = ((String)s).substring(2);
                            }
                            if (((String)s).length() == 3) {
                                s = "" + ((String)s).charAt(0) + ((String)s).charAt(0) + ((String)s).charAt(1) + ((String)s).charAt(1) + ((String)s).charAt(2) + ((String)s).charAt(2);
                            }
                            entry.setInt(Long.decode((String)s).intValue());
                            return true;
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                    }, false));
                    break;
                }
                if (data.hasOption(Option.KEYBIND)) {
                    widgets.add(new KeybindOptionWidget(entry::getInt, entry::setInt));
                    break;
                }
                widgets.add((class_339)new NumberOptionWidget<Integer>(entry::getInt, entry::setInt, Options.parseNumber(data, Integer::parseInt), NumberOptionWidget.INTEGER_FILTER));
                break;
            }
            case BYTE: 
            case SHORT: 
            case LONG: {
                Record range = WholeOptionRange.of(entry);
                if (range.hasRange() && data.hasOption(Option.SLIDER)) {
                    widgets.add(new RangeOptionWidget((OptionRange)((Object)range)));
                    break;
                }
                widgets.add((class_339)(switch (entry.type()) {
                    case EntryType.BYTE -> new NumberOptionWidget<Byte>(entry::getByte, entry::setByte, Options.parseNumber(data, Byte::parseByte), NumberOptionWidget.INTEGER_FILTER);
                    case EntryType.SHORT -> new NumberOptionWidget<Short>(entry::getShort, entry::setShort, Options.parseNumber(data, Short::parseShort), NumberOptionWidget.INTEGER_FILTER);
                    case EntryType.LONG -> new NumberOptionWidget<Long>(entry::getLong, entry::setLong, Options.parseNumber(data, Long::parseLong), NumberOptionWidget.INTEGER_FILTER);
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
                }));
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                Record range = DecimalOptionRange.of(entry);
                if (range.hasRange() && data.hasOption(Option.SLIDER)) {
                    widgets.add(new RangeOptionWidget((OptionRange)((Object)range)));
                    break;
                }
                widgets.add((class_339)(switch (entry.type()) {
                    case EntryType.FLOAT -> new NumberOptionWidget<Float>(entry::getFloat, entry::setFloat, Float::parseFloat, NumberOptionWidget.DECIMAL_FILTER);
                    case EntryType.DOUBLE -> new NumberOptionWidget<Double>(entry::getDouble, entry::setDouble, Double::parseDouble, NumberOptionWidget.DECIMAL_FILTER);
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
                }));
                break;
            }
            case OBJECT: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)entry.type()));
            }
        }
        SpriteButton reset = SpriteButton.builder(12, 12).padding(2).sprite(ModSprites.RESET).tooltip(UIConstants.RESET).onPress(Options.resetValue(entry, widgets)).build();
        widgets.add((class_339)reset);
        list.add(new OptionItem(entry, widgets));
    }

    private static Runnable resetValue(ResourcefulConfigEntry entry, List<class_339> widgets) {
        return () -> {
            entry.reset();
            for (class_339 widget : widgets) {
                if (!(widget instanceof ResetableWidget)) continue;
                ResetableWidget resetable = (ResetableWidget)widget;
                resetable.reset();
            }
        };
    }

    private static <T extends Number> Function<String, T> parseNumber(EntryData options, Function<String, T> parser) {
        return s -> {
            Number value = (Number)parser.apply((String)s);
            if (options.hasOption(Option.RANGE)) {
                ConfigOption.Range range = options.getOption(Option.RANGE);
                if (value.doubleValue() < range.min()) {
                    throw new NumberFormatException();
                }
                if (value.doubleValue() > range.max()) {
                    throw new NumberFormatException();
                }
            }
            return value;
        };
    }
}

