/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.options;

import com.teamresourceful.resourcefulconfig.api.annotations.ConfigOption;
import com.teamresourceful.resourcefulconfig.api.types.options.AnnotationGetter;
import com.teamresourceful.resourcefulconfig.common.utils.ModUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class Option<T extends Annotation, D> {
    private static final List<Option<?, ?>> VALUES = new ArrayList();
    public static final Option<ConfigOption.Color, ConfigOption.Color> COLOR = Option.of(ConfigOption.Color.class, type -> type == Integer.TYPE || type == Integer.class);
    public static final Option<ConfigOption.Slider, ConfigOption.Slider> SLIDER = Option.of(ConfigOption.Slider.class);
    public static final Option<ConfigOption.Multiline, ConfigOption.Multiline> MULTILINE = Option.of(ConfigOption.Multiline.class, type -> type == String.class);
    public static final Option<ConfigOption.Hidden, ConfigOption.Hidden> HIDDEN = Option.of(ConfigOption.Hidden.class);
    public static final Option<ConfigOption.Draggable, Enum<?>[]> DRAGGABLE = Option.of(ConfigOption.Draggable.class, type -> type.isArray() && type.getComponentType().isEnum(), (type, data) -> {
        Class<?> componentType = type.getComponentType();
        HashMap ids = new HashMap();
        for (Enum<?> e : ModUtils.getEnumConstants(componentType)) {
            ids.put(e.name(), e);
        }
        ArrayList<Enum> duplicates = new ArrayList<Enum>();
        for (String s : data.value()) {
            if (!ids.containsKey(s)) {
                throw new IllegalArgumentException("Invalid enum value: " + s);
            }
            duplicates.add((Enum)ids.get(s));
        }
        return duplicates.toArray((Enum[])Array.newInstance(componentType, duplicates.size()));
    });
    public static final Option<ConfigOption.Range, ConfigOption.Range> RANGE = Option.of(ConfigOption.Range.class);
    public static final Option<ConfigOption.Select, class_2561> SELECT = Option.of(ConfigOption.Select.class, type -> type.isArray() && type.getComponentType().isEnum(), (type, data) -> class_2561.method_43471((String)data.value()));
    public static final Option<ConfigOption.Separator, ConfigOption.Separator> SEPARATOR = Option.of(ConfigOption.Separator.class);
    public static final Option<ConfigOption.Regex, Pattern> REGEX = Option.of(ConfigOption.Regex.class, type -> type == String.class, (type, data) -> Pattern.compile(data.value()));
    public static final Option<ConfigOption.Keybind, ConfigOption.Keybind> KEYBIND = Option.of(ConfigOption.Keybind.class, type -> type == Integer.TYPE || type == Integer.class);
    public static final Option<ConfigOption.SearchTerm, List<String>> SEARCH_TERM = Option.of(ConfigOption.SearchTerm.class, type -> true, (type, data) -> List.of(data.value()));
    public static final Option<ConfigOption.Renderer, class_2960> RENDERER = Option.of(ConfigOption.Renderer.class, type -> true, (type, data) -> {
        String value = data.value();
        if (value.isEmpty()) {
            return null;
        }
        return class_2960.method_12829((String)value);
    });
    private final Class<T> annotation;
    private final Predicate<Class<?>> isAllowed;
    private final BiFunction<Class<?>, T, D> mapper;

    private Option(Class<T> annotation, Predicate<Class<?>> isAllowed, BiFunction<Class<?>, T, D> mapper) {
        this.annotation = annotation;
        this.isAllowed = isAllowed;
        this.mapper = mapper;
    }

    private Object getData(Annotation annotation, Class<?> clazz) {
        return this.mapper.apply(clazz, (Class<?>)((Object)annotation));
    }

    public static Map<Option<?, ?>, Object> gatherOptions(AnnotationGetter getter, Class<?> type) {
        IdentityHashMap values = new IdentityHashMap();
        for (Option<?, ?> value : VALUES) {
            Object annotation = getter.get(value.annotation);
            if (annotation == null || !value.isAllowed.test(type)) continue;
            values.put(value, value.getData((Annotation)annotation, type));
        }
        return values;
    }

    private static <T extends Annotation> Option<T, T> of(Class<T> annotation) {
        Option<Annotation, Annotation> option = new Option<Annotation, Annotation>(annotation, type -> true, (c, a) -> a);
        VALUES.add(option);
        return option;
    }

    public static <T extends Annotation> Option<T, T> of(Class<T> annotation, Predicate<Class<?>> isAllowed) {
        Option<Annotation, Annotation> option = new Option<Annotation, Annotation>(annotation, isAllowed, (c, a) -> a);
        VALUES.add(option);
        return option;
    }

    private static <T extends Annotation, D> Option<T, D> of(Class<T> annotation, Predicate<Class<?>> isAllowed, BiFunction<Class<?>, T, D> mapper) {
        Option<T, D> option = new Option<T, D>(annotation, isAllowed, mapper);
        VALUES.add(option);
        return option;
    }
}

