/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.options;

import com.teamresourceful.resourcefulconfig.api.annotations.Comment;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigOption;
import com.teamresourceful.resourcefulconfig.api.types.options.AnnotationGetter;
import com.teamresourceful.resourcefulconfig.api.types.options.Option;
import com.teamresourceful.resourcefulconfig.api.types.options.TranslatableValue;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_8144;

public record EntryData(TranslatableValue title, TranslatableValue comment, Map<Option<?, ?>, Object> options) {
    public static Builder builder() {
        return new Builder();
    }

    public static EntryData of(Field field, Class<?> type) {
        return EntryData.of(field::getAnnotation, type);
    }

    public static EntryData of(AnnotationGetter getter, Class<?> type) {
        ConfigEntry entry = getter.get(ConfigEntry.class);
        Builder builder = EntryData.builder().translation(entry.id(), entry.translation()).comment((String)class_8144.method_49078((Object)getter.get(Comment.class), Comment::value, (Object)""), (String)class_8144.method_49078((Object)getter.get(Comment.class), Comment::translation, (Object)"")).options(Option.gatherOptions(getter, type));
        return builder.build();
    }

    public boolean inRange(double value) {
        ConfigOption.Range range = this.getOption(Option.RANGE);
        return value >= range.min() && value <= range.max();
    }

    public boolean hasOption(Option<?, ?> option) {
        return this.options.containsKey(option);
    }

    public <T extends Annotation, D> D getOption(Option<T, D> option) {
        return (D)this.options.get(option);
    }

    public <T extends Annotation, D> D getOrDefaultOption(Option<T, D> option, D defaultValue) {
        return this.hasOption(option) ? this.getOption(option) : defaultValue;
    }

    public static class Builder {
        private TranslatableValue title = TranslatableValue.EMPTY;
        private TranslatableValue comment = TranslatableValue.EMPTY;
        private Map<Option<?, ?>, Object> options = new HashMap();

        public Builder translation(String value, String translation) {
            this.title = new TranslatableValue(value, translation);
            return this;
        }

        public Builder comment(String value, String translation) {
            this.comment = new TranslatableValue(value, translation);
            return this;
        }

        public Builder options(Map<Option<?, ?>, Object> options) {
            this.options.putAll(options);
            return this;
        }

        public <T extends Annotation, D> Builder option(Option<T, D> option, D value) {
            this.options.put(option, value);
            return this;
        }

        public EntryData build() {
            return new EntryData(this.title, this.comment, this.options);
        }
    }
}

