/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_forge.processing;

import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.treeharvester_common_forge.data.Variables;
import com.natamus.treeharvester_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class LeafProcessing {
    public static void breakTreeLeaves(Level level, List<BlockPos> logsToBreak, BlockPos lowestCenterLogPos, BlockPos highestLogPos) {
        BlockPos highestLeafPos;
        Block highestLeafBlock;
        if (level.isClientSide()) {
            return;
        }
        int highestX = Integer.MIN_VALUE;
        int highestZ = Integer.MIN_VALUE;
        int lowestX = Integer.MAX_VALUE;
        int lowestZ = Integer.MAX_VALUE;
        for (BlockPos brokenLogPos : logsToBreak) {
            int x = brokenLogPos.getX();
            int z = brokenLogPos.getZ();
            if (x > highestX) {
                highestX = x;
            }
            if (x < lowestX) {
                lowestX = x;
            }
            if (z > highestZ) {
                highestZ = z;
            }
            if (z >= lowestZ) continue;
            lowestZ = z;
        }
        if (!Variables.processBreakLeaves.containsKey(level)) {
            Variables.processBreakLeaves.put(level, new CopyOnWriteArrayList());
        }
        if (!Util.isTreeLeaf(highestLeafBlock = level.getBlockState(highestLeafPos = highestLogPos.above().immutable()).getBlock())) {
            for (BlockPos aroundPos : BlockPosFunctions.getBlocksAround((BlockPos)highestLeafPos, (boolean)false)) {
                Block aroundBlock = level.getBlockState(aroundPos).getBlock();
                if (!Util.isTreeLeaf(aroundBlock)) continue;
                highestLeafBlock = aroundBlock;
                break;
            }
        }
        boolean highestLeafIsMushroom = Util.isGiantMushroomLeafBlock(highestLeafBlock);
        int distance = 3;
        if (Util.isNetherTreeLeaf(highestLeafBlock)) {
            distance = 5;
        }
        ArrayList<BlockPos> treeBlocks = new ArrayList<BlockPos>();
        for (BlockPos iPos : BlockPos.betweenClosed((int)(lowestX - distance), (int)(lowestCenterLogPos.getY() - 1), (int)(lowestZ - distance), (int)(highestX + distance), (int)(highestLogPos.getY() + 5), (int)(highestZ + distance))) {
            treeBlocks.add(iPos.immutable());
        }
        Collections.shuffle(treeBlocks);
        for (BlockPos treeBlockPos : treeBlocks) {
            Block treeBlock;
            if (!level.isLoaded(treeBlockPos) || !Util.isTreeLeaf(treeBlock = level.getBlockState(treeBlockPos).getBlock()) || !highestLeafBlock.equals(treeBlock) && !Util.isNetherTreeLeaf(highestLeafBlock) || !Util.isGiantMushroomLeafBlock(treeBlock) && !highestLeafIsMushroom && LeafProcessing.hasLogsWithinDistance(level, treeBlockPos, 2) || Variables.processBreakLeaves.get(level).contains(treeBlockPos)) continue;
            Variables.processBreakLeaves.get(level).add(treeBlockPos);
        }
    }

    private static boolean hasLogsWithinDistance(Level level, BlockPos checkPos, int distance) {
        for (BlockPos treePos : BlockPos.betweenClosed((int)(checkPos.getX() - distance), (int)(checkPos.getY() - distance), (int)(checkPos.getZ() - distance), (int)(checkPos.getX() + distance), (int)(checkPos.getY() + distance), (int)(checkPos.getZ() + distance))) {
            if (!Util.isTreeLog(level.getBlockState(treePos).getBlock())) continue;
            return true;
        }
        return false;
    }
}

