/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.configurable.io.typed;

import com.bawnorton.configurable.io.typed.TypedHandler;
import com.bawnorton.configurable.io.typed.TypedReader;
import com.bawnorton.configurable.io.typed.TypedWriter;
import com.bawnorton.configurable.util.GenericType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class TypedHandlerCollection {
    private final Map<Class<?>, TypedHandler<?>> handlers = new HashMap();

    public <T> void register(Class<T> boxedType, @Nullable Class<T> primitiveType, TypedReader<T> reader, TypedWriter<T> writer) {
        this.handlers.put(boxedType, new TypedHandler<T>(reader, writer));
        if (primitiveType != null) {
            this.handlers.put(primitiveType, new TypedHandler<T>(reader, writer));
        }
    }

    public <T> TypedHandler<T> getHandlerFor(GenericType genericType) {
        TypedHandler<?> handler = this.handlers.get(genericType.type());
        if (handler == null) {
            throw new IllegalArgumentException("No TypedHandler registered for type: " + genericType.type().getName());
        }
        return handler;
    }
}

