/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.shadow.io.sigpipe.jbsdiff;

import com.euphoriapatches.shadow.io.sigpipe.jbsdiff.ControlBlock;
import com.euphoriapatches.shadow.io.sigpipe.jbsdiff.Header;
import com.euphoriapatches.shadow.io.sigpipe.jbsdiff.InvalidHeaderException;
import com.euphoriapatches.shadow.org.apache.commons.compress.compressors.CompressorException;
import com.euphoriapatches.shadow.org.apache.commons.compress.compressors.CompressorStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Patch {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patch(byte[] old, byte[] patch, OutputStream out) throws CompressorException, InvalidHeaderException, IOException {
        ByteArrayInputStream headerIn = new ByteArrayInputStream(patch);
        Header header = new Header(headerIn);
        ((InputStream)headerIn).close();
        InputStream controlIn = new ByteArrayInputStream(patch);
        InputStream dataIn = new ByteArrayInputStream(patch);
        InputStream extraIn = new ByteArrayInputStream(patch);
        try {
            controlIn.skip(32L);
            dataIn.skip(32 + header.getControlLength());
            extraIn.skip(32 + header.getControlLength() + header.getDiffLength());
            CompressorStreamFactory compressor = new CompressorStreamFactory();
            controlIn = compressor.createCompressorInputStream(controlIn);
            dataIn = compressor.createCompressorInputStream(dataIn);
            extraIn = compressor.createCompressorInputStream(extraIn);
            int newPointer = 0;
            int oldPointer = 0;
            byte[] output = new byte[header.getOutputLength()];
            while (newPointer < output.length) {
                ControlBlock control = new ControlBlock(controlIn);
                Patch.read(dataIn, output, newPointer, control.getDiffLength());
                for (int i = 0; i < control.getDiffLength(); ++i) {
                    if (oldPointer + i < 0 || oldPointer + i >= old.length) continue;
                    int n = newPointer + i;
                    output[n] = (byte)(output[n] + old[oldPointer + i]);
                }
                oldPointer += control.getDiffLength();
                Patch.read(extraIn, output, newPointer += control.getDiffLength(), control.getExtraLength());
                newPointer += control.getExtraLength();
                oldPointer += control.getSeekLength();
            }
            out.write(output);
        }
        finally {
            controlIn.close();
            dataIn.close();
            extraIn.close();
        }
    }

    private static void read(InputStream in, byte[] dest, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int read = in.read(dest, off, len);
        if (read < len) {
            throw new IOException("Corrupt patch; bytes expected = " + len + " bytes read = " + read);
        }
    }
}

