/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.config.ConfigHandler;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.VersionComparator;
import com.euphoriapatches.shadow.com.google.gson.JsonArray;
import com.euphoriapatches.shadow.com.google.gson.JsonElement;
import com.euphoriapatches.shadow.com.google.gson.JsonObject;
import com.euphoriapatches.shadow.com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Locale;

public class UpdateChecker {
    private static final String PROJECT_ID = "4H6sumDB";
    private static final String UPDATE_URL = "https://api.modrinth.com/v2/project/4H6sumDB/version";
    private static final String MOD_VERSION = "_1.8.6".replace("_", "");
    private static String NEW_MOD_VERSION = null;
    private static String COMPLEMENTARY_VERSION = null;
    private static boolean NEW_VERSION_AVAILABLE = false;
    private static boolean UPDATE_CHECK_PERFORMED = false;
    private static String RECOMMENDED_PATCH_VERSION = null;
    private static Boolean CACHED_IS_IMPORTANT_UPDATE = null;
    private static Boolean CACHED_IS_PATCH_UPDATE_RECOMMENDED = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[UpdateChecker] " + message);
    }

    public static boolean isUpdateAvailable() {
        try {
            UpdateChecker.checkForUpdates();
            return NEW_VERSION_AVAILABLE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getNewModVersion() {
        UpdateChecker.checkForUpdates();
        return NEW_MOD_VERSION;
    }

    public static String getComplementaryVersion() {
        UpdateChecker.checkForUpdates();
        return COMPLEMENTARY_VERSION;
    }

    public static boolean isNewerCompVersionAvailable() {
        UpdateChecker.checkForUpdates();
        if (COMPLEMENTARY_VERSION == null || COMPLEMENTARY_VERSION.isEmpty()) {
            return false;
        }
        String currentCompVersion = "_r5.7.1".replace("_r", "");
        boolean isNewer = VersionComparator.isNewerVersion(COMPLEMENTARY_VERSION, currentCompVersion);
        UpdateChecker.debugLog("Current Complementary Shaders version: " + currentCompVersion);
        UpdateChecker.debugLog("Latest Complementary Shaders version: " + COMPLEMENTARY_VERSION);
        UpdateChecker.debugLog("Is newer Complementary Shaders version available? " + isNewer);
        return isNewer;
    }

    public static boolean shouldUserUpdate() {
        return ConfigHandler.updateMode.equals("all") ? UpdateChecker.isUpdateAvailable() : UpdateChecker.isUpdateAvailable() && (UpdateChecker.isImportantUpdate() || UpdateChecker.isPatchUpdateRecommended());
    }

    public static boolean isImportantUpdate() {
        if (CACHED_IS_IMPORTANT_UPDATE != null) {
            UpdateChecker.debugLog("Using cached important update result: " + CACHED_IS_IMPORTANT_UPDATE);
            return CACHED_IS_IMPORTANT_UPDATE;
        }
        UpdateChecker.debugLog("Checking if update is important...");
        if (!UpdateChecker.isUpdateAvailable()) {
            UpdateChecker.debugLog("No new version available, not an important update");
            CACHED_IS_IMPORTANT_UPDATE = false;
            return false;
        }
        try {
            boolean isImportant;
            String[] currentParts = MOD_VERSION.split("\\.");
            if (currentParts.length < 2) {
                UpdateChecker.debugLog("Invalid current version format: " + MOD_VERSION);
                CACHED_IS_IMPORTANT_UPDATE = false;
                return false;
            }
            int currentMajor = Integer.parseInt(currentParts[0]);
            int currentMinor = Integer.parseInt(currentParts[1]);
            String[] newParts = NEW_MOD_VERSION.split("\\.");
            if (newParts.length < 2) {
                UpdateChecker.debugLog("Invalid new version format: " + NEW_MOD_VERSION);
                CACHED_IS_IMPORTANT_UPDATE = false;
                return false;
            }
            int newMajor = Integer.parseInt(newParts[0]);
            int newMinor = Integer.parseInt(newParts[1]);
            UpdateChecker.debugLog("Current version: " + currentMajor + "." + currentMinor + ", New version: " + newMajor + "." + newMinor);
            boolean bl = isImportant = newMajor > currentMajor || newMajor == currentMajor && newMinor > currentMinor;
            if (isImportant) {
                UpdateChecker.debugLog("Important update detected: " + MOD_VERSION + " -> " + NEW_MOD_VERSION);
            } else {
                UpdateChecker.debugLog("Minor (patch) update detected: " + MOD_VERSION + " -> " + NEW_MOD_VERSION);
            }
            CACHED_IS_IMPORTANT_UPDATE = isImportant;
            return isImportant;
        }
        catch (NumberFormatException e) {
            UpdateChecker.debugLog("Error parsing version numbers: " + e.getMessage());
            CACHED_IS_IMPORTANT_UPDATE = false;
            return false;
        }
    }

    public static boolean isPatchUpdateRecommended() {
        if (CACHED_IS_PATCH_UPDATE_RECOMMENDED != null) {
            UpdateChecker.debugLog("Using cached patch update recommendation result: " + CACHED_IS_PATCH_UPDATE_RECOMMENDED);
            return CACHED_IS_PATCH_UPDATE_RECOMMENDED;
        }
        UpdateChecker.debugLog("Checking if patch update is recommended...");
        if (!UpdateChecker.isUpdateAvailable()) {
            UpdateChecker.debugLog("No new version available, patch update not recommended");
            CACHED_IS_PATCH_UPDATE_RECOMMENDED = false;
            return false;
        }
        try {
            int recPatch;
            String[] currentParts = MOD_VERSION.split("\\.");
            if (currentParts.length < 3) {
                UpdateChecker.debugLog("Invalid current version format: " + MOD_VERSION);
                CACHED_IS_PATCH_UPDATE_RECOMMENDED = false;
                return false;
            }
            int currentMajor = Integer.parseInt(currentParts[0]);
            int currentMinor = Integer.parseInt(currentParts[1]);
            int currentPatch = Integer.parseInt(currentParts[2]);
            String[] newParts = NEW_MOD_VERSION.split("\\.");
            if (newParts.length < 3) {
                UpdateChecker.debugLog("Invalid new version format: " + NEW_MOD_VERSION);
                CACHED_IS_PATCH_UPDATE_RECOMMENDED = false;
                return false;
            }
            int newMajor = Integer.parseInt(newParts[0]);
            int newMinor = Integer.parseInt(newParts[1]);
            if (currentMajor != newMajor || currentMinor != newMinor) {
                UpdateChecker.debugLog("Not in the same patch cycle: current " + currentMajor + "." + currentMinor + ", new " + newMajor + "." + newMinor);
                CACHED_IS_PATCH_UPDATE_RECOMMENDED = false;
                return false;
            }
            UpdateChecker.debugLog("In the same patch cycle: " + currentMajor + "." + currentMinor);
            if (RECOMMENDED_PATCH_VERSION == null && (RECOMMENDED_PATCH_VERSION = UpdateChecker.fetchRecommendedPatchVersion(currentMajor, currentMinor)) == null) {
                RECOMMENDED_PATCH_VERSION = "";
            }
            if (RECOMMENDED_PATCH_VERSION.isEmpty()) {
                UpdateChecker.debugLog("No recommended patch version found in current cycle");
                CACHED_IS_PATCH_UPDATE_RECOMMENDED = false;
                return false;
            }
            String[] recParts = RECOMMENDED_PATCH_VERSION.split("\\.");
            if (recParts.length >= 3 && currentPatch < (recPatch = Integer.parseInt(recParts[2]))) {
                UpdateChecker.debugLog("Recommended patch update found: " + RECOMMENDED_PATCH_VERSION + " (current: " + MOD_VERSION + ")");
                CACHED_IS_PATCH_UPDATE_RECOMMENDED = true;
                return true;
            }
            UpdateChecker.debugLog("Current version is up to date with recommended patches");
            CACHED_IS_PATCH_UPDATE_RECOMMENDED = false;
            return false;
        }
        catch (NumberFormatException e) {
            UpdateChecker.debugLog("Error parsing version numbers: " + e.getMessage());
            CACHED_IS_PATCH_UPDATE_RECOMMENDED = false;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fetchRecommendedPatchVersion(int major, int minor) {
        UpdateChecker.debugLog("Fetching recommended patch version for " + major + "." + minor + ".x");
        try {
            URL url = new URL("https://api.modrinth.com/v2/project/4H6sumDB/version?include_changelog=true");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                UpdateChecker.debugLog("Failed to fetch versions for recommended patch check. Response code: " + responseCode);
                return null;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                JsonElement jsonElement = new JsonParser().parse(reader);
                JsonArray versions = jsonElement.getAsJsonArray();
                UpdateChecker.debugLog("Analyzing " + versions.size() + " versions for recommended patches");
                String lastCheckedVersion = null;
                int i = 0;
                while (i < versions.size()) {
                    block22: {
                        JsonObject version = versions.get(i).getAsJsonObject();
                        String fullVersionNumber = version.get("version_number").getAsString();
                        String mainVersion = UpdateChecker.extractEuphoriaPatchesVersion(fullVersionNumber);
                        if (!mainVersion.equals(lastCheckedVersion)) {
                            lastCheckedVersion = mainVersion;
                            String[] versionParts = mainVersion.split("\\.");
                            if (versionParts.length >= 3) {
                                try {
                                    int vMajor = Integer.parseInt(versionParts[0]);
                                    int vMinor = Integer.parseInt(versionParts[1]);
                                    if (vMajor != major || vMinor != minor) {
                                        if (vMajor < major || vMajor == major && vMinor < minor) {
                                            UpdateChecker.debugLog("Reached versions below current patch cycle, stopping");
                                            return null;
                                        }
                                        break block22;
                                    }
                                    UpdateChecker.debugLog("Checking version " + mainVersion + " in current patch cycle");
                                    if (version.has("changelog")) {
                                        String changelog = version.get("changelog").getAsString();
                                        UpdateChecker.debugLog("Fetched Changelog is:\n" + changelog);
                                        if (UpdateChecker.isRecommendedUpdate(changelog)) {
                                            UpdateChecker.debugLog("Found recommended patch version: " + mainVersion);
                                            String string = mainVersion;
                                            return string;
                                        }
                                    }
                                }
                                catch (NumberFormatException e) {
                                    UpdateChecker.debugLog("Error parsing version " + mainVersion + ": " + e.getMessage());
                                }
                            }
                        }
                    }
                    ++i;
                }
                return null;
            }
            finally {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            UpdateChecker.debugLog("Error fetching recommended patch version: " + e.getMessage());
        }
        return null;
    }

    private static boolean isRecommendedUpdate(String changelog) {
        String[] lines;
        if (changelog == null || changelog.isEmpty()) {
            return false;
        }
        for (String line : lines = changelog.split("\n")) {
            String lowerLine = line.toLowerCase(Locale.ROOT);
            if (!lowerLine.contains("updated to complementary shaders") || !lowerLine.contains("euphoria patches") || !lowerLine.contains("update recommended")) continue;
            return true;
        }
        return false;
    }

    public static void checkForUpdates() {
        if (UPDATE_CHECK_PERFORMED || ConfigHandler.updateMode.equals("none")) {
            UpdateChecker.debugLog("Update check skipped. Already performed: " + UPDATE_CHECK_PERFORMED + ", Update checking mode set to: " + ConfigHandler.updateMode);
            return;
        }
        UPDATE_CHECK_PERFORMED = true;
        UpdateChecker.debugLog("Starting update check...");
        UpdateChecker.debugLog("Current version: " + MOD_VERSION);
        try {
            String fullVersionNumber = UpdateChecker.fetchLatestVersion();
            NEW_MOD_VERSION = UpdateChecker.extractEuphoriaPatchesVersion(fullVersionNumber);
            COMPLEMENTARY_VERSION = UpdateChecker.extractComplementaryVersion(fullVersionNumber);
            if (NEW_MOD_VERSION == null) {
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Failed to fetch the latest version.");
                UpdateChecker.debugLog("Failed to fetch latest version from Modrinth API");
                return;
            }
            UpdateChecker.debugLog("Latest version from Modrinth: " + NEW_MOD_VERSION);
            if (VersionComparator.isNewerVersion(NEW_MOD_VERSION, MOD_VERSION)) {
                NEW_VERSION_AVAILABLE = true;
                UpdateChecker.debugLog("New version available!");
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] A new version of the EuphoriaPatcher Mod is available: " + NEW_MOD_VERSION);
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Download it from Modrinth: https://euphoriapatches.com/download");
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Current Version: " + MOD_VERSION);
            } else {
                UpdateChecker.debugLog("Mod is up to date");
                EuphoriaPatcher.log(0, "[UPDATE CHECKER] The EuphoriaPatcher Mod is up to date");
            }
        }
        catch (Exception e) {
            String errorType = e.getClass().getSimpleName();
            String errorMessage = e.getMessage() != null ? e.getMessage() : "Unknown error";
            EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Update check failed: " + errorType + " - " + errorMessage);
            UpdateChecker.debugLog("Update check failed with " + errorType + ": " + errorMessage);
            UpdateChecker.debugLog("Full exception: " + e);
        }
    }

    private static String extractEuphoriaPatchesVersion(String versionString) {
        return versionString.split("-")[0];
    }

    private static String extractComplementaryVersion(String versionString) {
        return versionString.split("-")[1].split("r")[1];
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String fetchLatestVersion() throws Exception {
        UpdateChecker.debugLog("Fetching latest version from Modrinth API: https://api.modrinth.com/v2/project/4H6sumDB/version");
        try {
            URL url = new URL("https://api.modrinth.com/v2/project/4H6sumDB/version?include_changelog=false");
            UpdateChecker.debugLog("URL created successfully");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            UpdateChecker.debugLog("Connection configured, attempting to connect...");
            int responseCode = connection.getResponseCode();
            UpdateChecker.debugLog("Modrinth API response code: " + responseCode);
            if (responseCode != 200) {
                EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] Failed to connect to Modrinth API. Response code: " + responseCode);
                UpdateChecker.debugLog("Connection failed with response code: " + responseCode);
                return null;
            }
            try {
                JsonArray versions;
                BufferedReader reader;
                block17: {
                    String string;
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    try {
                        UpdateChecker.debugLog("Reading response from API...");
                        JsonElement jsonElement = new JsonParser().parse(reader);
                        versions = jsonElement.getAsJsonArray();
                        UpdateChecker.debugLog("Fetched " + versions.size() + " versions from Modrinth");
                        if (!versions.isEmpty()) break block17;
                        EuphoriaPatcher.log(2, 0, "[UPDATE CHECKER] No versions found on Modrinth.");
                        UpdateChecker.debugLog("No versions found in API response");
                        string = MOD_VERSION;
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    reader.close();
                    return string;
                }
                JsonObject latestVersion = versions.get(0).getAsJsonObject();
                String fullVersionNumber = latestVersion.get("version_number").getAsString();
                UpdateChecker.debugLog("Full version number from Modrinth: " + fullVersionNumber);
                String string = fullVersionNumber;
                reader.close();
                return string;
            }
            finally {
                connection.disconnect();
                UpdateChecker.debugLog("Connection closed");
            }
        }
        catch (UnknownHostException e) {
            UpdateChecker.debugLog("Network error: Unable to resolve Modrinth API host (no internet connection or DNS issue)");
            throw new Exception("Unable to reach Modrinth API - No internet connection or DNS issue: " + e.getMessage(), e);
        }
        catch (ConnectException e) {
            UpdateChecker.debugLog("Network error: Connection refused or timeout");
            throw new Exception("Unable to connect to Modrinth API - Connection refused or timeout: " + e.getMessage(), e);
        }
        catch (SocketTimeoutException e) {
            UpdateChecker.debugLog("Network error: Request timed out");
            throw new Exception("Modrinth API request timed out - Please check your internet connection: " + e.getMessage(), e);
        }
        catch (IOException e) {
            UpdateChecker.debugLog("IO error while fetching version: " + e.getMessage());
            throw new Exception("IO error while accessing Modrinth API: " + e.getMessage(), e);
        }
        catch (Exception e) {
            UpdateChecker.debugLog("Unexpected error: " + e.getClass().getSimpleName() + " - " + e.getMessage());
            throw new Exception("Unexpected error while fetching version: " + e.getMessage(), e);
        }
    }
}

