/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.VersionComparator;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShaderVersionComparator {
    private final String brandName;
    private final String patchName;
    private final String version;
    private final Path shaderpacks;
    private ShaderVersionComparator instance;
    public static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)");
    private static final Pattern COMPLEMENTARY_VERSION_PATTERN = Pattern.compile("_r(\\d+)\\.(\\d+)(?:\\.(\\d+))?");

    public ShaderVersionComparator(String brandName, String patchName, String version, Path shaderpacks) {
        this.brandName = brandName;
        this.patchName = patchName;
        this.version = version;
        this.shaderpacks = shaderpacks;
    }

    public ShaderVersionComparator getInstance() {
        if (this.instance == null) {
            this.instance = new ShaderVersionComparator(this.brandName, this.patchName, this.version, this.shaderpacks);
        }
        return this.instance;
    }

    public boolean isNewerShaderVersion(String fileName) {
        int[] targetVersion;
        if (!fileName.contains(this.brandName)) {
            return false;
        }
        int[] fileVersion = this.extractComplementaryVersionNumbers(fileName);
        return VersionComparator.compareVersionArrays(fileVersion, targetVersion = this.extractComplementaryVersionNumbers(this.version)) > 0;
    }

    public String getComplementaryVersionFromFileName(String fileName) {
        int[] versionNumbers = this.extractComplementaryVersionNumbers(fileName);
        StringBuilder sb = new StringBuilder("r").append(versionNumbers[0]).append(".").append(versionNumbers[1]);
        if (versionNumbers[2] > 0) {
            sb.append(".").append(versionNumbers[2]);
        }
        return sb.toString();
    }

    public int[] extractComplementaryVersionNumbers(String filename) {
        int[] version = new int[]{0, 0, 0};
        Matcher matcher = COMPLEMENTARY_VERSION_PATTERN.matcher(filename);
        if (matcher.find()) {
            version[0] = Integer.parseInt(matcher.group(1));
            version[1] = Integer.parseInt(matcher.group(2));
            version[2] = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
        }
        return version;
    }

    public static int convertVersionNumberToInt(String versionString) {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            ShaderVersionComparator.debugLog("Invalid version format: " + versionString);
            return 0;
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        return major * 10000 + minor * 100 + patch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Path findNewerComplementaryVersion() {
        try {
            if (this.shaderpacks == null) return null;
            if (!Files.exists(this.shaderpacks, new LinkOption[0])) {
                return null;
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks);){
                Path path;
                block12: {
                    Iterator<Path> iterator = stream.iterator();
                    while (iterator.hasNext()) {
                        path = iterator.next();
                        String fileName = path.getFileName().toString();
                        if (!fileName.contains(this.brandName) || fileName.contains(this.patchName) || !this.isNewerShaderVersion(fileName)) continue;
                        boolean isFile = Files.isRegularFile(path, new LinkOption[0]) && fileName.endsWith(".zip");
                        boolean isDir = Files.isDirectory(path, new LinkOption[0]);
                        if (!isFile && !isDir) {
                            continue;
                        }
                        break block12;
                    }
                    return null;
                }
                Path path2 = path;
                return path2;
            }
        }
        catch (Exception e) {
            ShaderVersionComparator.debugLog("Error checking for newer shader versions: " + e.getMessage());
        }
        return null;
    }

    public Path findHighestOlderComplementaryVersion() {
        Path highestVersionPath = null;
        int[] highestVersion = new int[]{0, 0, 0};
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks);){
            for (Path path : stream) {
                int[] version;
                if (!this.isOlderComplementaryShader(path, Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip")) || VersionComparator.compareVersionArrays(version = this.extractComplementaryVersionNumbers(path.getFileName().toString()), highestVersion) <= 0) continue;
                highestVersion = version;
                highestVersionPath = path;
            }
        }
        catch (IOException e) {
            ShaderVersionComparator.debugLog("Error checking for older shader versions: " + e.getMessage());
        }
        return highestVersionPath;
    }

    public boolean isOlderComplementaryShader(Path path, boolean isFile) {
        boolean isComplementary;
        String name = path.getFileName().toString();
        boolean bl = isComplementary = name.contains(this.brandName) && name.matches(".*_r\\d+\\.\\d+(?:\\.\\d+)?.*") && !name.contains(this.patchName);
        if (isComplementary) {
            int[] targetVersion;
            boolean isOlder;
            int[] fileVersion = this.extractComplementaryVersionNumbers(name);
            boolean bl2 = isOlder = VersionComparator.compareVersionArrays(fileVersion, targetVersion = this.extractComplementaryVersionNumbers(this.version)) < 0;
            return isOlder && (isFile ? name.endsWith(".zip") : Files.isDirectory(path, new LinkOption[0]));
        }
        return false;
    }

    public static boolean isTestOrDevVersion(String fileName) {
        String fileNameLower = fileName.toLowerCase(Locale.ROOT);
        return fileNameLower.contains("test") || fileNameLower.contains("fix") || fileNameLower.contains("dev") || fileNameLower.contains("pre");
    }

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderVersionComparator] " + message);
    }
}

