/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.file.Path;

public class ModsDirectory {
    private static Path modsDirectory;
    private static final Path defaultModsDir;

    public static Path get() {
        if (modsDirectory == null) {
            modsDirectory = ModsDirectory.findModsDirectory();
            ModsDirectory.debugLog("Found mods directory: " + modsDirectory);
        } else {
            ModsDirectory.debugLog("Using cached mods directory: " + modsDirectory);
        }
        return modsDirectory;
    }

    private static Path findModsDirectory() {
        Path currentModLocation = ModsDirectory.getCurrentModLocation();
        if (currentModLocation != null) {
            ModsDirectory.debugLog("EuphoriaPatcher mod is running from: " + currentModLocation);
            if (currentModLocation.startsWith(defaultModsDir)) {
                ModsDirectory.debugLog("Mod is running from default mods directory, using it: " + currentModLocation);
            }
            return currentModLocation;
        }
        return defaultModsDir;
    }

    private static Path getCurrentModLocation() {
        try {
            URI uri = EuphoriaPatcher.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            String uriString = uri.toString();
            ModsDirectory.debugLog("Code source URI: " + uriString + " (scheme: " + uri.getScheme() + ")");
            int jarIndex = uriString.indexOf(".jar");
            if (jarIndex != -1) {
                String jarPath = uriString.substring(0, jarIndex + 4);
                if (jarPath.startsWith("union:/")) {
                    jarPath = jarPath.substring(7);
                } else if (jarPath.startsWith("jar:file:/")) {
                    jarPath = jarPath.substring(10);
                } else if (jarPath.startsWith("file:/")) {
                    jarPath = jarPath.substring(6);
                } else if (jarPath.startsWith("jar:/")) {
                    jarPath = jarPath.substring(5);
                }
                if (jarPath.startsWith("/") && jarPath.length() > 2 && jarPath.charAt(1) == ':') {
                    jarPath = jarPath.substring(1);
                }
                jarPath = URLDecoder.decode(jarPath, "UTF-8");
                ModsDirectory.debugLog("Extracted JAR path: " + jarPath);
                Path jarFile = new File(jarPath).toPath();
                ModsDirectory.debugLog("Mod JAR file: " + jarFile);
                return jarFile.getParent();
            }
            ModsDirectory.debugLog("Could not find .jar in URI");
            return null;
        }
        catch (Exception e) {
            ModsDirectory.debugLog("Could not determine current mod location: " + e.getMessage());
            return null;
        }
    }

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ModDirectory] " + message);
    }

    static {
        defaultModsDir = EuphoriaPatcher.shaderpacks.getParent().resolve("mods");
    }
}

