/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.util;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.ArchiveUtils;
import com.euphoriapatches.euphoria_patcher.util.HashUtils;
import com.euphoriapatches.euphoria_patcher.util.ShaderVersionComparator;
import com.euphoriapatches.euphoria_patcher.util.UserInstallErrorMessages;
import com.euphoriapatches.shadow.org.apache.commons.compress.archivers.ArchiveException;
import com.euphoriapatches.shadow.org.apache.commons.io.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveOperations {
    private static ShaderVersionComparator cachedVersionComparator = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ArchiveOperations] " + message);
    }

    private static ShaderVersionComparator getVersionComparator() {
        if (cachedVersionComparator == null) {
            EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
            cachedVersionComparator = instance != null ? instance.getVersionComparator() : null;
        }
        return cachedVersionComparator;
    }

    public static Path extract(Path source, Path targetDir, String operationName) {
        try {
            ArchiveOperations.debugLog("Extracting: " + source.getFileName() + " to " + targetDir);
            if (Files.isDirectory(source, new LinkOption[0])) {
                ArchiveOperations.debugLog("Source is already a directory, no extraction needed");
                return source;
            }
            ArchiveUtils.extract(source, targetDir);
            ArchiveOperations.debugLog("Extraction completed successfully");
            return targetDir;
        }
        catch (ArchiveException | IOException e) {
            ArchiveOperations.debugLog("Error " + operationName + ": " + e.getMessage());
            EuphoriaPatcher.log(2, "Error " + operationName + ": " + e.getMessage());
            return null;
        }
    }

    public static Path archive(Path source, Path targetArchive) {
        try {
            ArchiveOperations.debugLog("Archiving: " + source.getFileName() + " to " + targetArchive);
            ArchiveUtils.archive(source, targetArchive);
            ArchiveOperations.debugLog("Archiving completed successfully");
            return targetArchive;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error creating archive: " + e.getMessage());
            EuphoriaPatcher.log(2, "Error creating archive: " + e.getMessage());
            return null;
        }
    }

    public static Path createTempDirectory() {
        try {
            Path temp = Files.createTempDirectory("euphoria-patcher-", new FileAttribute[0]);
            ArchiveOperations.debugLog("Created temporary directory: " + temp);
            return temp;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error creating temporary directory: " + e.getMessage());
            EuphoriaPatcher.log(3, "Error creating temporary directory: " + e.getMessage());
            return null;
        }
    }

    public static void deleteTempDirectory(Path tempDir) {
        if (tempDir == null || !Files.exists(tempDir, new LinkOption[0])) {
            ArchiveOperations.debugLog("Temp directory is null or does not exist: " + tempDir);
            return;
        }
        try {
            ArchiveOperations.debugLog("Cleaning up temp directory: " + tempDir);
            FileUtils.deleteDirectory(tempDir.toFile());
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Failed to clean up temp directory: " + e.getMessage());
        }
    }

    public static void deleteRecursively(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> entries = Files.list(path);){
                entries.forEach(entry -> {
                    try {
                        ArchiveOperations.deleteRecursively(entry);
                    }
                    catch (IOException e) {
                        EuphoriaPatcher.log(2, 0, "Error deleting entry: " + entry + " - " + e.getMessage());
                    }
                });
            }
        }
        Files.delete(path);
    }

    public static boolean fileExistsInZip(Path zipPath, String filePathInZip) {
        boolean bl;
        if (!Files.exists(zipPath, new LinkOption[0]) || !zipPath.toString().endsWith(".zip")) {
            return false;
        }
        ZipFile zipFile = new ZipFile(zipPath.toFile());
        try {
            ZipEntry entry = zipFile.getEntry(filePathInZip);
            boolean exists = entry != null && !entry.isDirectory();
            ArchiveOperations.debugLog("Checked for " + filePathInZip + " in " + zipPath.getFileName() + ": " + exists);
            bl = exists;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ArchiveOperations.debugLog("Error checking file in zip: " + e.getMessage());
                return false;
            }
        }
        zipFile.close();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileFromZip(Path zipPath, String filePathInZip) {
        if (!Files.exists(zipPath, new LinkOption[0])) return null;
        if (!zipPath.toString().endsWith(".zip")) {
            return null;
        }
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            ZipEntry entry = zipFile.getEntry(filePathInZip);
            if (entry == null || entry.isDirectory()) {
                ArchiveOperations.debugLog("File not found in zip: " + filePathInZip);
                String string = null;
                return string;
            }
            StringBuilder content = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
            }
            ArchiveOperations.debugLog("Read " + content.length() + " bytes from " + filePathInZip + " in " + zipPath.getFileName());
            String string = content.toString();
            return string;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error reading file from zip: " + e.getMessage());
            return null;
        }
    }

    public static boolean verifyBaseArchive(Path baseArchived, String originalFileName) {
        try {
            boolean isValidSize;
            String fileName = baseArchived.getFileName().toString();
            ArchiveOperations.debugLog("Verifying archive: " + fileName);
            long fileSize = Files.size(baseArchived);
            ArchiveOperations.debugLog("Archive size: " + fileSize + " bytes, expected: " + 1526272 + " bytes");
            boolean bl = isValidSize = fileSize == 1526272L;
            if (!isValidSize) {
                ArchiveOperations.debugLog("Invalid archive size: verification failed");
                ShaderVersionComparator versionComparator = ArchiveOperations.getVersionComparator();
                UserInstallErrorMessages.handleSizeMismatch(fileName, originalFileName, versionComparator);
                return false;
            }
            if (ShaderVersionComparator.isTestOrDevVersion(fileName)) {
                ArchiveOperations.debugLog("Test/fix version detected: " + originalFileName);
                UserInstallErrorMessages.handleDevVersion(fileName, originalFileName);
                return false;
            }
            if (HashUtils.hasIncorrectHash(baseArchived, "f43c1cb7210ec19ecdddceefb251fdd22ea800224c5277d17b70b7a7e91cc1ce")) {
                ArchiveOperations.debugLog("Archive hash verification failed - file has been modified");
                UserInstallErrorMessages.handleHashMismatch(fileName, originalFileName);
                return false;
            }
            ArchiveOperations.debugLog("Archive size and hash verification passed");
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error during archive verification: " + e.getMessage());
            EuphoriaPatcher.log(3, "Something went wrong during the file verification: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean verifyBaseArchiveQuiet(Path baseArchived) {
        try {
            String fileName = baseArchived.getFileName().toString();
            ArchiveOperations.debugLog("Quietly verifying archive: " + fileName);
            long fileSize = Files.size(baseArchived);
            boolean isValidSize = fileSize == 1526272L;
            ArchiveOperations.debugLog("Archive size: " + fileSize + " bytes, expected: " + 1526272 + " bytes, valid: " + isValidSize);
            if (!isValidSize) {
                return false;
            }
            if (ShaderVersionComparator.isTestOrDevVersion(fileName)) {
                ArchiveOperations.debugLog("Test/fix version detected in quiet check: " + fileName);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error during quiet archive verification: " + e.getMessage());
            return false;
        }
    }
}

