/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.services;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.ArchiveOperations;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class ShaderValidator {
    private static Boolean oshiAvailableCache = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderValidator] " + message);
    }

    private static boolean isOshiAvailable() {
        if (oshiAvailableCache != null) {
            return oshiAvailableCache;
        }
        try {
            Class<?> systemInfoClass = Class.forName("oshi.SystemInfo");
            ProtectionDomain protectionDomain = systemInfoClass.getProtectionDomain();
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource != null) {
                URL location = codeSource.getLocation();
                ShaderValidator.debugLog("OSHI library found!");
                ShaderValidator.debugLog("  Location: " + location);
                ShaderValidator.debugLog("  Protocol: " + location.getProtocol());
                ShaderValidator.debugLog("  Path: " + location.getPath());
                try {
                    File file = new File(location.toURI());
                    ShaderValidator.debugLog("  File: " + file.getAbsolutePath());
                    ShaderValidator.debugLog("  File size: " + file.length() + " bytes");
                    ShaderValidator.debugLog("  Exists: " + file.exists());
                    ShaderValidator.debugLog("  Is file: " + file.isFile());
                }
                catch (Exception e) {
                    ShaderValidator.debugLog("  Could not resolve to file: " + e.getMessage());
                }
            } else {
                ShaderValidator.debugLog("OSHI library found, but code source is null (might be loaded from system classloader)");
            }
            ClassLoader classLoader = systemInfoClass.getClassLoader();
            if (classLoader != null) {
                ShaderValidator.debugLog("  ClassLoader: " + classLoader.getClass().getName());
                ShaderValidator.debugLog("  ClassLoader toString: " + classLoader);
            } else {
                ShaderValidator.debugLog("  ClassLoader: Bootstrap ClassLoader (null)");
            }
            Package pkg = systemInfoClass.getPackage();
            if (pkg != null) {
                ShaderValidator.debugLog("  Package: " + pkg.getName());
                if (pkg.getImplementationTitle() != null) {
                    ShaderValidator.debugLog("  Implementation Title: " + pkg.getImplementationTitle());
                }
                if (pkg.getImplementationVersion() != null) {
                    ShaderValidator.debugLog("  Implementation Version: " + pkg.getImplementationVersion());
                }
                if (pkg.getImplementationVendor() != null) {
                    ShaderValidator.debugLog("  Implementation Vendor: " + pkg.getImplementationVendor());
                }
            }
            oshiAvailableCache = true;
            return true;
        }
        catch (ClassNotFoundException e) {
            ShaderValidator.debugLog("OSHI library not found: " + e.getMessage());
            oshiAvailableCache = false;
            return false;
        }
    }

    private static int determineOptimalThreadCountWithOshi() {
        try {
            Class<?> systemInfoClass = Class.forName("oshi.SystemInfo");
            Object systemInfo = systemInfoClass.newInstance();
            Object hardware = systemInfoClass.getMethod("getHardware", new Class[0]).invoke(systemInfo, new Object[0]);
            Object processor = hardware.getClass().getMethod("getProcessor", new Class[0]).invoke(hardware, new Object[0]);
            long[] prevTicks = (long[])processor.getClass().getMethod("getSystemCpuLoadTicks", new Class[0]).invoke(processor, new Object[0]);
            Thread.sleep(1000L);
            double cpuLoad = (Double)processor.getClass().getMethod("getSystemCpuLoadBetweenTicks", long[].class).invoke(processor, new Object[]{prevTicks});
            int availableProcessors = ShaderValidator.getAvailableProcessors();
            ShaderValidator.debugLog("CPU usage: " + String.format("%.1f%%", cpuLoad * 100.0) + ", Available processors: " + availableProcessors);
            int threadCount = cpuLoad < 0.5 ? Math.max(4, availableProcessors) : (cpuLoad < 0.8 ? Math.max(2, availableProcessors / 2) : Math.max(1, availableProcessors / 4));
            threadCount = Math.min(threadCount, availableProcessors);
            ShaderValidator.debugLog("OSHI determined optimal thread count: " + threadCount);
            return threadCount;
        }
        catch (Exception e) {
            ShaderValidator.debugLog("Error using OSHI: " + e.getMessage());
            return -1;
        }
    }

    private static int getAvailableProcessors() {
        return Math.max(1, Runtime.getRuntime().availableProcessors());
    }

    private static int determineOptimalThreadCount() {
        int threadCount;
        if (ShaderValidator.isOshiAvailable() && (threadCount = ShaderValidator.determineOptimalThreadCountWithOshi()) > 0) {
            return threadCount;
        }
        ShaderValidator.debugLog("OSHI not available, using fallback thread count calculation");
        int availableProcessors = ShaderValidator.getAvailableProcessors();
        ShaderValidator.debugLog("Available processors: " + availableProcessors);
        return Math.min(4, Math.max(1, availableProcessors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path validateByByteSizeParallel(List<Path> paths, ProgressCallback progressCallback) {
        if (paths == null || paths.isEmpty()) {
            return null;
        }
        int totalFiles = paths.size();
        AtomicInteger filesScanned = new AtomicInteger(0);
        int threadCount = ShaderValidator.determineOptimalThreadCount();
        EuphoriaPatcher.log(0, "Using " + threadCount + " threads for parallel validation of " + totalFiles + " files");
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(1);

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread t = new Thread(r, String.format("ShaderByteSizeFinder-%03d", this.threadNumber.getAndIncrement()));
                t.setDaemon(true);
                return t;
            }
        };
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, threadFactory);
        ExecutorCompletionService<Path> completionService = new ExecutorCompletionService<Path>(executor);
        try {
            for (Path path : paths) {
                completionService.submit(() -> {
                    int currentCount = filesScanned.incrementAndGet();
                    if (currentCount % 5 == 0 && progressCallback != null) {
                        progressCallback.onProgress(currentCount, totalFiles);
                    }
                    if (this.validateByByteSize(path, currentCount, totalFiles)) {
                        return path;
                    }
                    return null;
                });
            }
            for (int i = 0; i < totalFiles; ++i) {
                try {
                    Path result;
                    Future future = completionService.poll(30L, TimeUnit.SECONDS);
                    if (future == null || (result = (Path)future.get()) == null) continue;
                    ShaderValidator.debugLog("Found valid shader: " + result.getFileName());
                    executor.shutdownNow();
                    Path path = result;
                    return path;
                }
                catch (InterruptedException | ExecutionException e) {
                    ShaderValidator.debugLog("Error during parallel validation: " + e.getMessage());
                }
            }
            ShaderValidator.debugLog("No valid shader found after checking all " + totalFiles + " files");
            Path path = null;
            return path;
        }
        finally {
            executor.shutdownNow();
            try {
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    ShaderValidator.debugLog("Executor did not terminate cleanly");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean validateByByteSize(Path path, int filesScanned, int totalFiles) {
        try {
            ShaderValidator.debugLog("Validating shader by byte size (" + filesScanned + "/" + totalFiles + "): " + path.getFileName());
            Path tempDir = ArchiveOperations.createTempDirectory();
            if (tempDir == null) {
                ShaderValidator.debugLog("Failed to create temp directory for byte size validation");
                return false;
            }
            ShaderValidator.debugLog("Created temp directory: " + tempDir);
            String baseName = path.getFileName().toString().replace(".zip", "");
            ShaderValidator.debugLog("Base name for extraction: " + baseName);
            Path baseExtracted = tempDir.resolve(baseName);
            baseExtracted = ArchiveOperations.extract(path, baseExtracted, "extracting archive");
            if (baseExtracted == null) {
                ShaderValidator.debugLog("Failed to extract base for byte size validation");
                ArchiveOperations.deleteTempDirectory(tempDir);
                return false;
            }
            ShaderValidator.debugLog("Successfully extracted to: " + baseExtracted);
            Path baseArchived = tempDir.resolve(baseName + ".tar");
            baseArchived = ArchiveOperations.archive(baseExtracted, baseArchived);
            if (baseArchived == null) {
                ShaderValidator.debugLog("Failed to archive base for byte size validation");
                ArchiveOperations.deleteTempDirectory(tempDir);
                return false;
            }
            ShaderValidator.debugLog("Successfully archived to: " + baseArchived);
            boolean result = ArchiveOperations.verifyBaseArchiveQuiet(baseArchived);
            ShaderValidator.debugLog("Byte size verification result for " + path.getFileName() + ": " + result);
            ArchiveOperations.deleteTempDirectory(tempDir);
            return result;
        }
        catch (Exception e) {
            ShaderValidator.debugLog("Exception during byte size validation: " + e.getMessage());
            return false;
        }
    }

    public static interface ProgressCallback {
        public void onProgress(int var1, int var2);
    }
}

